/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.tasks;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.jphototagger.domain.repository.RepositoryDataExporter;
import org.jphototagger.domain.repository.RepositoryDataImporter;
import org.jphototagger.lib.comparator.FileLastModifiedDescendingComparator;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.io.filefilter.RegexFileFilter;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.app.ui.AppLookAndFeel;
import org.jphototagger.program.tasks.AutoBackupJptData;
import org.openide.util.Lookup;

public final class AutoBackupJptDataImporter {
    private static final Logger LOGGER = Logger.getLogger(AutoBackupJptDataImporter.class.getName());

    public static JMenuItem getMenuItem() {
        JMenu menu = new JMenu(Bundle.getString(AutoBackupJptDataImporter.class, "AutoBackupJptDataImporter.MenuItemText", new Object[0]));
        menu.setIcon(AppLookAndFeel.getIcon("icon_save.png"));
        for (List<File> fileset : AutoBackupJptDataImporter.getFilesets()) {
            if (fileset.isEmpty()) continue;
            menu.add(new JMenuItem(new ImportAction(fileset)));
        }
        return menu;
    }

    private static List<List<File>> getFilesets() {
        List<List<File>> filesOfSameType = AutoBackupJptDataImporter.getFilesOfSameType();
        ArrayList<List<File>> filesets = new ArrayList<List<File>>(filesOfSameType.size());
        int maxElementCount = AutoBackupJptDataImporter.getListMaxElementCount(filesOfSameType);
        for (int i = 0; i < maxElementCount; ++i) {
            ArrayList<File> fileset = new ArrayList<File>(maxElementCount);
            for (List<File> l : filesOfSameType) {
                int size = l.size();
                if (size <= 0) continue;
                fileset.add(l.get(i >= size ? size - 1 : i));
            }
            if (fileset.isEmpty()) continue;
            filesets.add(fileset);
        }
        return filesets;
    }

    private static int getListMaxElementCount(List<List<File>> files) {
        int max = 0;
        for (List<File> l : files) {
            int size = l.size();
            if (size <= max) continue;
            max = size;
        }
        return max;
    }

    private static List<List<File>> getFilesOfSameType() {
        List<String> filenamePatterns = AutoBackupJptDataImporter.getExportedFilenamePatterns();
        ArrayList<List<File>> files = new ArrayList<List<File>>(filenamePatterns.size());
        File backupDir = AutoBackupJptData.getAutoBackupDir();
        for (String pattern : filenamePatterns) {
            File[] fileArray = backupDir.listFiles(new RegexFileFilter(pattern, ""));
            if (fileArray == null || fileArray.length <= 0) continue;
            files.add(Arrays.asList(fileArray));
        }
        FileLastModifiedDescendingComparator cmp = new FileLastModifiedDescendingComparator();
        for (List list : files) {
            Collections.sort(list, cmp);
        }
        return files;
    }

    private static List<String> getExportedFilenamePatterns() {
        Collection<RepositoryDataExporter> allExporters = Lookup.getDefault().lookupAll(RepositoryDataExporter.class);
        ArrayList<RepositoryDataExporter> jptExporters = new ArrayList<RepositoryDataExporter>(allExporters.size());
        for (RepositoryDataExporter exporter : allExporters) {
            if (!exporter.isJPhotoTaggerData()) continue;
            jptExporters.add(exporter);
        }
        ArrayList<String> patterns = new ArrayList<String>(jptExporters.size());
        for (RepositoryDataExporter exporter : jptExporters) {
            String filename = exporter.getDefaultFilename();
            String prefix = FileUtil.getPrefix(new File(filename));
            patterns.add(prefix + ".*");
        }
        return patterns;
    }

    private AutoBackupJptDataImporter() {
    }

    private static class ImportAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final List<File> files;

        private ImportAction(List<File> files) {
            this.files = new ArrayList<File>(files);
            this.setName();
        }

        private void setName() {
            DateFormat df = DateFormat.getDateTimeInstance(2, 2);
            long newestFiletime = this.files.get(0).lastModified();
            String name = Bundle.getString(ImportAction.class, "AutoBackupJptDataImporter.ImportAction.Name", df.format(new Date(newestFiletime)));
            this.putValue("Name", name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.confirmImport()) {
                this.importFiles();
                this.messageImported();
            }
        }

        private void importFiles() {
            for (File file : this.files) {
                LOGGER.log(Level.INFO, "Importing auto backuped JPhotoTagger file ''{0}''", file);
                RepositoryDataImporter importer = this.findImporter(file);
                if (importer == null) {
                    LOGGER.log(Level.SEVERE, "Can''t find an importer for file ''{0}''", file);
                    continue;
                }
                importer.importFromFile(file);
            }
        }

        private RepositoryDataImporter findImporter(File file) {
            String defaultFilename = AutoBackupJptData.getDefaultFilename(file.getName());
            if (defaultFilename == null) {
                return null;
            }
            for (RepositoryDataImporter importer : Lookup.getDefault().lookupAll(RepositoryDataImporter.class)) {
                if (!defaultFilename.equals(importer.getDefaultFilename())) continue;
                return importer;
            }
            return null;
        }

        private boolean confirmImport() {
            Frame parent = ComponentUtil.findFrameWithIcon();
            String message = Bundle.getString(ImportAction.class, "ImportAction.ConfirmImport", this.getValue("Name"));
            return MessageDisplayer.confirmYesNo(parent, message);
        }

        private void messageImported() {
            Frame parent = ComponentUtil.findFrameWithIcon();
            String message = Bundle.getString(ImportAction.class, "ImportAction.MessageImported", new Object[0]);
            MessageDisplayer.information(parent, message);
        }
    }
}

