/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.tasks;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.api.applifecycle.AppExitTask;
import org.jphototagger.api.storage.PreferencesDirectoryProvider;
import org.jphototagger.domain.repository.Repository;
import org.jphototagger.domain.repository.RepositoryDataExporter;
import org.jphototagger.lib.io.FileUtil;
import org.openide.util.Lookup;

public final class AutoBackupJptData
implements AppExitTask {
    public static final String AUTO_BACKUP_DIRNAME = "Autobackup";
    private static final Logger LOGGER = Logger.getLogger(AutoBackupJptData.class.getName());
    private static final int MAX_VERSIONS = 5;

    @Override
    public void execute() {
        if (this.repositoryIsInit()) {
            this.export();
        }
    }

    private boolean repositoryIsInit() {
        Repository repo = Lookup.getDefault().lookup(Repository.class);
        return repo.isInit();
    }

    private void export() {
        LOGGER.info("Auto backup of JPhotoTagger data...");
        if (!this.ensureAutoBackupDir()) {
            return;
        }
        Collection<RepositoryDataExporter> allExporters = Lookup.getDefault().lookupAll(RepositoryDataExporter.class);
        ArrayList<RepositoryDataExporter> jptExporters = new ArrayList<RepositoryDataExporter>(allExporters.size());
        for (RepositoryDataExporter exporter : allExporters) {
            if (!exporter.isJPhotoTaggerData()) continue;
            jptExporters.add(exporter);
        }
        File backupDir = AutoBackupJptData.getAutoBackupDir();
        for (RepositoryDataExporter jptExporter : jptExporters) {
            String filename = jptExporter.getDefaultFilename();
            File file = this.createVersionedFile(backupDir, filename);
            try {
                LOGGER.log(Level.INFO, "Backing up JPhotoTagger data to file {0}", file);
                jptExporter.exportToFile(file);
            }
            catch (Throwable t) {
                Logger.getLogger(AutoBackupJptData.class.getName()).log(Level.SEVERE, null, t);
            }
        }
    }

    private File createVersionedFile(File backupDir, String filename) {
        File fileWithoutVersion = new File(backupDir.getAbsolutePath() + File.separator + filename);
        File[] files = backupDir.listFiles(new PrefixFilter(filename));
        if (files == null) {
            return this.getVersionedName(fileWithoutVersion, 0);
        }
        if (files.length < 5) {
            return this.getVersionedName(fileWithoutVersion, files.length);
        }
        File oldestFile = files[0];
        for (File file : files) {
            if (file.lastModified() >= oldestFile.lastModified()) continue;
            oldestFile = file;
        }
        return oldestFile;
    }

    private File getVersionedName(File file, int version) {
        String prefix = FileUtil.getAbsolutePathnamePrefix(file.getAbsolutePath());
        String suffix = FileUtil.getSuffix(file);
        return new File(prefix + '-' + Integer.toString(version) + '.' + suffix);
    }

    static String getDefaultFilename(String pathWithVersion) {
        int index = pathWithVersion.lastIndexOf(45);
        if (index < 0) {
            return null;
        }
        String suffix = FileUtil.getSuffix(new File(pathWithVersion));
        return pathWithVersion.substring(0, index) + '.' + suffix;
    }

    private boolean ensureAutoBackupDir() {
        File dir = AutoBackupJptData.getAutoBackupDir();
        if (!dir.isDirectory() && !dir.mkdirs()) {
            LOGGER.log(Level.WARNING, "Auto backup directory could not be created: {0}", dir);
            return false;
        }
        return true;
    }

    static File getAutoBackupDir() {
        PreferencesDirectoryProvider p = Lookup.getDefault().lookup(PreferencesDirectoryProvider.class);
        File prefDir = p.getPluginPreferencesDirectory();
        return new File(prefDir.getAbsolutePath() + File.separator + AUTO_BACKUP_DIRNAME);
    }

    private static class PrefixFilter
    implements FileFilter {
        private final String prefix;

        private PrefixFilter(String filename) {
            this.prefix = FileUtil.getPrefix(new File(filename));
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().startsWith(this.prefix);
        }
    }
}

