/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.settings;

import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.api.file.FilenameTokens;
import org.jphototagger.lib.util.PropertiesFile;
import org.jphototagger.lib.util.Settings;
import org.jphototagger.lib.util.SortedProperties;

final class UserPreferences {
    private static final String DOMAIN_NAME = "de.elmar_baumann";
    private static final String PROPERTIES_FILENAME = "Settings.properties";
    private final Properties properties = new SortedProperties();
    private final PropertiesFile propertiesFile = new PropertiesFile("de.elmar_baumann", "ImageMetaDataViewer", "Settings.properties", this.properties);
    private final Settings settings = new Settings(this.properties);
    static final UserPreferences INSTANCE = new UserPreferences();

    private UserPreferences() {
        this.propertiesFile.readFromFile();
        this.settings.removeKeysWithEmptyValues();
        this.writeToFile();
    }

    Settings getSettings() {
        return this.settings;
    }

    void writeToFile() {
        try {
            this.propertiesFile.writeToFile();
        }
        catch (Throwable t) {
            Logger.getLogger(UserPreferences.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    String getSettingsDirectoryName() {
        return this.propertiesFile.getDirectoryName();
    }

    String getRepositoryDirectoryName() {
        return this.properties.containsKey("UserSettings.DatabaseDirectoryName") ? this.settings.getString("UserSettings.DatabaseDirectoryName") : this.getDefaultRepositoryDirectoryName();
    }

    String getDefaultRepositoryDirectoryName() {
        return this.getSettingsDirectoryName();
    }

    String getRepositoryFileName(FilenameTokens filenameTokens) {
        if (filenameTokens == null) {
            throw new NullPointerException("filenameTokens == null");
        }
        if (!filenameTokens.equals((Object)FilenameTokens.FULL_PATH) && !filenameTokens.equals((Object)FilenameTokens.FULL_PATH_NO_SUFFIX)) {
            throw new IllegalArgumentException("Illegal argument: " + (Object)((Object)filenameTokens));
        }
        String directoryName = this.getRepositoryDirectoryName();
        String fileBasename = UserPreferences.getRepositoryBasename();
        boolean isFullPath = filenameTokens.equals((Object)FilenameTokens.FULL_PATH);
        String suffix = isFullPath ? ".data" : "";
        return directoryName + File.separator + fileBasename + suffix;
    }

    static String getRepositoryBasename() {
        return "database";
    }

    String getThumbnailsDirectoryName() {
        return this.getRepositoryDirectoryName() + File.separator + UserPreferences.getThumbnailsDirectoryBasename();
    }

    static String getThumbnailsDirectoryBasename() {
        return "thumbnails";
    }
}

