/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.settings;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.storage.Persistence;
import org.jphototagger.lib.api.LookAndFeelChangedEvent;
import org.jphototagger.lib.help.HelpPageProvider;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.TabbedPaneSearchPanel;
import org.jphototagger.lib.swing.util.TabbedPaneUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.StringUtil;
import org.jphototagger.program.misc.MiscSettingsPanel;
import org.jphototagger.program.misc.PerformanceSettingsPanel;
import org.jphototagger.program.misc.ScheduledTasksSettingsPanel;
import org.jphototagger.program.module.actions.ActionsSettingsPanel;
import org.jphototagger.program.module.fileexcludepatterns.FileExcludePatternsSettingsPanel;
import org.jphototagger.program.module.programs.ProgramsSettingsPanel;
import org.jphototagger.program.module.thumbnails.ThumbnailsSettingsPanel;
import org.jphototagger.program.plugins.PluginsSettingsPanel;
import org.jphototagger.program.resource.GUI;
import org.jphototagger.program.settings.DisplayMessagesInFutureSettingsPanel;
import org.openide.util.Lookup;

public final class SettingsDialog
extends Dialog {
    private static final String KEY_INDEX_TABBED_PANE = "UserSettingsDialog.TabbedPaneIndex";
    private static final long serialVersionUID = 1L;
    private final Map<Tab, Integer> indexOfTab = new EnumMap<Tab, Integer>(Tab.class);
    private final Map<Integer, Tab> tabOfIndex = new HashMap<Integer, Tab>();
    private final Map<Component, String> helpUrlOfComponent = new HashMap<Component, String>();
    private final List<Persistence> persistentPanels = new ArrayList<Persistence>();
    public static final SettingsDialog INSTANCE = new SettingsDialog();
    private ActionsSettingsPanel panelActions;
    private DisplayMessagesInFutureSettingsPanel panelDisplayMessagesInFuture;
    private FileExcludePatternsSettingsPanel panelFileExcludePatterns;
    private MiscSettingsPanel panelMisc;
    private PerformanceSettingsPanel panelPerformance;
    private PluginsSettingsPanel panelPlugins;
    private ProgramsSettingsPanel panelPrograms;
    private TabbedPaneSearchPanel panelSearch;
    private ScheduledTasksSettingsPanel panelTasks;
    private ThumbnailsSettingsPanel panelThumbnails;
    private JTabbedPane tabbedPane;

    private SettingsDialog() {
        super((Frame)GUI.getAppFrame(), false);
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.initMaps();
        this.initPersistentPanels();
        this.readProperties();
        TabbedPaneUtil.setMnemonics(this.tabbedPane);
        this.initSearchPanel();
        AnnotationProcessor.process(this);
    }

    private void initMaps() {
        this.indexOfTab.put(Tab.PROGRAMS, 0);
        this.indexOfTab.put(Tab.THUMBNAILS, 1);
        this.indexOfTab.put(Tab.TASKS, 2);
        this.indexOfTab.put(Tab.PERFORMANCE, 3);
        this.indexOfTab.put(Tab.FILE_EXCLUDE_PATTERNS, 4);
        this.indexOfTab.put(Tab.MISC, 5);
        this.indexOfTab.put(Tab.ACTIONS, 6);
        this.indexOfTab.put(Tab.PLUGINS, 7);
        this.indexOfTab.put(Tab.DISPLAY_IN_FUTURE, 8);
        for (Tab tab : this.indexOfTab.keySet()) {
            this.tabOfIndex.put(this.indexOfTab.get((Object)tab), tab);
        }
        for (int index = 0; index < this.tabbedPane.getTabCount(); ++index) {
            Component component = this.tabbedPane.getComponentAt(index);
            if (component instanceof HelpPageProvider) {
                HelpPageProvider helpPageProvider = (HelpPageProvider)((Object)component);
                this.helpUrlOfComponent.put(component, helpPageProvider.getHelpPageUrl());
                continue;
            }
            this.helpUrlOfComponent.put(component, "");
        }
    }

    private void initPersistentPanels() {
        int tabCount = this.tabbedPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            Component c = this.tabbedPane.getComponentAt(i);
            if (!(c instanceof Persistence)) continue;
            this.persistentPanels.add((Persistence)((Object)c));
        }
    }

    private void initSearchPanel() {
        this.panelSearch.setParentPane(this.tabbedPane);
        this.panelSearch.addSearchWordsTo(StringUtil.getWordsOf(Bundle.getString(SettingsDialog.class, "SettingsDialog.AdditionalSearchWords.PanelThumbnails", new Object[0])), this.panelThumbnails);
        this.panelSearch.addSearchWordsTo(StringUtil.getWordsOf(Bundle.getString(SettingsDialog.class, "SettingsDialog.AdditionalSearchWords.PanelTasks", new Object[0])), this.panelTasks);
        this.panelSearch.addSearchWordsTo(StringUtil.getWordsOf(Bundle.getString(SettingsDialog.class, "SettingsDialog.AdditionalSearchWords.PanelPerformance", new Object[0])), this.panelPerformance);
        this.panelSearch.addSearchWordsTo(StringUtil.getWordsOf(Bundle.getString(SettingsDialog.class, "SettingsDialog.AdditionalSearchWords.PanelExclude", new Object[0])), this.panelFileExcludePatterns);
        this.panelSearch.addSearchWordsTo(StringUtil.getWordsOf(Bundle.getString(SettingsDialog.class, "SettingsDialog.AdditionalSearchWords.PanelPlugins", new Object[0])), this.panelPlugins);
        this.panelSearch.addSearchWordsTo(StringUtil.getWordsOf(Bundle.getString(SettingsDialog.class, "SettingsDialog.AdditionalSearchWords.PanelMiscMisc", new Object[0])), this.panelMisc);
    }

    public void selectTab(Tab tab) {
        if (tab == null) {
            throw new NullPointerException("tab == null");
        }
        int index = this.indexOfTab.get((Object)tab);
        if (index >= 0 && index < this.tabbedPane.getComponentCount()) {
            this.tabbedPane.setSelectedIndex(index);
        }
    }

    private void readProperties() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        String key = this.getClass().getName();
        prefs.applySize(key, this);
        prefs.applyLocation(key, this);
        prefs.applyTabbedPaneSettings(KEY_INDEX_TABBED_PANE, this.tabbedPane, null);
        for (Persistence panel : this.persistentPanels) {
            panel.restore();
        }
    }

    private void writeProperties() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setTabbedPane(KEY_INDEX_TABBED_PANE, this.tabbedPane, null);
        for (Persistence panel : this.persistentPanels) {
            panel.persist();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.panelSearch.focusSearchTextfield();
        } else {
            this.writeProperties();
        }
        super.setVisible(visible);
    }

    @Override
    protected void showHelp() {
        this.showHelp(this.helpUrlOfComponent.get(this.tabbedPane.getSelectedComponent()));
    }

    @Override
    protected void escape() {
        this.setVisible(false);
    }

    public JButton getButtonScheduledTasks() {
        return this.panelTasks.getButtonScheduledTasks();
    }

    @EventSubscriber(eventClass=LookAndFeelChangedEvent.class)
    public void lookAndFeelChanged(LookAndFeelChangedEvent evt) {
        SwingUtilities.updateComponentTreeUI(this);
    }

    private void initComponents() {
        this.panelSearch = new TabbedPaneSearchPanel();
        this.tabbedPane = new JTabbedPane();
        this.panelPrograms = new ProgramsSettingsPanel();
        this.panelThumbnails = new ThumbnailsSettingsPanel();
        this.panelTasks = new ScheduledTasksSettingsPanel();
        this.panelPerformance = new PerformanceSettingsPanel();
        this.panelFileExcludePatterns = new FileExcludePatternsSettingsPanel();
        this.panelMisc = new MiscSettingsPanel();
        this.panelActions = new ActionsSettingsPanel();
        this.panelPlugins = new PluginsSettingsPanel();
        this.panelDisplayMessagesInFuture = new DisplayMessagesInFutureSettingsPanel();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/settings/Bundle");
        this.setTitle(bundle.getString("SettingsDialog.title"));
        this.setName("Form");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SettingsDialog.this.formWindowClosing(evt);
            }
        });
        this.panelSearch.setName("panelSearch");
        this.tabbedPane.setName("tabbedPane");
        this.panelPrograms.setName("panelPrograms");
        this.tabbedPane.addTab(bundle.getString("SettingsDialog.panelPrograms.TabConstraints.tabTitle"), this.panelPrograms);
        this.panelThumbnails.setName("panelThumbnails");
        this.tabbedPane.addTab(bundle.getString("SettingsDialog.panelThumbnails.TabConstraints.tabTitle"), this.panelThumbnails);
        this.panelTasks.setName("panelTasks");
        this.tabbedPane.addTab(bundle.getString("SettingsDialog.panelTasks.TabConstraints.tabTitle"), this.panelTasks);
        this.panelPerformance.setName("panelPerformance");
        this.tabbedPane.addTab(bundle.getString("SettingsDialog.panelPerformance.TabConstraints.tabTitle"), this.panelPerformance);
        this.panelFileExcludePatterns.setName("panelFileExcludePatterns");
        this.tabbedPane.addTab(bundle.getString("SettingsDialog.panelFileExcludePatterns.TabConstraints.tabTitle"), this.panelFileExcludePatterns);
        this.panelMisc.setName("panelMisc");
        this.tabbedPane.addTab(bundle.getString("SettingsDialog.panelMisc.TabConstraints.tabTitle"), this.panelMisc);
        this.panelActions.setName("panelActions");
        this.tabbedPane.addTab(bundle.getString("SettingsDialog.panelActions.TabConstraints.tabTitle"), this.panelActions);
        this.panelPlugins.setName("panelPlugins");
        this.tabbedPane.addTab(bundle.getString("SettingsDialog.panelPlugins.TabConstraints.tabTitle"), this.panelPlugins);
        this.panelDisplayMessagesInFuture.setName("panelDisplayMessagesInFuture");
        this.tabbedPane.addTab(bundle.getString("SettingsDialog.panelDisplayMessagesInFuture.TabConstraints.tabTitle"), this.panelDisplayMessagesInFuture);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.panelSearch, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabbedPane, -2, 583, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.panelSearch, GroupLayout.Alignment.LEADING, -1, 496, Short.MAX_VALUE).addComponent(this.tabbedPane, GroupLayout.Alignment.LEADING, -1, 496, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.writeProperties();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SettingsDialog dialog = INSTANCE;
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public static enum Tab {
        ACTIONS,
        FILE_EXCLUDE_PATTERNS,
        MISC,
        PERFORMANCE,
        PLUGINS,
        PROGRAMS,
        TASKS,
        THUMBNAILS,
        DISPLAY_IN_FUTURE;

    }
}

