/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.settings;

import java.awt.Component;
import java.awt.Window;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import org.bushe.swing.event.EventBus;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesChangedEvent;
import org.jphototagger.api.preferences.PreferencesHints;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.util.ObjectUtil;
import org.jphototagger.lib.util.Settings;
import org.jphototagger.program.settings.UserPreferences;

public final class PreferencesImpl
implements Preferences {
    private final Settings settings = UserPreferences.INSTANCE.getSettings();

    @Override
    public String getString(String key) {
        return this.settings.getString(key);
    }

    @Override
    public void setString(String key, String value) {
        String oldValue = this.settings.getString(key);
        boolean containsKey = this.settings.containsKey(key);
        if (!containsKey || !ObjectUtil.equals(value, oldValue)) {
            this.settings.set(key, value);
            this.writeToFile();
            EventBus.publish(new PreferencesChangedEvent(this, key, oldValue, value));
        }
    }

    @Override
    public void removeKey(String key) {
        String oldValue = this.settings.getString(key);
        this.settings.removeKey(key);
        this.writeToFile();
        EventBus.publish(new PreferencesChangedEvent(this, key, oldValue, null));
    }

    @Override
    public void setBoolean(String key, boolean value) {
        boolean oldValue = this.settings.getBoolean(key);
        boolean containsKey = this.settings.containsKey(key);
        if (!containsKey || value != oldValue) {
            this.settings.set(key, value);
            this.writeToFile();
            EventBus.publish(new PreferencesChangedEvent(this, key, oldValue, value));
        }
    }

    @Override
    public int getInt(String key) {
        return this.settings.getInt(key);
    }

    @Override
    public void setInt(String key, int value) {
        int oldValue = this.settings.getInt(key);
        boolean containsKey = this.settings.containsKey(key);
        if (!containsKey || value != oldValue) {
            this.settings.set(key, value);
            this.writeToFile();
            EventBus.publish(new PreferencesChangedEvent(this, key, oldValue, value));
        }
    }

    @Override
    public void setSize(String key, Component component) {
        this.settings.setSize(key, component);
        this.writeToFile();
    }

    @Override
    public void applySize(String key, Component component) {
        this.settings.applySize(key, component);
    }

    @Override
    public void setLocation(String key, Component component) {
        this.settings.setLocation(key, component);
        this.writeToFile();
    }

    @Override
    public void applyLocation(String key, Component component) {
        boolean applied = this.settings.applyLocation(key, component);
        if (!applied && component instanceof Window) {
            ComponentUtil.centerScreen((Window)component);
        }
    }

    @Override
    public boolean getBoolean(String key) {
        return this.settings.getBoolean(key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.settings.containsKey(key);
    }

    @Override
    public boolean containsLocationKey(String key) {
        return this.settings.containsLocationKey(key);
    }

    @Override
    public boolean containsSizeKey(String key) {
        return this.settings.containsSizeKey(key);
    }

    private void writeToFile() {
        UserPreferences.INSTANCE.writeToFile();
    }

    @Override
    public void setStringCollection(String key, Collection<? extends String> stringCollection) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (stringCollection == null) {
            throw new NullPointerException("stringCollection == null");
        }
        List<String> oldValue = this.settings.getStringCollection(key);
        this.settings.setStringCollection(key, stringCollection);
        this.writeToFile();
        EventBus.publish(new PreferencesChangedEvent(this, key, oldValue, stringCollection));
    }

    @Override
    public List<String> getStringCollection(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        return this.settings.getStringCollection(key);
    }

    @Override
    public void setTree(String key, JTree tree) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (tree == null) {
            throw new NullPointerException("tree == null");
        }
        this.settings.set(key, tree);
        this.writeToFile();
        EventBus.publish(new PreferencesChangedEvent(this, key, null, tree));
    }

    @Override
    public void applyTreeSettings(String key, JTree tree) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (tree == null) {
            throw new NullPointerException("tree == null");
        }
        this.settings.applySettings(key, tree);
    }

    @Override
    public void setScrollPane(String key, JScrollPane scrollPane) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (scrollPane == null) {
            throw new NullPointerException("scrollPane == null");
        }
        this.settings.set(key, scrollPane);
        this.writeToFile();
        EventBus.publish(new PreferencesChangedEvent(this, key, null, scrollPane));
    }

    @Override
    public void applyScrollPaneSettings(String key, JScrollPane scrollPane) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (scrollPane == null) {
            throw new NullPointerException("scrollPane == null");
        }
        this.settings.applySettings(key, scrollPane);
    }

    @Override
    public void setToggleButton(String key, JToggleButton button) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (button == null) {
            throw new NullPointerException("button == null");
        }
        this.settings.set(key, button);
        this.writeToFile();
        EventBus.publish(new PreferencesChangedEvent(this, key, null, button));
    }

    @Override
    public void applyToggleButtonSettings(String key, JToggleButton button) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (button == null) {
            throw new NullPointerException("button == null");
        }
        this.settings.applySettings(key, button);
    }

    @Override
    public void setTabbedPane(String key, JTabbedPane pane, PreferencesHints hints) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        this.settings.set(key, pane, hints);
        this.writeToFile();
        EventBus.publish(new PreferencesChangedEvent(this, key, null, pane));
    }

    @Override
    public void applyTabbedPaneSettings(String key, JTabbedPane pane, PreferencesHints hints) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        this.settings.applySettings(key, pane, hints);
    }

    @Override
    public void setComponent(Component component, PreferencesHints hints) {
        if (component == null) {
            throw new NullPointerException("component == null");
        }
        this.settings.set(component, hints);
        this.writeToFile();
        EventBus.publish(new PreferencesChangedEvent(this, component.getClass().getName(), null, component));
    }

    @Override
    public void applyComponentSettings(Component component, PreferencesHints hints) {
        if (component == null) {
            throw new NullPointerException("component == null");
        }
        this.settings.applySettings(component, hints);
    }

    @Override
    public void setSelectedIndex(String key, JComboBox<?> comboBox) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (comboBox == null) {
            throw new NullPointerException("comboBox == null");
        }
        this.settings.setSelectedIndex(key, comboBox);
        this.writeToFile();
        EventBus.publish(new PreferencesChangedEvent(this, key, null, comboBox));
    }

    @Override
    public void applySelectedIndex(String key, JComboBox<?> comboBox) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (comboBox == null) {
            throw new NullPointerException("comboBox == null");
        }
        this.settings.applySelectedIndex(key, comboBox);
    }

    @Override
    public void setSelectedIndices(String key, JList<?> list) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (list == null) {
            throw new NullPointerException("list == null");
        }
        this.settings.setSelectedIndices(key, list);
        this.writeToFile();
        EventBus.publish(new PreferencesChangedEvent(this, key, null, list));
    }

    @Override
    public void applySelectedIndices(String key, JList<?> list) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (list == null) {
            throw new NullPointerException("list == null");
        }
        this.settings.applySelectedIndices(key, list);
    }

    @Override
    public void removeStringCollection(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        this.settings.removeStringCollection(key);
        this.writeToFile();
        EventBus.publish(new PreferencesChangedEvent(this, key, null, null));
    }

    @Override
    public Set<String> keys() {
        return this.settings.keys();
    }
}

