/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.settings;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.DisplayMessageInFuturePreferencesKeys;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesChangedEvent;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.openide.util.Lookup;

public class DisplayMessagesInFutureSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final Map<JCheckBox, String> keyOfCheckBox = new HashMap<JCheckBox, String>();
    private final Map<String, JCheckBox> checkBoxOfKey = new HashMap<String, JCheckBox>();
    private boolean listenToCheckBox;
    private final ActionListener changeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DisplayMessagesInFutureSettingsPanel.this.listenToCheckBox) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                String key = (String)DisplayMessagesInFutureSettingsPanel.this.keyOfCheckBox.get(checkBox);
                Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
                prefs.setBoolean(key, checkBox.isSelected());
            }
        }
    };

    public DisplayMessagesInFutureSettingsPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.addCheckBoxes();
        this.initCheckBoxes();
        this.listenToCheckBox = true;
        AnnotationProcessor.process(this);
    }

    private void addCheckBoxes() {
        Collection<DisplayMessageInFuturePreferencesKeys.KeyInfo> keyInfos = this.lookupKeyInfos();
        int size = keyInfos.size();
        int index = 0;
        for (DisplayMessageInFuturePreferencesKeys.KeyInfo keyInfo : keyInfos) {
            JCheckBox checkBox = new JCheckBox(keyInfo.getLocalizedDisplayName());
            String key = keyInfo.getKey();
            checkBox.addActionListener(this.changeListener);
            this.keyOfCheckBox.put(checkBox, key);
            this.checkBoxOfKey.put(key, checkBox);
            this.addCheckBox(checkBox, ++index == size);
        }
    }

    private Collection<DisplayMessageInFuturePreferencesKeys.KeyInfo> lookupKeyInfos() {
        LinkedHashSet<DisplayMessageInFuturePreferencesKeys.KeyInfo> keyInfos = new LinkedHashSet<DisplayMessageInFuturePreferencesKeys.KeyInfo>();
        Collection<DisplayMessageInFuturePreferencesKeys> allKeys = Lookup.getDefault().lookupAll(DisplayMessageInFuturePreferencesKeys.class);
        if (allKeys == null) {
            return keyInfos;
        }
        for (DisplayMessageInFuturePreferencesKeys key : allKeys) {
            keyInfos.addAll(key.getKeyInfos());
        }
        return keyInfos;
    }

    private void addCheckBox(JCheckBox checkBox, boolean isLast) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = isLast ? 1.0 : 0.0;
        gbc.insets = new Insets(0, 5, 3, 5);
        this.add((Component)checkBox, gbc);
    }

    private void initCheckBoxes() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        if (prefs == null) {
            return;
        }
        Iterator<JCheckBox> i$ = this.keyOfCheckBox.keySet().iterator();
        while (i$.hasNext()) {
            JCheckBox checkBox;
            String key = this.keyOfCheckBox.get(checkBox = i$.next());
            boolean keyDefined = prefs.containsKey(key);
            checkBox.setSelected(keyDefined ? prefs.getBoolean(key) : true);
        }
    }

    @EventSubscriber(eventClass=PreferencesChangedEvent.class)
    public void userPropertyChanged(PreferencesChangedEvent evt) {
        String propertyKey = evt.getKey();
        if ("WarnOnEqualBasenamesTaskDialog.DisplayInFuture".equals(propertyKey)) {
            this.listenToCheckBox = false;
            JCheckBox checkBox = this.checkBoxOfKey.get(propertyKey);
            if (checkBox != null) {
                boolean newValue = (Boolean)evt.getNewValue();
                checkBox.setSelected(newValue);
                ComponentUtil.forceRepaint(checkBox);
            }
            this.listenToCheckBox = true;
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
    }
}

