/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.plugins;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import org.jphototagger.api.plugin.Plugin;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.storage.Persistence;
import org.jphototagger.lib.help.HelpPageProvider;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.factory.FileProcessorPluginManager;
import org.jphototagger.program.factory.PluginManager;
import org.openide.util.Lookup;

public class PluginsSettingsPanel
extends JPanel
implements Persistence,
HelpPageProvider {
    private static final long serialVersionUID = 1L;
    private static final String KEY_TABBED_PANE = "SettingsPluginsPanel.TabbedPane";
    private ButtonGroup buttonGroup;
    private JLabel labelInfoExclude;
    private JPanel panelExclude;
    private JPanel panelExcludeCheckboxes;
    private JScrollPane scrollPaneExclude;
    private JTabbedPane tabbedPane;

    public PluginsSettingsPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.addPlugins(FileProcessorPluginManager.INSTANCE);
        this.panelExcludeCheckboxes.add((Component)new JPanel(), this.getGbcAfterLastCheckBox());
        MnemonicUtil.setMnemonics(this);
    }

    private <T extends Plugin> void addPlugins(PluginManager<T> pluginManager) {
        for (Plugin plugin : pluginManager.getEnabledPlugins()) {
            if (!plugin.isAvailable()) continue;
            this.addPluginSettingsComponent(plugin);
        }
        for (Plugin plugin : pluginManager.getAllPlugins()) {
            if (!plugin.isAvailable()) continue;
            this.addPluginEnableCheckBox(pluginManager, plugin);
        }
    }

    private void addPluginSettingsComponent(Plugin plugin) {
        Component component = plugin.getSettingsComponent();
        if (component != null) {
            this.tabbedPane.add(plugin.getDisplayName(), component);
        }
    }

    private <T extends Plugin> void addPluginEnableCheckBox(PluginManager<T> pluginManager, T plugin) {
        ActionExcludePlugin<T> actionExcludePlugin = new ActionExcludePlugin<T>(pluginManager, plugin);
        JCheckBox checkBox = new JCheckBox(actionExcludePlugin);
        checkBox.setSelected(pluginManager.isEnabled(plugin));
        this.panelExcludeCheckboxes.add((Component)checkBox, this.getGbcCheckBox());
    }

    private GridBagConstraints getGbcCheckBox() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.anchor = 18;
        gbc.fill = 0;
        return gbc;
    }

    private GridBagConstraints getGbcAfterLastCheckBox() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.anchor = 15;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        return gbc;
    }

    @Override
    public void restore() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.applyTabbedPaneSettings(KEY_TABBED_PANE, this.tabbedPane, null);
    }

    @Override
    public void persist() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setTabbedPane(KEY_TABBED_PANE, this.tabbedPane, null);
    }

    @Override
    public String getHelpPageUrl() {
        return Bundle.getString(PluginsSettingsPanel.class, "PluginsSettingsPanel.HelpPage", new Object[0]);
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.tabbedPane = new JTabbedPane();
        this.panelExclude = new JPanel();
        this.labelInfoExclude = new JLabel();
        this.scrollPaneExclude = new JScrollPane();
        this.panelExcludeCheckboxes = new JPanel();
        this.setName("Form");
        this.tabbedPane.setTabLayoutPolicy(1);
        this.tabbedPane.setName("tabbedPane");
        this.panelExclude.setName("panelExclude");
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/plugins/Bundle");
        this.labelInfoExclude.setText(bundle.getString("PluginsSettingsPanel.labelInfoExclude.text"));
        this.labelInfoExclude.setName("labelInfoExclude");
        this.scrollPaneExclude.setAlignmentX(0.0f);
        this.scrollPaneExclude.setAlignmentY(0.0f);
        this.scrollPaneExclude.setName("scrollPaneExclude");
        this.panelExcludeCheckboxes.setName("panelExcludeCheckboxes");
        this.panelExcludeCheckboxes.setLayout(new GridBagLayout());
        this.scrollPaneExclude.setViewportView(this.panelExcludeCheckboxes);
        GroupLayout panelExcludeLayout = new GroupLayout(this.panelExclude);
        this.panelExclude.setLayout(panelExcludeLayout);
        panelExcludeLayout.setHorizontalGroup(panelExcludeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelExcludeLayout.createSequentialGroup().addContainerGap().addGroup(panelExcludeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPaneExclude, -1, 475, Short.MAX_VALUE).addComponent(this.labelInfoExclude)).addContainerGap()));
        panelExcludeLayout.setVerticalGroup(panelExcludeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelExcludeLayout.createSequentialGroup().addContainerGap().addComponent(this.labelInfoExclude).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPaneExclude, -1, 195, Short.MAX_VALUE).addContainerGap()));
        this.tabbedPane.addTab(bundle.getString("PluginsSettingsPanel.panelExclude.TabConstraints.tabTitle"), this.panelExclude);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane, -1, 504, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane, -1, 267, Short.MAX_VALUE));
    }

    private static class ActionExcludePlugin<T extends Plugin>
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final transient T plugin;
        private final transient PluginManager<T> pluginManager;

        ActionExcludePlugin(PluginManager<T> pluginManager, T plugin) {
            this.pluginManager = pluginManager;
            this.plugin = plugin;
            this.putValue("Name", plugin.getDisplayName());
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JCheckBox cb = (JCheckBox)evt.getSource();
            this.pluginManager.setEnabled(this.plugin, cb.isSelected());
        }
    }
}

