/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.plugins;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.plugin.fileprocessor.FileProcessedEvent;
import org.jphototagger.api.plugin.fileprocessor.FileProcessorPlugin;
import org.jphototagger.program.module.thumbnails.ThumbnailsPopupMenu;
import org.jphototagger.program.plugins.PluginAction;
import org.jphototagger.program.resource.GUI;

public final class FileProcessorPluginsController
implements ActionListener {
    public FileProcessorPluginsController() {
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process(this);
        for (JMenuItem item : ThumbnailsPopupMenu.INSTANCE.getFileProcessorPluginMenuItems()) {
            item.addActionListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        PluginAction pluginAction;
        Object plugin;
        JMenuItem item;
        Action action;
        Object src = evt.getSource();
        List<File> selFiles = GUI.getSelectedImageFiles();
        if (selFiles.size() > 0 && (action = ThumbnailsPopupMenu.INSTANCE.getActionOfItem(item = (JMenuItem)src)) instanceof PluginAction && (plugin = (pluginAction = (PluginAction)action).getPlugin()) instanceof FileProcessorPlugin) {
            FileProcessorPlugin fileProcessorPlugin = (FileProcessorPlugin)plugin;
            fileProcessorPlugin.processFiles(selFiles);
        }
    }

    @EventSubscriber(eventClass=FileProcessedEvent.class)
    public void fileProcessed(FileProcessedEvent evt) {
        if (evt.isFileChanged()) {
            GUI.getThumbnailsPanel().repaintFile(evt.getFile());
        }
    }
}

