/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.wordsets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.applifecycle.AppWillExitEvent;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.event.listener.ListenerSupport;
import org.jphototagger.domain.repository.WordsetsRepository;
import org.jphototagger.domain.repository.event.wordsets.WordsetUpdatedEvent;
import org.jphototagger.domain.wordsets.Wordset;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.MouseEventUtil;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.StringUtil;
import org.jphototagger.program.module.wordsets.EditWordsetDialog;
import org.jphototagger.program.module.wordsets.WordsetNamesComboBoxModel;
import org.jphototagger.program.module.wordsets.WordsetPreferences;
import org.jphototagger.program.module.wordsets.WordsetsPanelListener;
import org.openide.util.Lookup;

public class WordsetsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Color LABEL_EDITABLE_BACKGROUND_COLOR = new Color(248, 248, 248);
    private static final Color LABEL_EDITABLE_FOREGROUND_COLOR = Color.BLACK;
    private static final Border LABEL_BORDER = BorderFactory.createLineBorder(Color.BLACK);
    private static final int AUTOMATIC_WORDSET_MAX_WORDCOUNT = 9;
    private final String[] automaticAddedWordsRingbuffer = new String[9];
    private final List<JLabel> wordLabels = new ArrayList<JLabel>();
    private final ListenerSupport<WordsetsPanelListener> listenerSupport = new ListenerSupport();
    private final Wordset automaticWordset = this.createAutomaticWordset();
    private Wordset selectedWordset;
    private String persistenceKeyPrefix;
    private boolean editable = true;
    private final MouseListener wordClickedListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (MouseEventUtil.isLeftClick(e)) {
                JLabel label = (JLabel)e.getSource();
                String word = label.getText();
                WordsetsPanel.this.notifyWordClicked(word);
            }
        }
    };
    private final ListCellRenderer<Object> wordsetNamesComboBoxRenderer = new DefaultListCellRenderer(){
        private static final long serialVersionUID = 1L;
        private final String AUTOMATIC_WORDSET_NAME = Bundle.getString(WordsetsPanel.class, "WordsetsPanel.ListCellRenderer.AutomaticWordsetName", new Object[0]);

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if ("JPhotoTagger Automatic Wordset".equals(value)) {
                label.setText(this.AUTOMATIC_WORDSET_NAME);
            }
            return label;
        }
    };
    private JButton buttonAddWordset;
    private JButton buttonEditWordset;
    private JButton buttonEraseAutomaticWords;
    private JButton buttonRemoveWordset;
    private JComboBox<Object> comboBoxWordsetNames;
    private JPanel panelWords;
    private JPanel panelWordsets;

    public WordsetsPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.initAutomaticAddedWordsRingbuffer();
        this.setWordsOfSelectedWordsetName();
        this.listen();
    }

    private void initAutomaticAddedWordsRingbuffer() {
        for (int i = 0; i < 9; ++i) {
            this.automaticAddedWordsRingbuffer[i] = "";
        }
    }

    private void listen() {
        AnnotationProcessor.process(this);
    }

    public void setPersistenceKeyPrefix(String prefix) {
        if (prefix == null) {
            throw new NullPointerException("prefix == null");
        }
        this.persistenceKeyPrefix = prefix;
        this.addPersistedWordsToWordset(this.automaticWordset);
        this.setAutomaticAddedWordsRingbuffer();
        this.initSelectComboBoxItem();
    }

    private void setAutomaticAddedWordsRingbuffer() {
        List<String> words = this.automaticWordset.getWords();
        int size = words.size();
        for (int i = 0; i < 9; ++i) {
            this.automaticAddedWordsRingbuffer[i] = i < size ? words.get(i) : "";
        }
    }

    private void initSelectComboBoxItem() {
        int index;
        String key;
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        if (prefs != null && this.persistenceKeyPrefix != null && prefs.containsKey(key = this.createComboBoxSelectedIndexPersistenceKey()) && (index = prefs.getInt(key)) >= 0 && index < this.comboBoxWordsetNames.getItemCount()) {
            this.comboBoxWordsetNames.setSelectedIndex(index);
        }
    }

    @EventSubscriber(eventClass=WordsetUpdatedEvent.class)
    public void wordsetUpdated(WordsetUpdatedEvent evt) {
        Wordset newWordset = evt.getNewWordset();
        long newWordsetId = newWordset.getId();
        if (this.selectedWordset != null && this.selectedWordset.getId() == newWordsetId) {
            this.setWordsOfSelectedWordsetName();
        }
    }

    private void setWordsOfSelectedWordsetName() {
        String wordsetName;
        this.panelWords.removeAll();
        this.wordLabels.clear();
        WordsetsRepository repository = Lookup.getDefault().lookup(WordsetsRepository.class);
        if (repository != null && (wordsetName = (String)this.comboBoxWordsetNames.getSelectedItem()) != null) {
            Wordset wordset = this.selectedWordset = this.isAutomaticWordsetSelected() ? this.automaticWordset : repository.find(wordsetName);
            if (this.selectedWordset != null) {
                this.setWordsOfSelectedWordset();
                this.repaintThisAndParent();
            }
        }
    }

    private void setWordsOfSelectedWordset() {
        List<String> words = this.selectedWordset.getWords();
        for (String word : words) {
            this.addWordLabel(word);
        }
    }

    private void addWordLabel(String word) {
        JLabel labelWord = new JLabel(word);
        labelWord.setOpaque(true);
        labelWord.setForeground(LABEL_EDITABLE_FOREGROUND_COLOR);
        labelWord.setBackground(LABEL_EDITABLE_BACKGROUND_COLOR);
        labelWord.setBorder(LABEL_BORDER);
        labelWord.setToolTipText(word);
        labelWord.addMouseListener(this.wordClickedListener);
        this.wordLabels.add(labelWord);
        this.panelWords.add(labelWord);
    }

    private void repaintThisAndParent() {
        ComponentUtil.forceRepaint(this);
        Container parent = this.getParent();
        if (parent != null) {
            ComponentUtil.forceRepaint(parent);
            parent = parent.getParent();
            if (parent != null) {
                ComponentUtil.forceRepaint(parent);
            }
        }
    }

    public void addToAutomaticWordset(String word) {
        if (word == null) {
            throw new NullPointerException("word == null");
        }
        if (StringUtil.hasContent(word) && !this.automaticWordset.containsWord(word)) {
            this.automaticWordset.addToWords(word);
            String oldestWord = this.getOldestAutomaticWordsetWord();
            this.addToAutomaticWordsetRingBuffer(word);
            if (!oldestWord.isEmpty()) {
                this.automaticWordset.removeFromWords(oldestWord);
            }
            this.setWordsOfSelectedWordsetName();
            this.buttonEraseAutomaticWords.setEnabled(true);
        }
    }

    private void addToAutomaticWordsetRingBuffer(String word) {
        for (int i = 8; i > 0; --i) {
            this.automaticAddedWordsRingbuffer[i] = this.automaticAddedWordsRingbuffer[i - 1];
        }
        this.automaticAddedWordsRingbuffer[0] = word;
    }

    private String getOldestAutomaticWordsetWord() {
        return this.automaticAddedWordsRingbuffer[8];
    }

    private boolean isAutomaticWordsetSelected() {
        Object selectedItem = this.comboBoxWordsetNames.getSelectedItem();
        return "JPhotoTagger Automatic Wordset".equals(selectedItem);
    }

    private Wordset createAutomaticWordset() {
        Wordset wordset = new Wordset("JPhotoTagger Automatic Wordset");
        this.addPersistedWordsToWordset(wordset);
        return wordset;
    }

    private void addPersistedWordsToWordset(Wordset wordset) {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        if (prefs != null) {
            for (int index = 0; index < 9; ++index) {
                String key = this.createAutomaticWordsetPersistenceKey(index);
                if (!prefs.containsKey(key)) continue;
                String word = prefs.getString(key);
                wordset.addToWords(word);
            }
        }
    }

    @EventSubscriber(eventClass=AppWillExitEvent.class)
    public void appWillExit(AppWillExitEvent evt) {
        this.persistComboBoxSelectedIndex();
        this.persistAutomaticWordsetWords();
    }

    private void persistAutomaticWordsetWords() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        if (prefs != null) {
            int persistedWordCount = 0;
            List<String> words = this.automaticWordset.getWords();
            for (String word : words) {
                String key = this.createAutomaticWordsetPersistenceKey(persistedWordCount);
                prefs.setString(key, word);
                ++persistedWordCount;
            }
            for (int index = persistedWordCount; index < 9; ++index) {
                String key = this.createAutomaticWordsetPersistenceKey(index);
                prefs.removeKey(key);
            }
        }
    }

    private void persistComboBoxSelectedIndex() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        if (prefs != null && this.persistenceKeyPrefix != null) {
            String key = this.createComboBoxSelectedIndexPersistenceKey();
            prefs.setInt(key, this.comboBoxWordsetNames.getSelectedIndex());
        }
    }

    private String createAutomaticWordsetPersistenceKey(int index) {
        return this.persistenceKeyPrefix == null ? "Default" : this.persistenceKeyPrefix + '.' + "AutomaticWordset.Word." + Integer.valueOf(index);
    }

    private String createComboBoxSelectedIndexPersistenceKey() {
        return this.persistenceKeyPrefix + ".SelectedWordsetIndex";
    }

    private void addWordset() {
        EditWordsetDialog dialog = new EditWordsetDialog();
        dialog.setVisible(true);
    }

    private void removeSelectedWordset() {
        WordsetsRepository wordsetsRepository;
        String wordsetName = (String)this.comboBoxWordsetNames.getSelectedItem();
        if (wordsetName != null && !WordsetPreferences.isAutomaticWordsetName(wordsetName) && MessageDisplayer.confirmYesNo(this, Bundle.getString(WordsetsPanel.class, "WordsetPreferences.Confirm.Remove", wordsetName)) && !(wordsetsRepository = Lookup.getDefault().lookup(WordsetsRepository.class)).remove(wordsetName)) {
            MessageDisplayer.error(this, Bundle.getString(WordsetsPanel.class, "WordsetsPanel.Error.Remove", wordsetName));
        }
    }

    private void editSelectedWordset() {
        String wordsetName = (String)this.comboBoxWordsetNames.getSelectedItem();
        if (wordsetName != null && !WordsetPreferences.isAutomaticWordsetName(wordsetName)) {
            WordsetsRepository wordsetsRepository = Lookup.getDefault().lookup(WordsetsRepository.class);
            Wordset wordset = wordsetsRepository.find(wordsetName);
            if (wordset != null) {
                EditWordsetDialog dialog = new EditWordsetDialog(wordset);
                dialog.setVisible(true);
            } else {
                MessageDisplayer.error(this, Bundle.getString(WordsetsPanel.class, "WordsetsPanel.Error.Edit", wordsetName));
            }
        }
    }

    private void resetAutomaticWordset() {
        if (this.isAutomaticWordsetSelected()) {
            int persistedWordCount = this.automaticWordset.getWordCount();
            this.automaticWordset.clear();
            this.initAutomaticAddedWordsRingbuffer();
            Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
            for (int i = 0; i < persistedWordCount; ++i) {
                String key = this.createAutomaticWordsetPersistenceKey(i);
                prefs.removeKey(key);
            }
            this.setWordsOfSelectedWordsetName();
            this.buttonEraseAutomaticWords.setEnabled(false);
        }
    }

    public void addWordsetsPanelListener(WordsetsPanelListener listener) {
        this.listenerSupport.add(listener);
    }

    public void removeWordsetsPanelListener(WordsetsPanelListener listener) {
        this.listenerSupport.remove(listener);
    }

    private void notifyWordClicked(String word) {
        Set<WordsetsPanelListener> listeners = this.listenerSupport.get();
        for (WordsetsPanelListener listener : listeners) {
            listener.wordClicked(word);
        }
    }

    private void setButtonsEnabled() {
        boolean automaticWordsetSelected = this.isAutomaticWordsetSelected();
        this.buttonAddWordset.setEnabled(true);
        this.buttonEditWordset.setEnabled(!automaticWordsetSelected);
        this.buttonRemoveWordset.setEnabled(!automaticWordsetSelected);
        this.buttonEraseAutomaticWords.setEnabled(automaticWordsetSelected && !this.automaticWordset.isEmpty());
    }

    private void initComponents() {
        this.panelWordsets = new JPanel();
        this.comboBoxWordsetNames = new JComboBox();
        this.buttonRemoveWordset = new JButton();
        this.buttonEditWordset = new JButton();
        this.buttonAddWordset = new JButton();
        this.buttonEraseAutomaticWords = new JButton();
        this.panelWords = new JPanel();
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/wordsets/Bundle");
        this.setToolTipText(bundle.getString("WordsetsPanel.toolTipText"));
        this.setLayout(new GridBagLayout());
        this.panelWordsets.setLayout(new GridBagLayout());
        this.comboBoxWordsetNames.setModel(new WordsetNamesComboBoxModel());
        this.comboBoxWordsetNames.setFocusable(false);
        this.comboBoxWordsetNames.setRenderer(this.wordsetNamesComboBoxRenderer);
        this.comboBoxWordsetNames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WordsetsPanel.this.comboBoxWordsetNamesActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelWordsets.add(this.comboBoxWordsetNames, gridBagConstraints);
        this.buttonRemoveWordset.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/module/wordsets/delete.png")));
        this.buttonRemoveWordset.setToolTipText(bundle.getString("WordsetsPanel.buttonRemoveWordset.toolTipText"));
        this.buttonRemoveWordset.setFocusable(false);
        this.buttonRemoveWordset.setMargin(new Insets(2, 2, 2, 2));
        this.buttonRemoveWordset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WordsetsPanel.this.buttonRemoveWordsetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelWordsets.add((Component)this.buttonRemoveWordset, gridBagConstraints);
        this.buttonEditWordset.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/module/wordsets/edit.png")));
        this.buttonEditWordset.setToolTipText(bundle.getString("WordsetsPanel.buttonEditWordset.toolTipText"));
        this.buttonEditWordset.setFocusable(false);
        this.buttonEditWordset.setMargin(new Insets(2, 2, 2, 2));
        this.buttonEditWordset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WordsetsPanel.this.buttonEditWordsetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelWordsets.add((Component)this.buttonEditWordset, gridBagConstraints);
        this.buttonAddWordset.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/module/wordsets/add.png")));
        this.buttonAddWordset.setToolTipText(bundle.getString("WordsetsPanel.buttonAddWordset.toolTipText"));
        this.buttonAddWordset.setFocusable(false);
        this.buttonAddWordset.setMargin(new Insets(2, 2, 2, 2));
        this.buttonAddWordset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WordsetsPanel.this.buttonAddWordsetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelWordsets.add((Component)this.buttonAddWordset, gridBagConstraints);
        this.buttonEraseAutomaticWords.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/module/wordsets/erase.png")));
        this.buttonEraseAutomaticWords.setToolTipText(bundle.getString("WordsetsPanel.buttonEraseAutomaticWords.toolTipText"));
        this.buttonEraseAutomaticWords.setFocusable(false);
        this.buttonEraseAutomaticWords.setMargin(new Insets(2, 2, 2, 2));
        this.buttonEraseAutomaticWords.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WordsetsPanel.this.buttonEraseAutomaticWordsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelWordsets.add((Component)this.buttonEraseAutomaticWords, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.panelWordsets, gridBagConstraints);
        this.panelWords.setLayout(new GridLayout(0, 3, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelWords, gridBagConstraints);
    }

    private void comboBoxWordsetNamesActionPerformed(ActionEvent evt) {
        this.setWordsOfSelectedWordsetName();
        this.setButtonsEnabled();
    }

    private void buttonAddWordsetActionPerformed(ActionEvent evt) {
        this.addWordset();
    }

    private void buttonRemoveWordsetActionPerformed(ActionEvent evt) {
        this.removeSelectedWordset();
    }

    private void buttonEditWordsetActionPerformed(ActionEvent evt) {
        this.editSelectedWordset();
    }

    private void buttonEraseAutomaticWordsActionPerformed(ActionEvent evt) {
        this.resetAutomaticWordset();
    }
}

