/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.wordsets;

import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.domain.repository.WordsetsRepository;
import org.jphototagger.domain.repository.event.wordsets.WordsetInsertedEvent;
import org.jphototagger.domain.repository.event.wordsets.WordsetRemovedEvent;
import org.jphototagger.domain.repository.event.wordsets.WordsetRenamedEvent;
import org.jphototagger.domain.repository.event.wordsets.WordsetUpdatedEvent;
import org.jphototagger.lib.util.ObjectUtil;
import org.openide.util.Lookup;

public final class WordsetNamesComboBoxModel
extends DefaultComboBoxModel<Object> {
    private static final long serialVersionUID = 1L;

    public WordsetNamesComboBoxModel() {
        this.addElements();
        this.listen();
    }

    private void addElements() {
        this.addElement("JPhotoTagger Automatic Wordset");
        WordsetsRepository repository = Lookup.getDefault().lookup(WordsetsRepository.class);
        if (repository != null) {
            List<String> wordsetNames = repository.findAllWordsetNames();
            for (String wordsetname : wordsetNames) {
                this.addElement(wordsetname);
            }
        }
    }

    private void listen() {
        AnnotationProcessor.process(this);
    }

    @EventSubscriber(eventClass=WordsetInsertedEvent.class)
    public void wordsetAdded(WordsetInsertedEvent evt) {
        String wordsetName = evt.getWordset().getName();
        this.addElement(wordsetName);
    }

    @EventSubscriber(eventClass=WordsetRemovedEvent.class)
    public void wordsetRemoved(WordsetRemovedEvent evt) {
        this.removeElement(evt.getWordsetName());
    }

    @EventSubscriber(eventClass=WordsetUpdatedEvent.class)
    public void wordsetUpdated(WordsetUpdatedEvent evt) {
        String newName;
        String oldName = evt.getOldWordset().getName();
        if (!ObjectUtil.equals(oldName, newName = evt.getNewWordset().getName())) {
            this.wordsetRenamed(new WordsetRenamedEvent(this, oldName, newName));
        }
    }

    @EventSubscriber(eventClass=WordsetRenamedEvent.class)
    public void wordsetRenamed(WordsetRenamedEvent evt) {
        String oldName = evt.getOldName();
        int indexOfOldName = this.getIndexOf(oldName);
        if (indexOfOldName >= 0) {
            Object selectedItem = this.getSelectedItem();
            boolean selected = oldName.equals(selectedItem);
            String newName = evt.getNewName();
            this.removeElementAt(indexOfOldName);
            this.insertElementAt(newName, indexOfOldName);
            if (selected) {
                this.setSelectedItem(newName);
            }
        }
    }
}

