/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.wordsets;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.jphototagger.domain.metadata.selections.AutoCompleteData;
import org.jphototagger.domain.metadata.selections.AutoCompleteDataOfMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpDcSubjectsSubjectMetaDataValue;
import org.jphototagger.domain.repository.WordsetsRepository;
import org.jphototagger.domain.wordsets.Wordset;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.util.Autocomplete;
import org.jphototagger.lib.swing.util.DocumentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.StringUtil;
import org.jphototagger.program.module.wordsets.WordsetPreferences;
import org.jphototagger.program.module.wordsets.WordsetsPanel;
import org.openide.util.Lookup;

public class EditWordsetPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final List<String> selectedWords = new ArrayList<String>();
    private String currentWord = "";
    private final EnableSaveButtonListener enableSaveButtonListener = new EnableSaveButtonListener();
    private final Wordset wordset;
    private final WordsetsRepository wordsetsRepository = Lookup.getDefault().lookup(WordsetsRepository.class);
    private Autocomplete autocomplete;
    private boolean dirty;
    private JButton buttonAddWord;
    private JButton buttonRemoveSelectedWords;
    private JButton buttonSave;
    private JLabel labelName;
    private JLabel labelWord;
    private JList<Object> listWords;
    private JPanel panelEdit;
    private JPanel panelName;
    private JScrollPane scrollPaneWords;
    private JTextArea textAreaWord;
    private JTextField textFieldName;
    private BindingGroup bindingGroup;

    public EditWordsetPanel() {
        this(new Wordset(Bundle.getString(EditWordsetPanel.class, "EditWordset.DefaultWordsetName", new Object[0])));
    }

    public EditWordsetPanel(Wordset wordset) {
        if (wordset == null) {
            throw new NullPointerException("wordset == null");
        }
        this.wordset = wordset;
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        MnemonicUtil.setMnemonics(this);
        this.textFieldName.getDocument().addDocumentListener(this.enableSaveButtonListener);
        this.listWords.getModel().addListDataListener(this.enableSaveButtonListener);
    }

    public void enableAutocomplete() {
        if (this.autocomplete == null) {
            this.autocomplete = new Autocomplete(true);
            XmpDcSubjectsSubjectMetaDataValue keywordsMeta = XmpDcSubjectsSubjectMetaDataValue.INSTANCE;
            AutoCompleteData keywordsAutocompleteData = AutoCompleteDataOfMetaDataValue.INSTANCE.get(keywordsMeta);
            List<String> keywords = keywordsAutocompleteData.get();
            boolean sorted = true;
            this.autocomplete.decorate(this.textAreaWord, keywords, sorted);
        }
    }

    public Wordset getWordset() {
        return this.wordset;
    }

    public List<String> getSelectedWords() {
        return Collections.unmodifiableList(this.selectedWords);
    }

    public void setSelectedWords(List<String> selectedWords) {
        this.selectedWords.clear();
        if (selectedWords != null) {
            this.selectedWords.addAll(selectedWords);
            this.buttonRemoveSelectedWords.setEnabled(!selectedWords.isEmpty());
        }
    }

    private void removeSelectedWords() {
        if (this.isRemoveSelectedWordsConfirm() && this.wordset.removeFromWords(this.selectedWords)) {
            this.dirty = true;
        }
    }

    private boolean isRemoveSelectedWordsConfirm() {
        if (this.selectedWords.isEmpty()) {
            return false;
        }
        return MessageDisplayer.confirmYesNo(this, Bundle.getString(EditWordsetPanel.class, "EditWordsetPanel.Confirm.RemoveSelectedWords", new Object[0]));
    }

    public String getCurrentWord() {
        return this.currentWord;
    }

    public void setCurrentWord(String currentWord) {
        this.currentWord = currentWord;
        this.buttonAddWord.setEnabled(StringUtil.hasContent(currentWord));
    }

    private void addCurrentWord() {
        if (StringUtil.hasContent(this.currentWord) && this.wordset.addToWords(this.currentWord.trim())) {
            this.dirty = true;
        }
    }

    public void saveWordset() {
        if (!this.dirty) {
            return;
        }
        boolean saved = false;
        if (this.isUpdate()) {
            if (this.checkValidUpdateName()) {
                saved = this.wordsetsRepository.update(this.wordset);
                this.showSaveSuccessMessage(saved);
            }
        } else if (this.isSave() && this.checkNotExistingName()) {
            saved = this.wordsetsRepository.insert(this.wordset);
            if (saved) {
                String wordsetName = this.wordset.getName();
                long wordsetId = this.wordsetsRepository.findWordsetId(wordsetName);
                this.wordset.setId(wordsetId);
            }
            this.showSaveSuccessMessage(saved);
        }
        this.dirty = !saved;
    }

    private void showSaveSuccessMessage(boolean saved) {
        if (saved) {
            MessageDisplayer.information(this, Bundle.getString(EditWordsetPanel.class, "EditWordsetPanel.Save.Success", new Object[0]));
        } else {
            MessageDisplayer.warning(this, Bundle.getString(EditWordsetPanel.class, "EditWordsetPanel.Save.Error", new Object[0]));
        }
    }

    private boolean isUpdate() {
        return this.wordset.getId() > 0L;
    }

    private boolean isSave() {
        return this.wordset.getId() <= 0L;
    }

    private boolean checkValidUpdateName() {
        String nameOfId;
        String name = this.wordset.getName().trim();
        if (!name.equals(nameOfId = this.wordsetsRepository.findWordsetNameById(this.wordset.getId()))) {
            return this.checkNotExistingName();
        }
        return true;
    }

    private boolean checkNotExistingName() {
        String name = this.wordset.getName();
        if (this.wordsetsRepository.existsWordset(name)) {
            MessageDisplayer.warning(this, Bundle.getString(EditWordsetPanel.class, "EditWordsetPanel.Save.NameAlreadyExists", name));
            return false;
        }
        return true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void selectNameTextField() {
        this.selectTextComponent(this.textFieldName);
    }

    public void selectWordTextField() {
        this.selectTextComponent(this.textAreaWord);
    }

    private void selectTextComponent(JTextComponent tc) {
        tc.requestFocusInWindow();
        tc.selectAll();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panelName = new JPanel();
        this.labelName = new JLabel();
        this.textFieldName = new JTextField();
        this.buttonSave = new JButton();
        this.scrollPaneWords = new JScrollPane();
        this.listWords = new JList();
        this.panelEdit = new JPanel();
        this.labelWord = new JLabel();
        this.textAreaWord = new JTextArea();
        this.buttonAddWord = new JButton();
        this.buttonRemoveSelectedWords = new JButton();
        this.setLayout(new GridBagLayout());
        this.panelName.setLayout(new GridBagLayout());
        this.labelName.setLabelFor(this.textFieldName);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/wordsets/Bundle");
        this.labelName.setText(bundle.getString("EditWordsetPanel.labelName.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelName.add((Component)this.labelName, gridBagConstraints);
        this.textFieldName.setColumns(25);
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this, ELProperty.create("${wordset.name}"), this.textFieldName, BeanProperty.create("text"));
        this.bindingGroup.addBinding(binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelName.add((Component)this.textFieldName, gridBagConstraints);
        this.buttonSave.setText(bundle.getString("EditWordsetPanel.buttonSave.text"));
        this.buttonSave.setEnabled(false);
        this.buttonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditWordsetPanel.this.buttonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelName.add((Component)this.buttonSave, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.panelName, gridBagConstraints);
        this.listWords.setCellRenderer(new WordsetNamesComboBoxRenderer());
        this.listWords.setLayoutOrientation(2);
        this.listWords.setVisibleRowCount(-1);
        ELProperty eLProperty = ELProperty.create("${wordset.words}");
        JListBinding jListBinding = SwingBindings.createJListBinding(AutoBinding.UpdateStrategy.READ_WRITE, this, eLProperty, this.listWords);
        this.bindingGroup.addBinding(jListBinding);
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this, ELProperty.create("${selectedWords}"), this.listWords, BeanProperty.create("selectedElements"));
        this.bindingGroup.addBinding(binding);
        this.listWords.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                EditWordsetPanel.this.listWordsKeyPressed(evt);
            }
        });
        this.scrollPaneWords.setViewportView(this.listWords);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.scrollPaneWords, gridBagConstraints);
        this.panelEdit.setLayout(new GridBagLayout());
        this.labelWord.setLabelFor(this.textAreaWord);
        this.labelWord.setText(bundle.getString("EditWordsetPanel.labelWord.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelEdit.add((Component)this.labelWord, gridBagConstraints);
        this.textAreaWord.setColumns(20);
        this.textAreaWord.setFont(UIManager.getFont("TextField.font"));
        this.textAreaWord.setRows(1);
        this.textAreaWord.setBorder(UIManager.getBorder("TextField.border"));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this, ELProperty.create("${currentWord}"), this.textAreaWord, BeanProperty.create("text"));
        this.bindingGroup.addBinding(binding);
        this.textAreaWord.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                EditWordsetPanel.this.textAreaWordKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelEdit.add((Component)this.textAreaWord, gridBagConstraints);
        this.buttonAddWord.setMnemonic('+');
        this.buttonAddWord.setText("+");
        this.buttonAddWord.setToolTipText(bundle.getString("EditWordsetPanel.buttonAddWord.toolTipText"));
        this.buttonAddWord.setEnabled(false);
        this.buttonAddWord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditWordsetPanel.this.buttonAddWordActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelEdit.add((Component)this.buttonAddWord, gridBagConstraints);
        this.buttonRemoveSelectedWords.setMnemonic('-');
        this.buttonRemoveSelectedWords.setText("-");
        this.buttonRemoveSelectedWords.setToolTipText(bundle.getString("EditWordsetPanel.buttonRemoveSelectedWords.toolTipText"));
        this.buttonRemoveSelectedWords.setEnabled(false);
        this.buttonRemoveSelectedWords.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditWordsetPanel.this.buttonRemoveSelectedWordsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelEdit.add((Component)this.buttonRemoveSelectedWords, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelEdit, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void buttonRemoveSelectedWordsActionPerformed(ActionEvent evt) {
        this.removeSelectedWords();
        this.selectTextComponent(this.textAreaWord);
    }

    private void buttonAddWordActionPerformed(ActionEvent evt) {
        this.addCurrentWord();
        this.selectTextComponent(this.textAreaWord);
    }

    private void buttonSaveActionPerformed(ActionEvent evt) {
        this.saveWordset();
    }

    private void textAreaWordKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.addCurrentWord();
            this.textAreaWord.selectAll();
            this.textAreaWord.requestFocusInWindow();
            evt.consume();
        }
    }

    private void listWordsKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.removeSelectedWords();
            this.selectTextComponent(this.textAreaWord);
        }
    }

    private static class WordsetNamesComboBoxRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;
        private static final ImageIcon ICON = IconUtil.getImageIcon(WordsetsPanel.class, "word.png");

        private WordsetNamesComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            label.setIcon(ICON);
            return label;
        }
    }

    private class EnableSaveButtonListener
    implements DocumentListener,
    ListDataListener {
        private EnableSaveButtonListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.setSaveButtonEnabled(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.setSaveButtonEnabled(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.setSaveButtonEnabled(e);
        }

        private void setSaveButtonEnabled(DocumentEvent e) {
            EditWordsetPanel.this.dirty = true;
            String wordsetName = DocumentUtil.getText(e);
            boolean nameHasContent = StringUtil.hasContent(wordsetName);
            boolean nameIsAllowed = !WordsetPreferences.isAutomaticWordsetName(wordsetName);
            EditWordsetPanel.this.buttonSave.setEnabled(EditWordsetPanel.this.dirty && nameHasContent && nameIsAllowed);
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.setSaveButtonEnabled();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.setSaveButtonEnabled();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.setSaveButtonEnabled();
        }

        private void setSaveButtonEnabled() {
            EditWordsetPanel.this.dirty = true;
            EditWordsetPanel.this.buttonSave.setEnabled(true);
        }
    }
}

