/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.wordsets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import org.jphototagger.domain.wordsets.Wordset;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.wordsets.EditWordsetPanel;

public class EditWordsetDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private final Wordset wordset;
    private boolean selectNameTextfield;
    private EditWordsetPanel panelEditWordset;

    public EditWordsetDialog() {
        this(new Wordset(Bundle.getString(EditWordsetDialog.class, "EditWordset.DefaultWordsetName", new Object[0])));
        this.selectNameTextfield = true;
    }

    public EditWordsetDialog(Wordset wordset) {
        super(ComponentUtil.findFrameWithIcon(), true);
        this.wordset = wordset;
        this.initComponents();
    }

    private void checkDirty() {
        if (this.panelEditWordset.isDirty() && MessageDisplayer.confirmYesNo(this, Bundle.getString(EditWordsetDialog.class, "EditWordsetDialog.Confirm.Save", new Object[0]))) {
            this.panelEditWordset.saveWordset();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.panelEditWordset.enableAutocomplete();
            if (this.selectNameTextfield) {
                this.panelEditWordset.selectNameTextField();
            } else {
                this.panelEditWordset.selectWordTextField();
            }
        }
        super.setVisible(visible);
    }

    @Override
    protected void escape() {
        this.checkDirty();
        super.escape();
    }

    private void initComponents() {
        this.panelEditWordset = new EditWordsetPanel(this.wordset);
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/wordsets/Bundle");
        this.setTitle(bundle.getString("EditWordsetDialog.title"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EditWordsetDialog.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.panelEditWordset.setPreferredSize(new Dimension(300, 200));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.panelEditWordset, gridBagConstraints);
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.checkDirty();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditWordsetDialog dialog = new EditWordsetDialog();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

