/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.timeline;

import java.sql.Date;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.domain.metadata.exif.Exif;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpIptc4XmpCoreDateCreatedMetaDataValue;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.domain.repository.event.exif.ExifDeletedEvent;
import org.jphototagger.domain.repository.event.exif.ExifInsertedEvent;
import org.jphototagger.domain.repository.event.exif.ExifUpdatedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpDeletedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpInsertedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpUpdatedEvent;
import org.jphototagger.domain.timeline.Timeline;
import org.jphototagger.lib.swing.UpdateInfoTreeModel;
import org.openide.util.Lookup;

public final class TimelineTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 1L;
    private final ImageFilesRepository repo = Lookup.getDefault().lookup(ImageFilesRepository.class);
    private final transient Timeline timeline = this.repo.findTimeline();

    public TimelineTreeModel() {
        super(new DefaultMutableTreeNode());
        this.setRoot(this.timeline.getRoot());
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process(this);
    }

    private void checkDeleted(Xmp xmp) {
        boolean xmpDateExists;
        Object o = xmp.getValue(XmpIptc4XmpCoreDateCreatedMetaDataValue.INSTANCE);
        String xmpDate = o == null ? null : (String)xmp.getValue(XmpIptc4XmpCoreDateCreatedMetaDataValue.INSTANCE);
        boolean bl = xmpDateExists = xmpDate != null && this.repo.existsXMPDateCreated(xmpDate);
        if (!xmpDateExists && xmpDate != null) {
            Timeline.Date date = new Timeline.Date(-1, -1, -1);
            date.setXmpDateCreated(xmpDate);
            if (date.isValid() && !this.repo.existsXMPDateCreated(xmpDate)) {
                this.delete(date);
            }
        }
    }

    private void checkDeleted(Exif exif) {
        boolean exifDateExists;
        Date exifDate = exif.getDateTimeOriginal();
        boolean bl = exifDateExists = exifDate != null && this.repo.existsExifDate(exifDate);
        if (!exifDateExists && exifDate != null) {
            Timeline.Date date = new Timeline.Date(exifDate);
            if (!this.repo.existsExifDate(exifDate)) {
                this.delete(date);
            }
        }
    }

    private void checkInserted(Xmp xmp) {
        if (xmp.contains(XmpIptc4XmpCoreDateCreatedMetaDataValue.INSTANCE)) {
            String xmpDate = (String)xmp.getValue(XmpIptc4XmpCoreDateCreatedMetaDataValue.INSTANCE);
            Timeline.Date date = new Timeline.Date(-1, -1, -1);
            date.setXmpDateCreated(xmpDate);
            if (date.isValid()) {
                this.insert(date);
            }
        }
    }

    private void checkInserted(Exif exif) {
        Date day = exif.getDateTimeOriginal();
        if (day != null) {
            Timeline.Date date = new Timeline.Date(day);
            this.insert(date);
        }
    }

    private void delete(Timeline.Date date) {
        UpdateInfoTreeModel.NodeAndChild info = this.timeline.removeDay(date);
        this.nodesWereRemoved(info.getNode(), info.getUpdatedChildIndex(), info.getUpdatedChild());
    }

    private void insert(Timeline.Date date) {
        if (!this.timeline.existsDate(date)) {
            UpdateInfoTreeModel.NodesAndChildIndices info = this.timeline.add(date);
            for (UpdateInfoTreeModel.NodeAndChildIndices node : info.getInfo()) {
                this.nodesWereInserted(node.getNode(), node.getChildIndices());
            }
        }
    }

    @EventSubscriber(eventClass=XmpInsertedEvent.class)
    public void xmpInserted(XmpInsertedEvent evt) {
        this.checkInserted(evt.getXmp());
    }

    @EventSubscriber(eventClass=XmpUpdatedEvent.class)
    public void xmpUpdated(XmpUpdatedEvent evt) {
        this.checkDeleted(evt.getOldXmp());
        this.checkInserted(evt.getUpdatedXmp());
    }

    @EventSubscriber(eventClass=XmpDeletedEvent.class)
    public void xmpDeleted(XmpDeletedEvent evt) {
        this.checkDeleted(evt.getXmp());
    }

    @EventSubscriber(eventClass=ExifInsertedEvent.class)
    public void exifInserted(ExifInsertedEvent evt) {
        this.checkInserted(evt.getExif());
    }

    @EventSubscriber(eventClass=ExifUpdatedEvent.class)
    public void exifUpdated(ExifUpdatedEvent evt) {
        this.checkDeleted(evt.getOldExif());
        this.checkInserted(evt.getUpdatedExif());
    }

    @EventSubscriber(eventClass=ExifDeletedEvent.class)
    public void exifDeleted(ExifDeletedEvent evt) {
        this.checkDeleted(evt.getExif());
    }
}

