/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.timeline;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jphototagger.domain.timeline.Timeline;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.program.app.ui.TreeCellRendererExt;

public final class TimelineTreeCellRenderer
extends TreeCellRendererExt {
    private static final ImageIcon ICON_YEAR = IconUtil.getImageIcon("/org/jphototagger/program/resource/icons/icon_timeline.png");
    private static final ImageIcon ICON_MONTH = IconUtil.getImageIcon("/org/jphototagger/program/resource/icons/icon_timeline_month.png");
    private static final ImageIcon ICON_DAY = IconUtil.getImageIcon("/org/jphototagger/program/resource/icons/icon_timeline_day.png");
    private static final ImageIcon ICON_UNKNOWN = IconUtil.getImageIcon("/org/jphototagger/program/resource/icons/icon_timeline_unknown.png");
    private static final long serialVersionUID = 1L;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, false, row, hasFocus);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObject = node.getUserObject();
        TreeNode root = node.getRoot();
        if (userObject instanceof Timeline.Date) {
            Timeline.Date date = (Timeline.Date)userObject;
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            if (parent != null) {
                boolean isMonth;
                boolean isYear = parent.equals(root);
                boolean bl = isMonth = node.getPath().length == 3;
                this.setIcon(isYear ? ICON_YEAR : (isMonth ? ICON_MONTH : ICON_DAY));
                this.setText(isYear ? String.valueOf(date.year) : (isMonth ? date.getMonthDisplayName() : String.valueOf(date.day)));
            }
        } else if (node.equals(Timeline.getUnknownNode())) {
            this.setIcon(ICON_UNKNOWN);
            this.setText(node.getUserObject().toString());
        }
        int tempSelRow = this.getTempSelectionRow();
        boolean tempSelRowIsSelected = tempSelRow < 0 ? false : tree.isRowSelected(tempSelRow);
        this.setColors(row, this.selected, tempSelRowIsSelected);
        return this;
    }

    @Override
    public void setTempSelectionRow(int index) {
        super.setTempSelectionRow(index);
    }
}

