/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails.info;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.bushe.swing.event.EventBus;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.lib.swing.util.DocumentUtil;
import org.jphototagger.lib.swing.util.ListUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.StringUtil;
import org.jphototagger.program.module.thumbnails.info.SidecarSuffixInfoAddedEvent;
import org.jphototagger.program.module.thumbnails.info.SidecarSuffixInfoRemovedEvent;
import org.openide.util.Lookup;

public class SidecarSuffixesInfoSettingsPanel
extends JPanel {
    public static final String KEY_FILE_SUFFIXES = "ThumbnailInfo.AdditionalSidecarSuffixes";
    private static final long serialVersionUID = 1L;
    private final Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
    private final SuffixListModel suffixesListModel = new SuffixListModel();
    private final DocumentListener addSuffixDocumentListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.enableAddSuffixButton(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.enableAddSuffixButton(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.enableAddSuffixButton(e);
        }

        private void enableAddSuffixButton(DocumentEvent e) {
            String text = DocumentUtil.getText(e);
            SidecarSuffixesInfoSettingsPanel.this.buttonAddSuffix.setEnabled(StringUtil.hasContent(text));
        }
    };
    private final ListSelectionListener removeSuffixesListSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                SidecarSuffixesInfoSettingsPanel.this.buttonRemoveSuffix.setEnabled(SidecarSuffixesInfoSettingsPanel.this.listSuffixes.getSelectedIndex() >= 0);
            }
        }
    };
    private JButton buttonAddSuffix;
    private JButton buttonRemoveSuffix;
    private JLabel labelInfo;
    private JLabel labelSuffix;
    private JList<String> listSuffixes;
    private JPanel panelContent;
    private JScrollPane scrollPaneSuffixes;
    private JTextField textFieldSuffix;

    public SidecarSuffixesInfoSettingsPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.listSuffixes.addListSelectionListener(this.removeSuffixesListSelectionListener);
        this.textFieldSuffix.getDocument().addDocumentListener(this.addSuffixDocumentListener);
        MnemonicUtil.setMnemonics(this);
    }

    private void addSuffix() {
        String suffix = this.textFieldSuffix.getText();
        if (StringUtil.hasContent(suffix)) {
            this.suffixesListModel.addSuffix(suffix.trim());
        }
    }

    private void removeSelectedSuffixes() {
        for (String suffix : this.listSuffixes.getSelectedValuesList()) {
            this.suffixesListModel.removeSuffix(suffix);
        }
    }

    private void initComponents() {
        this.panelContent = new JPanel();
        this.labelInfo = new JLabel();
        this.scrollPaneSuffixes = new JScrollPane();
        this.listSuffixes = new JList();
        this.labelSuffix = new JLabel();
        this.textFieldSuffix = new JTextField();
        this.buttonAddSuffix = new JButton();
        this.buttonRemoveSuffix = new JButton();
        this.setLayout(new GridBagLayout());
        this.panelContent.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/thumbnails/info/Bundle");
        this.labelInfo.setText(bundle.getString("SidecarSuffixesInfoSettingsPanel.labelInfo.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelContent.add((Component)this.labelInfo, gridBagConstraints);
        this.listSuffixes.setModel(this.suffixesListModel);
        this.listSuffixes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SidecarSuffixesInfoSettingsPanel.this.listSuffixesKeyPressed(evt);
            }
        });
        this.scrollPaneSuffixes.setViewportView(this.listSuffixes);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelContent.add((Component)this.scrollPaneSuffixes, gridBagConstraints);
        this.labelSuffix.setLabelFor(this.textFieldSuffix);
        this.labelSuffix.setText(bundle.getString("SidecarSuffixesInfoSettingsPanel.labelSuffix.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelContent.add((Component)this.labelSuffix, gridBagConstraints);
        this.textFieldSuffix.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SidecarSuffixesInfoSettingsPanel.this.textFieldSuffixKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panelContent.add((Component)this.textFieldSuffix, gridBagConstraints);
        this.buttonAddSuffix.setText(bundle.getString("SidecarSuffixesInfoSettingsPanel.buttonAddSuffix.text"));
        this.buttonAddSuffix.setEnabled(false);
        this.buttonAddSuffix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SidecarSuffixesInfoSettingsPanel.this.buttonAddSuffixActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panelContent.add((Component)this.buttonAddSuffix, gridBagConstraints);
        this.buttonRemoveSuffix.setText(bundle.getString("SidecarSuffixesInfoSettingsPanel.buttonRemoveSuffix.text"));
        this.buttonRemoveSuffix.setEnabled(false);
        this.buttonRemoveSuffix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SidecarSuffixesInfoSettingsPanel.this.buttonRemoveSuffixActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panelContent.add((Component)this.buttonRemoveSuffix, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.panelContent, gridBagConstraints);
    }

    private void textFieldSuffixKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.addSuffix();
        }
    }

    private void buttonAddSuffixActionPerformed(ActionEvent evt) {
        this.addSuffix();
    }

    private void buttonRemoveSuffixActionPerformed(ActionEvent evt) {
        this.removeSelectedSuffixes();
    }

    private void listSuffixesKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.removeSelectedSuffixes();
        }
    }

    private class SuffixListModel
    extends DefaultListModel<String> {
        private static final long serialVersionUID = 1L;

        private SuffixListModel() {
            this.addElements();
        }

        private void removeSuffix(String suffix) {
            if (this.contains(suffix)) {
                this.removeElement(suffix);
                SidecarSuffixesInfoSettingsPanel.this.prefs.setStringCollection(SidecarSuffixesInfoSettingsPanel.KEY_FILE_SUFFIXES, ListUtil.getElements(this));
                EventBus.publish(new SidecarSuffixInfoRemovedEvent(this, suffix));
            }
        }

        private void addSuffix(String suffix) {
            if (!this.containsSuffix(suffix)) {
                this.addElement(suffix);
                SidecarSuffixesInfoSettingsPanel.this.prefs.setStringCollection(SidecarSuffixesInfoSettingsPanel.KEY_FILE_SUFFIXES, ListUtil.getElements(this));
                EventBus.publish(new SidecarSuffixInfoAddedEvent(this, suffix));
            }
        }

        private boolean containsSuffix(String suffix) {
            String suffixUpperCase = suffix.toUpperCase();
            for (String s : ListUtil.getElements(this)) {
                if (!suffixUpperCase.equals(s.toUpperCase())) continue;
                return true;
            }
            return false;
        }

        private void addElements() {
            for (String suffix : SidecarSuffixesInfoSettingsPanel.this.prefs.getStringCollection(SidecarSuffixesInfoSettingsPanel.KEY_FILE_SUFFIXES)) {
                this.addElement(suffix);
            }
        }
    }
}

