/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails.info;

import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.metadata.thumbnails.ThumbnailInfoProvider;
import org.jphototagger.domain.thumbnails.event.ThumbnailsSelectionChangedEvent;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.StringUtil;
import org.jphototagger.program.module.thumbnails.info.SidecarSuffixInfoAddedEvent;
import org.jphototagger.program.module.thumbnails.info.SidecarSuffixInfoRemovedEvent;
import org.openide.util.Lookup;

public class SidecarSuffixesInfoPanel
extends JPanel
implements ThumbnailInfoProvider {
    private static final long serialVersionUID = 1L;
    private final Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
    private final JLabel infoLabel = new JLabel(Bundle.getString(SidecarSuffixesInfoPanel.class, "SidecarSuffixesInfoPanel.Label.Info", new Object[0]));
    private int suffixCount;

    public SidecarSuffixesInfoPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        List<String> suffixes = this.prefs.getStringCollection("ThumbnailInfo.AdditionalSidecarSuffixes");
        Collections.sort(suffixes, String.CASE_INSENSITIVE_ORDER);
        if (!suffixes.isEmpty()) {
            this.add(this.infoLabel);
        }
        for (String suffix : suffixes) {
            this.addSuffix(suffix);
            ++this.suffixCount;
        }
        AnnotationProcessor.process(this);
    }

    private void addSuffix(String suffix) {
        if (this.suffixCount == 0) {
            this.add(this.infoLabel);
        }
        JCheckBox checkBox = new JCheckBox(suffix);
        checkBox.setEnabled(false);
        this.add(checkBox);
        ++this.suffixCount;
    }

    private void removeSuffix(String suffix) {
        for (JCheckBox checkBox : ComponentUtil.getAllOf(this, JCheckBox.class)) {
            if (!suffix.equals(checkBox.getText())) continue;
            this.remove(checkBox);
            --this.suffixCount;
        }
        if (this.suffixCount == 0) {
            this.remove(this.infoLabel);
        }
    }

    @EventSubscriber(eventClass=SidecarSuffixInfoAddedEvent.class)
    public void suffixInfoAdded(SidecarSuffixInfoAddedEvent evt) {
        this.addSuffix(evt.getSuffix());
    }

    @EventSubscriber(eventClass=SidecarSuffixInfoRemovedEvent.class)
    public void suffixInfoRemoved(SidecarSuffixInfoRemovedEvent evt) {
        this.removeSuffix(evt.getSuffix());
    }

    @EventSubscriber(eventClass=ThumbnailsSelectionChangedEvent.class)
    public void thumbnailsSelectionChanged(ThumbnailsSelectionChangedEvent evt) {
        this.setChecked(evt.getSelectedFiles());
    }

    private void setChecked(List<File> files) {
        for (JCheckBox checkBox : ComponentUtil.getAllOf(this, JCheckBox.class)) {
            checkBox.setSelected(this.allHaveSidecarFile(files, checkBox.getText()));
        }
    }

    private boolean allHaveSidecarFile(List<File> files, String sidecarSuffix) {
        if (files.isEmpty()) {
            return false;
        }
        for (File file : files) {
            if (this.hasSidecarFile(file, sidecarSuffix)) continue;
            return false;
        }
        return true;
    }

    private boolean hasSidecarFile(File file, String sidecarSuffix) {
        String parent = file.getParent();
        if (!StringUtil.hasContent(parent)) {
            return false;
        }
        String prefix = FileUtil.getPrefix(file);
        File sidecarFile = new File("---012345-JPhotoTagger-should-not-exist-543210---");
        if (sidecarSuffix.contains("/")) {
            int lasDirDelimIndex = sidecarSuffix.lastIndexOf(47);
            if (lasDirDelimIndex < sidecarSuffix.length() - 1) {
                String subdirs = sidecarSuffix.substring(0, lasDirDelimIndex).replace("/", File.separator);
                String suffix = sidecarSuffix.substring(lasDirDelimIndex + 1);
                sidecarFile = new File(parent + File.separator + subdirs + File.separator + prefix + '.' + suffix);
            }
        } else {
            sidecarFile = new File(parent + File.separator + prefix + '.' + sidecarSuffix);
        }
        return sidecarFile.isFile();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public int getPosition() {
        return 0;
    }

    private void initComponents() {
        this.setLayout(new FlowLayout(0, 5, 0));
    }
}

