/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails.cache;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.domain.event.listener.ThumbnailUpdateListener;
import org.jphototagger.domain.metadata.xmp.FileXmp;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.domain.repository.event.xmp.XmpDeletedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpInsertedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpUpdatedEvent;
import org.jphototagger.domain.thumbnails.event.TypedThumbnailUpdateEvent;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.program.module.thumbnails.cache.Cache;
import org.jphototagger.program.module.thumbnails.cache.WorkQueue;
import org.jphototagger.program.module.thumbnails.cache.XmpCacheIndirection;
import org.openide.util.Lookup;

public final class XmpCache
extends Cache<XmpCacheIndirection> {
    public static final XmpCache INSTANCE = new XmpCache();

    private XmpCache() {
        this.listen();
        XmpFetcher xmpFetcher = new XmpFetcher(this.workQueue, this);
        Thread xmpFetcherThread = new Thread((Runnable)xmpFetcher, "JPhotoTagger: XmpFetcher");
        xmpFetcherThread.start();
    }

    private void listen() {
        AnnotationProcessor.process(this);
    }

    @EventSubscriber(eventClass=XmpInsertedEvent.class)
    public void xmpInserted(XmpInsertedEvent evt) {
        this.update(evt.getXmp(), evt.getImageFile(), true);
    }

    @EventSubscriber(eventClass=XmpDeletedEvent.class)
    public void xmpDeleted(XmpDeletedEvent evt) {
        this.update(evt.getImageFile());
    }

    @EventSubscriber(eventClass=XmpUpdatedEvent.class)
    public void xmpUpdated(XmpUpdatedEvent evt) {
        this.update(evt.getUpdatedXmp(), evt.getImageFile(), true);
    }

    private void update(File imageFile) {
        this.fileCache.remove(imageFile);
        this.notifyUpdate(imageFile);
    }

    @Override
    protected synchronized void generateEntry(File file, boolean prefetch) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        XmpCacheIndirection ci = new XmpCacheIndirection(file);
        this.updateUsageTime(ci);
        this.fileCache.put(file, ci);
        if (prefetch) {
            this.workQueue.append(ci);
        } else {
            this.workQueue.push(ci);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(final Xmp xmp, final File file, boolean repaint) {
        if (xmp == null) {
            throw new NullPointerException("xmp == null");
        }
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        XmpCache xmpCache = this;
        synchronized (xmpCache) {
            if (!this.fileCache.containsKey(file)) {
                return;
            }
            XmpCacheIndirection ci = (XmpCacheIndirection)this.fileCache.get(file);
            this.updateUsageTime(ci);
            ci.xmp = xmp;
            this.fileCache.maybeCleanupCache();
        }
        if (repaint) {
            EventQueueUtil.invokeInDispatchThread(new Runnable(){

                @Override
                public void run() {
                    if (xmp.isEmpty()) {
                        XmpCache.this.notifyUpdate(file, TypedThumbnailUpdateEvent.Type.XMP_EMPTY_UPDATE);
                    } else {
                        XmpCache.this.notifyUpdate(file);
                    }
                }
            });
        }
    }

    public synchronized Xmp getXmp(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        XmpCacheIndirection ci = (XmpCacheIndirection)this.fileCache.get(file);
        if (ci == null) {
            this.generateEntry(file, false);
            return null;
        }
        this.updateUsageTime(ci);
        if (ci.xmp == null) {
            this.workQueue.push(ci);
            return null;
        }
        return ci.xmp;
    }

    private void notifyUpdate(File file, TypedThumbnailUpdateEvent.Type type) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        if (type == null) {
            throw new NullPointerException("type == null");
        }
        for (ThumbnailUpdateListener l : this.updateListeners) {
            l.thumbnailUpdated(new TypedThumbnailUpdateEvent(file, type));
        }
    }

    @Override
    public void notifyUpdate(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        for (ThumbnailUpdateListener l : this.updateListeners) {
            l.thumbnailUpdated(new TypedThumbnailUpdateEvent(file, TypedThumbnailUpdateEvent.Type.XMP_UPDATE));
        }
    }

    private static class XmpFetcher
    implements Runnable {
        private final ImageFilesRepository repo = Lookup.getDefault().lookup(ImageFilesRepository.class);
        private final WorkQueue<XmpCacheIndirection> wq;
        private final XmpCache cache;

        XmpFetcher(WorkQueue<XmpCacheIndirection> _wq, XmpCache _cache) {
            this.wq = _wq;
            this.cache = _cache;
        }

        @Override
        public void run() {
            HashSet<File> imageFiles = new HashSet<File>();
            File imageFile = null;
            while (true) {
                block10: {
                    if (imageFiles.size() < 1) {
                        try {
                            imageFile = this.wq.fetch().file;
                            break block10;
                        }
                        catch (Throwable t) {
                            continue;
                        }
                    }
                    XmpCacheIndirection ci = this.wq.poll();
                    imageFile = ci != null ? ci.file : null;
                }
                if (imageFile != null) {
                    imageFiles.add(imageFile);
                }
                if (imageFile != null && imageFiles.size() < 64) continue;
                if (imageFiles.size() > 1) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                List<FileXmp> res = this.repo.findXmpOfImageFiles(imageFiles);
                boolean repaint = true;
                for (FileXmp fileXmp : res) {
                    File temp = fileXmp.getFile();
                    Xmp xmp = fileXmp.getXmp();
                    this.cache.update(xmp, temp, repaint);
                    imageFiles.remove(temp);
                }
                for (File f : imageFiles) {
                    Xmp xmp = new Xmp();
                    this.cache.update(xmp, f, false);
                }
                imageFiles.clear();
            }
        }
    }
}

