/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails.cache;

import java.util.ArrayDeque;
import java.util.Deque;

public class WorkQueue<E> {
    final Deque<E> queue = new ArrayDeque();

    public synchronized void push(E e) {
        if (e == null) {
            throw new NullPointerException("e == null");
        }
        this.queue.remove(e);
        this.queue.push(e);
        this.notify();
    }

    public synchronized void append(E e) {
        if (e == null) {
            throw new NullPointerException("e == null");
        }
        if (!this.queue.contains(e)) {
            this.queue.add(e);
            this.notify();
        }
    }

    public synchronized E fetch() throws InterruptedException {
        while (this.queue.isEmpty()) {
            this.wait();
        }
        return this.queue.removeFirst();
    }

    public synchronized E poll() {
        return this.queue.pollFirst();
    }

    public synchronized void remove(E e) {
        if (e == null) {
            throw new NullPointerException("e == null");
        }
        this.queue.remove(e);
    }
}

