/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails.cache;

import java.awt.Image;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.domain.event.listener.ThumbnailUpdateListener;
import org.jphototagger.domain.repository.event.imagefiles.ImageFileDeletedEvent;
import org.jphototagger.domain.repository.event.imagefiles.ImageFileInsertedEvent;
import org.jphototagger.domain.repository.event.imagefiles.ImageFileMovedEvent;
import org.jphototagger.domain.thumbnails.event.ThumbnailUpdatedEvent;
import org.jphototagger.domain.thumbnails.event.TypedThumbnailUpdateEvent;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.thumbnails.cache.Cache;
import org.jphototagger.program.module.thumbnails.cache.ThumbnailCacheIndirection;
import org.jphototagger.program.module.thumbnails.cache.ThumbnailsDb;
import org.jphototagger.program.module.thumbnails.cache.WorkQueue;

public final class ThumbnailCache
extends Cache<ThumbnailCacheIndirection> {
    public static final ThumbnailCache INSTANCE = new ThumbnailCache();
    private final Image noPreviewThumbnail = IconUtil.getIconImage(Bundle.getString(ThumbnailCache.class, "ThumbnailCache.Path.NoPreviewThumbnail", new Object[0]));
    private static final Logger LOGGER = Logger.getLogger(ThumbnailCache.class.getName());

    private ThumbnailCache() {
        this.listen();
        ThumbnailFetcher thumbnailFetcher = new ThumbnailFetcher(this.workQueue, this);
        Thread thumbnailFetcherThread = new Thread((Runnable)thumbnailFetcher, "JPhotoTagger: ThumbnailFetcher");
        thumbnailFetcherThread.start();
    }

    private void listen() {
        AnnotationProcessor.process(this);
    }

    @EventSubscriber(eventClass=ImageFileDeletedEvent.class)
    public void imageFileDeleted(ImageFileDeletedEvent evt) {
        this.fileCache.remove(evt.getImageFile());
    }

    @EventSubscriber(eventClass=ImageFileInsertedEvent.class)
    public void imageFileInserted(ImageFileInsertedEvent evt) {
        this.notifyUpdate(evt.getImageFile());
    }

    @EventSubscriber(eventClass=ImageFileMovedEvent.class)
    public void imageFileRenamed(ImageFileMovedEvent evt) {
        this.fileCache.remove(evt.getOldImageFile());
        this.notifyUpdate(evt.getNewImageFile());
    }

    @EventSubscriber(eventClass=ThumbnailUpdatedEvent.class)
    public void thumbnailUpdated(ThumbnailUpdatedEvent evt) {
        File imageFile = evt.getImageFile();
        this.fileCache.remove(imageFile);
        this.notifyUpdate(imageFile);
    }

    @Override
    protected synchronized void generateEntry(File file, boolean prefetch) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        ThumbnailCacheIndirection ci = new ThumbnailCacheIndirection(file);
        this.updateUsageTime(ci);
        this.fileCache.put(file, ci);
        if (prefetch) {
            this.workQueue.append(ci);
        } else {
            this.workQueue.push(ci);
        }
    }

    public synchronized void update(Image image, final File file) {
        if (image == null) {
            throw new NullPointerException("image == null");
        }
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        if (!this.fileCache.containsKey(file)) {
            return;
        }
        ThumbnailCacheIndirection ci = (ThumbnailCacheIndirection)this.fileCache.get(file);
        this.updateUsageTime(ci);
        ci.thumbnail = image;
        this.fileCache.maybeCleanupCache();
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                ThumbnailCache.this.notifyUpdate(file);
            }
        });
    }

    public synchronized Image getThumbnail(File file) {
        ThumbnailCacheIndirection ci;
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        while (null == (ci = (ThumbnailCacheIndirection)this.fileCache.get(file))) {
            this.generateEntry(file, false);
        }
        this.updateUsageTime(ci);
        return ci.thumbnail;
    }

    @Override
    public void notifyUpdate(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        for (ThumbnailUpdateListener l : this.updateListeners) {
            l.thumbnailUpdated(new TypedThumbnailUpdateEvent(file, TypedThumbnailUpdateEvent.Type.THUMBNAIL_UPDATE));
        }
    }

    private static class ThumbnailFetcher
    implements Runnable {
        private final ThumbnailCache cache;
        private final WorkQueue<ThumbnailCacheIndirection> wq;

        ThumbnailFetcher(WorkQueue<ThumbnailCacheIndirection> imageWQ, ThumbnailCache _cache) {
            this.wq = imageWQ;
            this.cache = _cache;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        File imageFile = this.wq.fetch().file;
                        Image thumbnail = null;
                        if (imageFile == null) {
                            LOGGER.log(Level.WARNING, "Didn't find image file in preview cache (is null)!");
                        } else {
                            thumbnail = ThumbnailsDb.findThumbnail(imageFile);
                        }
                        if (thumbnail == null) {
                            thumbnail = this.cache.noPreviewThumbnail;
                        }
                        this.cache.update(thumbnail, imageFile);
                    }
                }
                catch (Throwable t) {
                    Logger.getLogger(ThumbnailFetcher.class.getName()).log(Level.SEVERE, null, t);
                    continue;
                }
                break;
            }
        }
    }
}

