/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails.cache;

import java.io.File;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jphototagger.program.module.thumbnails.cache.CacheIndirection;
import org.jphototagger.program.module.thumbnails.cache.CacheIndirectionAgeComparator;
import org.jphototagger.program.module.thumbnails.cache.WorkQueue;

public class SoftCacheMap<C extends CacheIndirection> {
    private final HashMap<File, SoftReference<C>> _map = new HashMap();
    private final int MAX_ENTRIES;
    final WorkQueue<C> w;

    public SoftCacheMap(int maxEntries, WorkQueue<C> _w) {
        if (_w == null) {
            throw new NullPointerException("_w == null");
        }
        this.MAX_ENTRIES = maxEntries;
        this.w = _w;
    }

    public C get(File k) {
        if (k == null) {
            throw new NullPointerException("k == null");
        }
        SoftReference<C> sr = this._map.get(k);
        if (sr == null) {
            return null;
        }
        return (C)((CacheIndirection)sr.get());
    }

    public C put(File k, C v) {
        if (k == null) {
            throw new NullPointerException("k == null");
        }
        if (v == null) {
            throw new NullPointerException("v == null");
        }
        SoftReference<C> sr = this._map.put(k, new SoftReference<C>(v));
        if (sr == null) {
            return null;
        }
        return (C)((CacheIndirection)sr.get());
    }

    public C remove(File k) {
        if (k == null) {
            throw new NullPointerException("k == null");
        }
        SoftReference<C> sr = this._map.remove(k);
        if (sr == null) {
            return null;
        }
        return (C)((CacheIndirection)sr.get());
    }

    public void clear() {
        this._map.clear();
    }

    public int size() {
        return this._map.size();
    }

    public boolean containsKey(File k) {
        if (k == null) {
            throw new NullPointerException("k == null");
        }
        if (!this._map.containsKey(k)) {
            return false;
        }
        return this._map.get(k).get() != null;
    }

    public Set<File> keySet() {
        return this._map.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeCleanupCache() {
        if (this.size() <= this.MAX_ENTRIES) {
            return;
        }
        TreeSet removes = new TreeSet(new CacheIndirectionAgeComparator());
        removes.addAll(this._map.entrySet());
        Iterator it = removes.iterator();
        for (int index = 0; index < this.MAX_ENTRIES / 10 && it.hasNext(); ++index) {
            Map.Entry e = (Map.Entry)it.next();
            if (e.getValue() == null) {
                this._map.remove(e.getKey());
                continue;
            }
            CacheIndirection ci = (CacheIndirection)((SoftReference)e.getValue()).get();
            if (ci == null) {
                this._map.remove(e.getKey());
                continue;
            }
            CacheIndirection cacheIndirection = ci;
            synchronized (cacheIndirection) {
                if (ci.isEmpty() && this.w != null) {
                    this.w.remove(ci);
                }
                this._map.remove(ci.file);
                continue;
            }
        }
    }
}

