/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails.cache;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.domain.event.listener.ThumbnailUpdateListener;
import org.jphototagger.domain.thumbnails.event.TypedThumbnailUpdateEvent;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.thumbnails.ThumbnailPanelRenderer;
import org.jphototagger.program.module.thumbnails.cache.CacheIndirection;
import org.jphototagger.program.module.thumbnails.cache.RenderedThumbnailCacheIndirection;
import org.jphototagger.program.module.thumbnails.cache.SoftCacheMap;
import org.jphototagger.program.module.thumbnails.cache.ThumbnailCache;
import org.jphototagger.program.module.thumbnails.cache.WorkQueue;
import org.jphototagger.program.module.thumbnails.cache.XmpCache;

public final class RenderedThumbnailCache
implements ThumbnailUpdateListener {
    public static final RenderedThumbnailCache INSTANCE = new RenderedThumbnailCache();
    private final int MAX_ENTRIES = 1500;
    private static int currentAge = 0;
    private final Set<ThumbnailUpdateListener> updateListeners = new HashSet<ThumbnailUpdateListener>();
    private final WorkQueue<RenderedThumbnailCacheIndirection> workQueue = new WorkQueue();
    private final ThumbnailCache thumbCache = ThumbnailCache.INSTANCE;
    private final XmpCache xmpCache = XmpCache.INSTANCE;
    private Image scaledDummyThumbnail = null;
    private final Image dummyThumbnail = IconUtil.getIconImage(Bundle.getString(RenderedThumbnailCache.class, "RenderedThumbnailCache.Path.DummyThumbnail", new Object[0]));
    private final SoftCacheMap<RenderedThumbnailCacheIndirection> fileCache = new SoftCacheMap<RenderedThumbnailCacheIndirection>(1500, this.workQueue);
    private ThumbnailPanelRenderer renderer = null;

    private RenderedThumbnailCache() {
        this.thumbCache.addThumbnailUpdateListener(this);
        XmpCache.INSTANCE.addThumbnailUpdateListener(this);
        Thread t = new Thread((Runnable)new ThumbnailRenderer(this.workQueue, this), "JPhotoTagger: ThumbnailRenderer");
        t.start();
    }

    private synchronized void update(Image image, final File file, int length, boolean repaint) {
        RenderedThumbnailCacheIndirection ci = this.fileCache.get(file);
        if (ci == null) {
            return;
        }
        this.updateUsageTime(ci);
        ci.thumbnail = image;
        ci.length = length;
        this.fileCache.maybeCleanupCache();
        if (repaint) {
            EventQueueUtil.invokeInDispatchThread(new Runnable(){

                @Override
                public void run() {
                    RenderedThumbnailCache.this.notifyUpdate(file);
                }
            });
        }
    }

    public void rerender(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        this.generateEntry(file, this.renderer.getThumbnailWidth(), false);
    }

    public synchronized void rerenderAll(boolean overlay) {
        int count = 0;
        int skipped = 0;
        for (File file : this.fileCache.keySet()) {
            ++count;
            RenderedThumbnailCacheIndirection ci = this.fileCache.get(file);
            if (overlay && ci != null && ci.renderedForKeywords) {
                ++skipped;
                continue;
            }
            if (!overlay && ci != null && !ci.hasKeywords) {
                ++skipped;
                continue;
            }
            this.generateEntry(file, this.renderer.getThumbnailWidth(), false);
        }
    }

    public synchronized void setRenderer(ThumbnailPanelRenderer _renderer) {
        if (_renderer == null) {
            throw new NullPointerException("_renderer == null");
        }
        this.renderer = _renderer;
    }

    public void addThumbnailUpdateListener(ThumbnailUpdateListener _listener) {
        if (_listener == null) {
            throw new NullPointerException("_listener == null");
        }
        this.updateListeners.add(_listener);
    }

    public void removeThumbnailUpdateListener(ThumbnailUpdateListener _listener) {
        if (_listener == null) {
            throw new NullPointerException("_listener == null");
        }
        this.updateListeners.remove(_listener);
    }

    public void notifyUpdate(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        this.notifyUpdate(new TypedThumbnailUpdateEvent(file, TypedThumbnailUpdateEvent.Type.RENDERED_THUMBNAIL_UPDATE));
    }

    public void notifyUpdate(TypedThumbnailUpdateEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        for (ThumbnailUpdateListener l : this.updateListeners) {
            l.thumbnailUpdated(evt);
        }
    }

    private void updateUsageTime(CacheIndirection ci) {
        if (ci == null) {
            throw new NullPointerException("ci == null");
        }
        ci.usageTime = currentAge++;
    }

    public boolean contains(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        return this.fileCache.containsKey(file);
    }

    public synchronized Image getThumbnail(File file, int length, boolean overlay) {
        RenderedThumbnailCacheIndirection ci;
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        while (null == (ci = this.fileCache.get(file))) {
            this.generateEntry(file, length, false);
        }
        this.updateUsageTime(ci);
        if (ci.thumbnail == null || ci.length == length && (!overlay && !ci.hasKeywords || overlay && ci.renderedForKeywords)) {
            return ci.thumbnail;
        }
        this.generateEntry(file, length, false);
        if (ci.length == length) {
            return ci.thumbnail;
        }
        return null;
    }

    private synchronized void generateEntry(File file, int length, boolean prefetch) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        RenderedThumbnailCacheIndirection ci = new RenderedThumbnailCacheIndirection(file, length);
        this.fileCache.put(file, ci);
        this.updateUsageTime(ci);
        if (prefetch) {
            this.workQueue.append(ci);
        } else {
            this.workQueue.push(ci);
        }
    }

    public synchronized void remove(Collection<? extends File> files) {
        if (files == null) {
            throw new NullPointerException("list == null");
        }
        for (File file : files) {
            this.remove(file);
        }
    }

    public synchronized void remove(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        this.fileCache.remove(file);
    }

    public synchronized void clear() {
        this.fileCache.clear();
    }

    private Image computeScaled(Image image, int length) {
        int height;
        double longer;
        int width = image.getWidth(null);
        double d = longer = width > (height = image.getHeight(null)) ? (double)width : (double)height;
        if (longer == (double)length) {
            return image;
        }
        double scaleFactor = (double)length / longer;
        int tw = width > height ? length : (int)((double)width * scaleFactor + 0.5);
        int th = height > width ? length : (int)((double)height * scaleFactor + 0.5);
        BufferedImage scaled = new BufferedImage(tw, th, 1);
        Graphics2D g2 = scaled.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.drawImage(image, 0, 0, tw, th, null);
        g2.dispose();
        return scaled;
    }

    @Override
    public void thumbnailUpdated(TypedThumbnailUpdateEvent event) {
        RenderedThumbnailCacheIndirection ci;
        if (event.getType() == TypedThumbnailUpdateEvent.Type.XMP_EMPTY_UPDATE && (ci = this.fileCache.get(event.getSource())) != null && !ci.hasKeywords) {
            return;
        }
        this.remove(event.getSource());
        this.notifyUpdate(event);
    }

    public void updateFiles(File oldFile, File newFile) {
        if (oldFile == null) {
            throw new NullPointerException("oldFile == null");
        }
        if (newFile == null) {
            throw new NullPointerException("newFile == null");
        }
        this.remove(oldFile);
    }

    public void prefetch(File file, int length, boolean xmp) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        if (this.fileCache.containsKey(file)) {
            return;
        }
        this.thumbCache.prefetch(file);
        if (xmp) {
            this.xmpCache.prefetch(file);
        }
        this.generateEntry(file, length, true);
    }

    private boolean correctlyScaled(Image image, int length) {
        int height;
        int width = image.getWidth(null);
        int longer = width > (height = image.getHeight(null)) ? width : height;
        return longer == length;
    }

    private static class ThumbnailRenderer
    implements Runnable {
        private final WorkQueue<RenderedThumbnailCacheIndirection> wq;
        private final RenderedThumbnailCache cache;

        ThumbnailRenderer(WorkQueue<RenderedThumbnailCacheIndirection> imageWQ, RenderedThumbnailCache _cache) {
            this.wq = imageWQ;
            this.cache = _cache;
        }

        @Override
        public void run() {
            while (true) {
                RenderedThumbnailCacheIndirection rtci = null;
                try {
                    rtci = this.wq.fetch();
                    assert (rtci.file != null);
                    Image im = this.cache.thumbCache.getThumbnail(rtci.file);
                    if (im == null) {
                        if (this.cache.scaledDummyThumbnail == null || !this.cache.correctlyScaled(this.cache.scaledDummyThumbnail, rtci.length)) {
                            this.cache.scaledDummyThumbnail = this.cache.computeScaled(this.cache.dummyThumbnail, rtci.length);
                        }
                        im = this.cache.scaledDummyThumbnail;
                        im = this.cache.renderer.getRenderedThumbnail(im, rtci, true);
                    } else {
                        im = this.cache.computeScaled(im, rtci.length);
                        im = this.cache.renderer.getRenderedThumbnail(im, rtci, false);
                    }
                    this.cache.update(im, rtci.file, rtci.length, true);
                    continue;
                }
                catch (Throwable t) {
                    Logger.getLogger(ThumbnailRenderer.class.getName()).log(Level.SEVERE, null, t);
                    continue;
                }
                break;
            }
        }
    }
}

