/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails.cache;

import java.io.File;
import org.jphototagger.api.storage.CacheDirectoryProvider;
import org.jphototagger.api.storage.PreferencesDirectoryProvider;
import org.openide.util.Lookup;

public final class CacheDirectoryProviderImpl
implements CacheDirectoryProvider {
    private static final String CACHE_DIRECTORY_ROOT_PATHNAME;

    @Override
    public File getCacheDirectory(String subdirectory) {
        String pathname = CACHE_DIRECTORY_ROOT_PATHNAME + File.separator + subdirectory;
        return this.ensureDirectoryExists(pathname);
    }

    private File ensureDirectoryExists(String pathname) {
        boolean created;
        File directory = new File(pathname);
        if (!directory.isDirectory() && !(created = directory.mkdirs())) {
            throw new RuntimeException("Error creating cache directory '" + pathname + "'");
        }
        return directory;
    }

    static {
        PreferencesDirectoryProvider provider = Lookup.getDefault().lookup(PreferencesDirectoryProvider.class);
        File userDirectory = provider.getUserPreferencesDirectory();
        CACHE_DIRECTORY_ROOT_PATHNAME = userDirectory + File.separator + "cache";
    }
}

