/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails.cache;

import java.io.File;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jphototagger.domain.event.listener.ThumbnailUpdateListener;
import org.jphototagger.program.module.thumbnails.cache.CacheIndirection;
import org.jphototagger.program.module.thumbnails.cache.SoftCacheMap;
import org.jphototagger.program.module.thumbnails.cache.WorkQueue;

public abstract class Cache<CI extends CacheIndirection> {
    private static final int MAX_ENTRIES = 1500;
    private static int currentAge = 0;
    final Set<ThumbnailUpdateListener> updateListeners = new CopyOnWriteArraySet<ThumbnailUpdateListener>();
    protected final WorkQueue<CI> workQueue = new WorkQueue();
    protected final SoftCacheMap<CI> fileCache = new SoftCacheMap<CI>(1500, this.workQueue);

    Cache() {
    }

    protected void updateUsageTime(CacheIndirection ci) {
        if (ci == null) {
            throw new NullPointerException("ci == null");
        }
        ci.usageTime = currentAge++;
    }

    public void addThumbnailUpdateListener(ThumbnailUpdateListener _listener) {
        if (_listener == null) {
            throw new NullPointerException("_listener == null");
        }
        this.updateListeners.add(_listener);
    }

    public void removeThumbnailUpdateListener(ThumbnailUpdateListener _listener) {
        if (_listener == null) {
            throw new NullPointerException("_listener == null");
        }
        this.updateListeners.remove(_listener);
    }

    public abstract void notifyUpdate(File var1);

    public synchronized void prefetch(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        if (this.fileCache.containsKey(file)) {
            return;
        }
        this.generateEntry(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFiles(File oldFile, File newFile) {
        Cache cache = this;
        synchronized (cache) {
            if (oldFile == null) {
                throw new NullPointerException("oldFile == null");
            }
            if (newFile == null) {
                throw new NullPointerException("newFile == null");
            }
            CI sci = this.fileCache.remove(oldFile);
            if (sci != null) {
                ((CacheIndirection)sci).file = newFile;
                this.fileCache.put(newFile, sci);
            }
        }
        this.notifyUpdate(oldFile);
    }

    public synchronized void remove(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        this.fileCache.remove(file);
    }

    protected abstract void generateEntry(File var1, boolean var2);
}

