/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXList;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesChangedEvent;
import org.jphototagger.lib.api.LookAndFeelChangedEvent;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.openide.util.Lookup;

public class WarnOnEqualBasenamesTaskDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private final DefaultListModel<Object> filesListModel;
    private boolean isDisplayInFuture;
    private boolean listenToDisplayInFutureCheckBox = false;
    private JCheckBox checkBoxDisplayInFuture;
    private JXLabel labelInfo;
    private JXList listFiles;
    private JScrollPane scrollPanlFiles;

    public WarnOnEqualBasenamesTaskDialog(Collection<? extends File> files) {
        super(ComponentUtil.findFrameWithIcon(), false);
        if (files == null) {
            throw new NullPointerException("files == null");
        }
        this.filesListModel = new DefaultListModel();
        this.addFilesToListModel(files);
        this.initComponents();
        this.postInitComponents();
        this.listenToDisplayInFutureCheckBox = true;
    }

    private void addFilesToListModel(Collection<? extends File> files) {
        for (File file : files) {
            this.filesListModel.addElement(file);
        }
    }

    private void postInitComponents() {
        this.readDisplayInFutureFromPreferences();
        this.checkBoxDisplayInFuture.setSelected(this.isDisplayInFuture);
        AnnotationProcessor.process(this);
    }

    private void readDisplayInFutureFromPreferences() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        this.isDisplayInFuture = prefs == null ? true : (prefs.containsKey("WarnOnEqualBasenamesTaskDialog.DisplayInFuture") ? prefs.getBoolean("WarnOnEqualBasenamesTaskDialog.DisplayInFuture") : true);
    }

    private void storePropertyDisplayInFuture() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setBoolean("WarnOnEqualBasenamesTaskDialog.DisplayInFuture", this.isDisplayInFuture);
    }

    @EventSubscriber(eventClass=PreferencesChangedEvent.class)
    public void userPropertyChanged(PreferencesChangedEvent evt) {
        String propertyKey = evt.getKey();
        if ("WarnOnEqualBasenamesTaskDialog.DisplayInFuture".equals(propertyKey)) {
            this.listenToDisplayInFutureCheckBox = false;
            boolean newValue = (Boolean)evt.getNewValue();
            this.checkBoxDisplayInFuture.setSelected(newValue);
            ComponentUtil.forceRepaint(this.checkBoxDisplayInFuture);
            this.listenToDisplayInFutureCheckBox = true;
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            if (this.isDisplayInFuture) {
                super.setVisible(true);
            }
        } else {
            super.setVisible(false);
        }
    }

    @EventSubscriber(eventClass=LookAndFeelChangedEvent.class)
    public void lookAndFeelChanged(LookAndFeelChangedEvent evt) {
        SwingUtilities.updateComponentTreeUI(this);
    }

    private void initComponents() {
        this.labelInfo = new JXLabel();
        this.scrollPanlFiles = new JScrollPane();
        this.listFiles = new JXList();
        this.checkBoxDisplayInFuture = new JCheckBox();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/thumbnails/Bundle");
        this.setTitle(bundle.getString("WarnOnEqualBasenamesTaskDialog.title"));
        this.setName("Form");
        this.labelInfo.setText(bundle.getString("WarnOnEqualBasenamesTaskDialog.labelInfo.text"));
        this.labelInfo.setLineWrap(true);
        this.labelInfo.setName("labelInfo");
        this.scrollPanlFiles.setName("scrollPanlFiles");
        this.listFiles.setModel((ListModel)this.filesListModel);
        this.listFiles.setSelectionMode(0);
        this.listFiles.setName("listFiles");
        this.scrollPanlFiles.setViewportView(this.listFiles);
        this.checkBoxDisplayInFuture.setText(bundle.getString("WarnOnEqualBasenamesTaskDialog.checkBoxDisplayInFuture.text"));
        this.checkBoxDisplayInFuture.setName("checkBoxDisplayInFuture");
        this.checkBoxDisplayInFuture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WarnOnEqualBasenamesTaskDialog.this.checkBoxDisplayInFutureActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxDisplayInFuture).addComponent(this.scrollPanlFiles, -1, 551, Short.MAX_VALUE).addComponent(this.labelInfo, -1, 551, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.labelInfo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPanlFiles, -1, 165, Short.MAX_VALUE).addGap(10, 10, 10).addComponent(this.checkBoxDisplayInFuture).addContainerGap()));
        this.pack();
    }

    private void checkBoxDisplayInFutureActionPerformed(ActionEvent evt) {
        if (this.listenToDisplayInFutureCheckBox) {
            this.isDisplayInFuture = this.checkBoxDisplayInFuture.isSelected();
            this.storePropertyDisplayInFuture();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                WarnOnEqualBasenamesTaskDialog dialog = new WarnOnEqualBasenamesTaskDialog(Collections.emptyList());
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

