/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.jphototagger.api.component.Selectable;
import org.jphototagger.domain.thumbnails.ThumbnailsDisplayer;
import org.jphototagger.lib.swing.KeyEventUtil;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

final class ToggleMetaDataOverlayAction
extends AbstractAction
implements Selectable {
    private static final long serialVersionUID = 1L;
    private boolean selected = this.getSelectedFromThumbnailsDisplayer();

    ToggleMetaDataOverlayAction() {
        super(Bundle.getString(ToggleMetaDataOverlayAction.class, "ToggleMetaDataOverlayAction.Name", new Object[0]));
        this.putValue("AcceleratorKey", KeyEventUtil.getKeyStrokeMenuShortcutWithShiftDown(79));
        this.setSelectedKey();
    }

    private void setSelectedKey() {
        this.putValue("SwingSelectedKey", this.selected ? Boolean.TRUE : null);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.toggleMetaDataOverlay();
    }

    private void toggleMetaDataOverlay() {
        ThumbnailsDisplayer thumbnailsDisplayer = Lookup.getDefault().lookup(ThumbnailsDisplayer.class);
        boolean isKeywordsOverlay = !thumbnailsDisplayer.isMetaDataOverlay();
        thumbnailsDisplayer.setMetaDataOverlay(isKeywordsOverlay);
        this.selected = isKeywordsOverlay;
        this.setSelectedKey();
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
        this.setSelectedKey();
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    private boolean getSelectedFromThumbnailsDisplayer() {
        ThumbnailsDisplayer thumbnailsDisplayer = Lookup.getDefault().lookup(ThumbnailsDisplayer.class);
        return thumbnailsDisplayer == null ? false : thumbnailsDisplayer.isMetaDataOverlay();
    }
}

