/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.DefaultComboBoxModel;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.thumbnails.FileSortComparator;
import org.jphototagger.domain.thumbnails.FileSortComparators;
import org.jphototagger.lib.api.LayerUtil;
import org.jphototagger.lib.api.PositionProviderAscendingComparator;
import org.jphototagger.lib.comparator.FileSort;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public final class ThumbnailsSortComboBoxModel
extends DefaultComboBoxModel<Object> {
    private static final long serialVersionUID = 1L;
    static final String PERSISTED_SELECTED_ITEM_KEY = "ThumbnailsSortComboBoxModel.SelIndex";

    public ThumbnailsSortComboBoxModel() {
        this.addFileSorters();
    }

    private void addFileSorters() {
        this.addElement(new FileSorter(FileSort.PATHS_ASCENDING.getComparator(), Bundle.getString(ThumbnailsSortComboBoxModel.class, "ThumbnailsSortComboBoxModel.DisplayName.ComparatorFilePathAscending", new Object[0])));
        this.addElement(new FileSorter(FileSort.PATHS_DESCENDING.getComparator(), Bundle.getString(ThumbnailsSortComboBoxModel.class, "ThumbnailsSortComboBoxModel.DisplayName.ComparatorFilePathDescending", new Object[0])));
        this.addElement(new FileSorter(FileSort.NAMES_ASCENDING.getComparator(), Bundle.getString(ThumbnailsSortComboBoxModel.class, "ThumbnailsSortComboBoxModel.DisplayName.ComparatorFileNameAscending", new Object[0])));
        this.addElement(new FileSorter(FileSort.NAMES_DESCENDING.getComparator(), Bundle.getString(ThumbnailsSortComboBoxModel.class, "ThumbnailsSortComboBoxModel.DisplayName.ComparatorFileNameDescending", new Object[0])));
        this.addElement(new FileSorter(FileSort.LAST_MODIFIED_ASCENDING.getComparator(), Bundle.getString(ThumbnailsSortComboBoxModel.class, "ThumbnailsSortComboBoxModel.DisplayName.ComparatorFileLastModifiedAscending", new Object[0])));
        this.addElement(new FileSorter(FileSort.LAST_MODIFIED_DESCENDING.getComparator(), Bundle.getString(ThumbnailsSortComboBoxModel.class, "ThumbnailsSortComboBoxModel.DisplayName.ComparatorFileLastModifiedDescending", new Object[0])));
        this.addElement(new FileSorter(FileSort.TYPES_ASCENDING.getComparator(), Bundle.getString(ThumbnailsSortComboBoxModel.class, "ThumbnailsSortComboBoxModel.DisplayName.ComparatorFileTypeAscending", new Object[0])));
        this.addElement(new FileSorter(FileSort.TYPES_DESCENDING.getComparator(), Bundle.getString(ThumbnailsSortComboBoxModel.class, "ThumbnailsSortComboBoxModel.DisplayName.ComparatorFileTypeDescending", new Object[0])));
        Collection<FileSortComparators> sortComparators = Lookup.getDefault().lookupAll(FileSortComparators.class);
        ArrayList<FileSortComparator> sortedSortComparators = new ArrayList<FileSortComparator>();
        for (FileSortComparators fscs : sortComparators) {
            sortedSortComparators.addAll(fscs.getFileSortComparators());
        }
        Collections.sort(sortedSortComparators, PositionProviderAscendingComparator.INSTANCE);
        LayerUtil.logWarningIfNotUniquePositions(sortedSortComparators);
        for (FileSortComparator fileSortComparator : sortedSortComparators) {
            this.addElement(new FileSorter(fileSortComparator.getAscendingSortComparator(), fileSortComparator.getAscendingSortComparatorDisplayName()));
            this.addElement(new FileSorter(fileSortComparator.getDescendingSortComparator(), fileSortComparator.getDescendingSortComparatorDisplayName()));
        }
        this.addElement(new FileSorter(FileSort.NO_SORT.getComparator(), Bundle.getString(ThumbnailsSortComboBoxModel.class, "ThumbnailsSortComboBoxModel.DisplayName.ComparatorNoSort", new Object[0])));
    }

    void selectPersistedItem() {
        int index;
        Preferences references = Lookup.getDefault().lookup(Preferences.class);
        if (references.containsKey(PERSISTED_SELECTED_ITEM_KEY) && (index = references.getInt(PERSISTED_SELECTED_ITEM_KEY)) >= 0 && index < this.getSize()) {
            this.setSelectedItem(this.getElementAt(index));
        }
    }

    public static class FileSorter {
        private final Comparator<File> comparator;
        private final String displayName;

        public FileSorter(Comparator<File> comparator, String displayName) {
            if (comparator == null) {
                throw new NullPointerException("comparator == null");
            }
            if (displayName == null) {
                throw new NullPointerException("displayName == null");
            }
            this.comparator = comparator;
            this.displayName = displayName;
        }

        public Comparator<File> getComparator() {
            return this.comparator;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

