/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.storage.Persistence;
import org.jphototagger.domain.thumbnails.ExternalThumbnailCreationCommand;
import org.jphototagger.image.thumbnail.ThumbnailCreationStrategy;
import org.jphototagger.image.thumbnail.ThumbnailCreationStrategyProvider;
import org.jphototagger.lib.help.HelpPageProvider;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.thumbnails.ThumbnailCreatorSettingsDialog;
import org.jphototagger.program.module.thumbnails.ThumbnailDimensionsSettingsPanel;
import org.openide.util.Lookup;

public final class ThumbnailsSettingsPanel
extends JPanel
implements Persistence,
HelpPageProvider {
    private static final long serialVersionUID = 1L;
    private JPopupMenu createExternalThumbnailCreatorPopupMenu;
    private final Map<JRadioButton, ThumbnailCreationStrategy> thumbnailCreatorOfRadioButton = new HashMap<JRadioButton, ThumbnailCreationStrategy>();
    private final EnumMap<ThumbnailCreationStrategy, JRadioButton> radioButtonOfThumbnailCreator = new EnumMap(ThumbnailCreationStrategy.class);
    private JButton buttonChooseExternalThumbnailCreator;
    private ButtonGroup buttonGroupThumbnailCreator;
    private JButton buttonThumbnailCreatorsSettings;
    private JCheckBox checkBoxDisplayThumbnailTooltip;
    private JCheckBox checkBoxDisplayThumbnailsBottomPanel;
    private JLabel labelIsCreateThumbnailsWithExternalApp;
    private JPanel panelExternalThumbnailApp;
    private JPanel panelFurtherSettings;
    private JPanel panelPadding;
    private ThumbnailDimensionsSettingsPanel panelSettingsThumbnailDimensions;
    private JPanel panelThumbnailCreator;
    private JRadioButton radioButtonCreateThumbnailsWithExternalApp;
    private JRadioButton radioButtonCreateThumbnailsWithJPhotoTagger;
    private JTextField textFieldExternalThumbnailCreationCommand;

    public ThumbnailsSettingsPanel() {
        this.initComponents();
        this.initMaps();
        MnemonicUtil.setMnemonics(this);
    }

    private void initMaps() {
        this.thumbnailCreatorOfRadioButton.put(this.radioButtonCreateThumbnailsWithExternalApp, ThumbnailCreationStrategy.EXTERNAL_APP);
        this.thumbnailCreatorOfRadioButton.put(this.radioButtonCreateThumbnailsWithJPhotoTagger, ThumbnailCreationStrategy.JPHOTOTAGGER);
        for (JRadioButton radioButton : this.thumbnailCreatorOfRadioButton.keySet()) {
            this.radioButtonOfThumbnailCreator.put((ThumbnailCreationStrategy)((Enum)this.thumbnailCreatorOfRadioButton.get(radioButton)), radioButton);
        }
    }

    @Override
    public void restore() {
        this.restoreThumbnailCreationStrategy();
        this.restoreExternalThumbnailAppEnabled();
        this.panelSettingsThumbnailDimensions.restore();
        this.textFieldExternalThumbnailCreationCommand.setText(this.getExternalThumbnailCreationCommand());
        this.checkBoxDisplayThumbnailTooltip.setSelected(this.isDisplayThumbnailTooltip());
        this.checkBoxDisplayThumbnailsBottomPanel.setSelected(this.isDisplayThumbnailsBottomPanel());
    }

    private boolean isDisplayThumbnailTooltip() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.DisplayThumbnailTooltip") ? prefs.getBoolean("UserSettings.DisplayThumbnailTooltip") : true;
    }

    private boolean isDisplayThumbnailsBottomPanel() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.DisplayThumbnailsBottomPanel") ? prefs.getBoolean("UserSettings.DisplayThumbnailsBottomPanel") : true;
    }

    private String getExternalThumbnailCreationCommand() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.getString("UserSettings.ExternalThumbnailCreationCommand");
    }

    private void restoreThumbnailCreationStrategy() {
        ThumbnailCreationStrategy strategy = this.getThumbnailCreationStrategy();
        for (JRadioButton radioButton : this.radioButtonOfThumbnailCreator.values()) {
            JRadioButton radioButtonOfCreator = this.radioButtonOfThumbnailCreator.get((Object)strategy);
            radioButton.setSelected(radioButtonOfCreator == radioButton);
        }
    }

    private ThumbnailCreationStrategy getThumbnailCreationStrategy() {
        ThumbnailCreationStrategyProvider provider = Lookup.getDefault().lookup(ThumbnailCreationStrategyProvider.class);
        return provider.getThumbnailCreationStrategy();
    }

    private void restoreExternalThumbnailAppEnabled() {
        ThumbnailCreationStrategy strategy = this.getThumbnailCreationStrategy();
        boolean isCreatorExternalApp = strategy.equals((Object)ThumbnailCreationStrategy.EXTERNAL_APP);
        this.textFieldExternalThumbnailCreationCommand.setEnabled(isCreatorExternalApp);
        this.buttonChooseExternalThumbnailCreator.setEnabled(isCreatorExternalApp);
    }

    private void chooseExternalThumbnailCreator() {
        if (this.createExternalThumbnailCreatorPopupMenu == null) {
            this.createExternalThumbnailCreatorPopupMenu = this.createExternalThumbnailCreatorPopupMenu();
        }
        int buttonHeight = this.buttonChooseExternalThumbnailCreator.getHeight();
        this.createExternalThumbnailCreatorPopupMenu.show(this.buttonChooseExternalThumbnailCreator, 0, buttonHeight);
    }

    private JPopupMenu createExternalThumbnailCreatorPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        Collection<ExternalThumbnailCreationCommand> externalThumbnailCreators = Lookup.getDefault().lookupAll(ExternalThumbnailCreationCommand.class);
        for (ExternalThumbnailCreationCommand externalThumbnailCreator : externalThumbnailCreators) {
            if (!externalThumbnailCreator.isEnabled()) continue;
            ExternalThumbnailCreatorAction action = new ExternalThumbnailCreatorAction(externalThumbnailCreator);
            popupMenu.add(action);
        }
        return popupMenu;
    }

    @Override
    public String getHelpPageUrl() {
        return Bundle.getString(ThumbnailDimensionsSettingsPanel.class, "SettingsThumbnailDimensionsPanel.HelpPage", new Object[0]);
    }

    private void showThumbnailCreatorsSettingsDialog() {
        ThumbnailCreatorSettingsDialog dialog = new ThumbnailCreatorSettingsDialog();
        dialog.setVisible(true);
        ComponentUtil.parentWindowToFront(this);
    }

    private void setExternalThumbnailCreationCommand(String command) {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setString("UserSettings.ExternalThumbnailCreationCommand", command);
    }

    private void setDisplayThumbnailTooltip() {
        boolean isDisplayThumbnailTooltip = this.checkBoxDisplayThumbnailTooltip.isSelected();
        this.setDisplayThumbnailTooltip(isDisplayThumbnailTooltip);
    }

    private void setDisplayThumbnailsBottomPanel() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        boolean display = this.checkBoxDisplayThumbnailsBottomPanel.isSelected();
        prefs.setBoolean("UserSettings.DisplayThumbnailsBottomPanel", display);
    }

    private void setDisplayThumbnailTooltip(boolean display) {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setBoolean("UserSettings.DisplayThumbnailTooltip", display);
    }

    @Override
    public void persist() {
    }

    private void handleTextFieldExternalThumbnailCreationCommandKeyReleased() {
        this.setExternalThumbnailCreationCommand(this.textFieldExternalThumbnailCreationCommand.getText());
    }

    private void setThumbnailCreator(JRadioButton radioButton) {
        this.setThumbnailCreationStrategy(this.thumbnailCreatorOfRadioButton.get(radioButton));
        boolean selected = this.radioButtonCreateThumbnailsWithExternalApp.isSelected();
        this.textFieldExternalThumbnailCreationCommand.setEnabled(selected);
        this.buttonChooseExternalThumbnailCreator.setEnabled(selected);
    }

    private void setThumbnailCreationStrategy(ThumbnailCreationStrategy creator) {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setString("UserSettings.ThumbnailCreator", creator.name());
    }

    private void initComponents() {
        this.buttonGroupThumbnailCreator = new ButtonGroup();
        this.panelSettingsThumbnailDimensions = new ThumbnailDimensionsSettingsPanel();
        this.panelThumbnailCreator = new JPanel();
        this.radioButtonCreateThumbnailsWithJPhotoTagger = new JRadioButton();
        this.radioButtonCreateThumbnailsWithExternalApp = new JRadioButton();
        this.buttonChooseExternalThumbnailCreator = new JButton();
        this.panelExternalThumbnailApp = new JPanel();
        this.labelIsCreateThumbnailsWithExternalApp = new JLabel();
        this.textFieldExternalThumbnailCreationCommand = new JTextField();
        this.checkBoxDisplayThumbnailTooltip = new JCheckBox();
        this.checkBoxDisplayThumbnailsBottomPanel = new JCheckBox();
        this.panelFurtherSettings = new JPanel();
        this.buttonThumbnailCreatorsSettings = new JButton();
        this.panelPadding = new JPanel();
        this.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/thumbnails/Bundle");
        this.panelSettingsThumbnailDimensions.setBorder(BorderFactory.createTitledBorder(bundle.getString("ThumbnailsSettingsPanel.panelSettingsThumbnailDimensions.border.title")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.panelSettingsThumbnailDimensions, gridBagConstraints);
        this.panelThumbnailCreator.setBorder(BorderFactory.createTitledBorder(bundle.getString("ThumbnailsSettingsPanel.panelThumbnailCreator.border.title")));
        this.panelThumbnailCreator.setLayout(new GridBagLayout());
        this.buttonGroupThumbnailCreator.add(this.radioButtonCreateThumbnailsWithJPhotoTagger);
        this.radioButtonCreateThumbnailsWithJPhotoTagger.setText(bundle.getString("ThumbnailsSettingsPanel.radioButtonCreateThumbnailsWithJPhotoTagger.text"));
        this.radioButtonCreateThumbnailsWithJPhotoTagger.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThumbnailsSettingsPanel.this.radioButtonCreateThumbnailsWithJPhotoTaggerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelThumbnailCreator.add((Component)this.radioButtonCreateThumbnailsWithJPhotoTagger, gridBagConstraints);
        this.buttonGroupThumbnailCreator.add(this.radioButtonCreateThumbnailsWithExternalApp);
        this.radioButtonCreateThumbnailsWithExternalApp.setText(bundle.getString("ThumbnailsSettingsPanel.radioButtonCreateThumbnailsWithExternalApp.text"));
        this.radioButtonCreateThumbnailsWithExternalApp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThumbnailsSettingsPanel.this.radioButtonCreateThumbnailsWithExternalAppActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelThumbnailCreator.add((Component)this.radioButtonCreateThumbnailsWithExternalApp, gridBagConstraints);
        this.buttonChooseExternalThumbnailCreator.setText(bundle.getString("ThumbnailsSettingsPanel.buttonChooseExternalThumbnailCreator.text"));
        this.buttonChooseExternalThumbnailCreator.setEnabled(false);
        this.buttonChooseExternalThumbnailCreator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThumbnailsSettingsPanel.this.buttonChooseExternalThumbnailCreatorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelThumbnailCreator.add((Component)this.buttonChooseExternalThumbnailCreator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.panelThumbnailCreator, gridBagConstraints);
        this.panelExternalThumbnailApp.setBorder(BorderFactory.createTitledBorder(bundle.getString("ThumbnailsSettingsPanel.panelExternalThumbnailApp.border.title")));
        this.panelExternalThumbnailApp.setLayout(new GridBagLayout());
        this.labelIsCreateThumbnailsWithExternalApp.setHorizontalAlignment(2);
        this.labelIsCreateThumbnailsWithExternalApp.setLabelFor(this.textFieldExternalThumbnailCreationCommand);
        this.labelIsCreateThumbnailsWithExternalApp.setText(bundle.getString("ThumbnailsSettingsPanel.labelIsCreateThumbnailsWithExternalApp.text"));
        this.labelIsCreateThumbnailsWithExternalApp.setPreferredSize(new Dimension(1694, 60));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelExternalThumbnailApp.add((Component)this.labelIsCreateThumbnailsWithExternalApp, gridBagConstraints);
        this.textFieldExternalThumbnailCreationCommand.setEnabled(false);
        this.textFieldExternalThumbnailCreationCommand.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ThumbnailsSettingsPanel.this.textFieldExternalThumbnailCreationCommandKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.panelExternalThumbnailApp.add((Component)this.textFieldExternalThumbnailCreationCommand, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.panelExternalThumbnailApp, gridBagConstraints);
        this.checkBoxDisplayThumbnailTooltip.setText(bundle.getString("ThumbnailsSettingsPanel.checkBoxDisplayThumbnailTooltip.text"));
        this.checkBoxDisplayThumbnailTooltip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThumbnailsSettingsPanel.this.checkBoxDisplayThumbnailTooltipActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.checkBoxDisplayThumbnailTooltip, gridBagConstraints);
        this.checkBoxDisplayThumbnailsBottomPanel.setText(bundle.getString("ThumbnailsSettingsPanel.checkBoxDisplayThumbnailsBottomPanel.text"));
        this.checkBoxDisplayThumbnailsBottomPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThumbnailsSettingsPanel.this.checkBoxDisplayThumbnailsBottomPanelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.add((Component)this.checkBoxDisplayThumbnailsBottomPanel, gridBagConstraints);
        this.panelFurtherSettings.setName("panelFurtherSettings");
        this.panelFurtherSettings.setLayout(new GridBagLayout());
        this.buttonThumbnailCreatorsSettings.setText(bundle.getString("ThumbnailsSettingsPanel.buttonThumbnailCreatorsSettings.text"));
        this.buttonThumbnailCreatorsSettings.setName("buttonThumbnailCreatorsSettings");
        this.buttonThumbnailCreatorsSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThumbnailsSettingsPanel.this.buttonThumbnailCreatorsSettingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelFurtherSettings.add((Component)this.buttonThumbnailCreatorsSettings, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.panelFurtherSettings, gridBagConstraints);
        GroupLayout panelPaddingLayout = new GroupLayout(this.panelPadding);
        this.panelPadding.setLayout(panelPaddingLayout);
        panelPaddingLayout.setHorizontalGroup(panelPaddingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 802, Short.MAX_VALUE));
        panelPaddingLayout.setVerticalGroup(panelPaddingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 114, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.panelPadding, gridBagConstraints);
    }

    private void textFieldExternalThumbnailCreationCommandKeyReleased(KeyEvent evt) {
        this.handleTextFieldExternalThumbnailCreationCommandKeyReleased();
    }

    private void radioButtonCreateThumbnailsWithExternalAppActionPerformed(ActionEvent evt) {
        this.setThumbnailCreator((JRadioButton)evt.getSource());
    }

    private void radioButtonCreateThumbnailsWithJPhotoTaggerActionPerformed(ActionEvent evt) {
        this.setThumbnailCreator((JRadioButton)evt.getSource());
    }

    private void buttonChooseExternalThumbnailCreatorActionPerformed(ActionEvent evt) {
        this.chooseExternalThumbnailCreator();
    }

    private void checkBoxDisplayThumbnailTooltipActionPerformed(ActionEvent evt) {
        this.setDisplayThumbnailTooltip();
    }

    private void checkBoxDisplayThumbnailsBottomPanelActionPerformed(ActionEvent evt) {
        this.setDisplayThumbnailsBottomPanel();
    }

    private void buttonThumbnailCreatorsSettingsActionPerformed(ActionEvent evt) {
        this.showThumbnailCreatorsSettingsDialog();
    }

    private class ExternalThumbnailCreatorAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final ExternalThumbnailCreationCommand externalThumbnailCreator;

        private ExternalThumbnailCreatorAction(ExternalThumbnailCreationCommand externalThumbnailCreator) {
            this.putValue("Name", externalThumbnailCreator.getDisplayName());
            this.externalThumbnailCreator = externalThumbnailCreator;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String thumbnailCreationCommand = this.externalThumbnailCreator.getThumbnailCreationCommand();
            if (thumbnailCreationCommand != null) {
                ThumbnailsSettingsPanel.this.textFieldExternalThumbnailCreationCommand.setText(thumbnailCreationCommand);
                ThumbnailsSettingsPanel.this.setExternalThumbnailCreationCommand(thumbnailCreationCommand);
            }
        }
    }
}

