/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.plugin.fileprocessor.FileProcessorPlugin;
import org.jphototagger.api.windows.MenuItemProvider;
import org.jphototagger.domain.programs.Program;
import org.jphototagger.domain.programs.ProgramType;
import org.jphototagger.domain.repository.ProgramsRepository;
import org.jphototagger.domain.repository.event.programs.ProgramDeletedEvent;
import org.jphototagger.domain.repository.event.programs.ProgramInsertedEvent;
import org.jphototagger.domain.repository.event.programs.ProgramUpdatedEvent;
import org.jphototagger.domain.thumbnails.ThumbnailsPopupMenuItemProvider;
import org.jphototagger.lib.api.LayerUtil;
import org.jphototagger.lib.api.PositionProviderAscendingComparator;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.swing.KeyEventUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.app.ui.AppLookAndFeel;
import org.jphototagger.program.factory.FileProcessorPluginManager;
import org.jphototagger.program.module.actions.ActionsUtil;
import org.jphototagger.program.module.programs.AddProgramController;
import org.jphototagger.program.plugins.PluginAction;
import org.openide.util.Lookup;

public final class ThumbnailsPopupMenu
extends JPopupMenu {
    public static final ImageIcon ICON_IMAGE_COLLECTION = AppLookAndFeel.getIcon("icon_imagecollection.png");
    private static final ImageIcon ICON_IMAGE_COLLECTION_ADD_TO = AppLookAndFeel.getIcon("icon_imagecollection_add_to.png");
    private static final ImageIcon ICON_IMAGE_COLLECTION_REMOVE_FROM = AppLookAndFeel.getIcon("icon_imagecollection_remove_from.png");
    private static final ImageIcon ICON_PICKED = AppLookAndFeel.getIcon("icon_picked.png");
    private static final ImageIcon ICON_REJECTED = AppLookAndFeel.getIcon("icon_rejected.png");
    private static final ImageIcon ICON_ROTATE_180 = AppLookAndFeel.getIcon("icon_rotate_180.png");
    private static final ImageIcon ICON_ROTATE_270 = AppLookAndFeel.getIcon("icon_rotate_270.png");
    private static final ImageIcon ICON_ROTATE_90 = AppLookAndFeel.getIcon("icon_rotate_90.png");
    private static final ImageIcon ICON_XMP_RATING_1 = AppLookAndFeel.getIcon("icon_xmp_rating_1.png");
    private static final ImageIcon ICON_XMP_RATING_2 = AppLookAndFeel.getIcon("icon_xmp_rating_2.png");
    private static final ImageIcon ICON_XMP_RATING_3 = AppLookAndFeel.getIcon("icon_xmp_rating_3.png");
    private static final ImageIcon ICON_XMP_RATING_4 = AppLookAndFeel.getIcon("icon_xmp_rating_4.png");
    private static final ImageIcon ICON_XMP_RATING_5 = AppLookAndFeel.getIcon("icon_xmp_rating_5.png");
    private static final ImageIcon ICON_XMP_RATING_REMOVE = AppLookAndFeel.getIcon("icon_xmp_rating_remove.png");
    private static final long serialVersionUID = 1L;
    private static final AddProgramController ADD_PROGRAM_ACTION = new AddProgramController();
    private final JMenu menuRefresh = new JMenu(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.MenuRefresh", new Object[0]));
    private final JMenu menuPrograms = new JMenu(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.MenuOtherOpenImageApps", new Object[0]));
    private final JMenu menuMetadata = new JMenu(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.MenuMetadata", new Object[0]));
    private final JMenu menuImageCollection = new JMenu(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.MenuImageCollection", new Object[0]));
    private final JMenu menuRotateThumbnail = new JMenu(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.MenuRotateThumbnail", new Object[0]));
    private final JMenu menuRating = new JMenu(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.menuRating", new Object[0]));
    private final JMenu menuPlugins = new JMenu(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.MenuPlugins", new Object[0]));
    private final JMenu menuSelection = new JMenu(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.MenuSelection", new Object[0]));
    private final JMenu menuFsOps = new JMenu(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.MenuFileSystemOps", new Object[0]));
    private final JMenu menuActions = ActionsUtil.actionsAsMenu();
    private final JMenuItem itemUpdateThumbnail = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.Action.UpdateThumbnail", new Object[0]));
    private final JMenuItem itemUpdateMetadata = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.Action.UpdateMetadata", new Object[0]));
    private final JMenuItem itemSelectNothing = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.ItemSelectNothing", new Object[0]));
    private final JMenuItem itemSelectAll = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.ItemSelectAll", new Object[0]));
    private final JMenuItem itemRotateThumbnail90 = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.Action.Rotate.90", new Object[0]), ICON_ROTATE_90);
    private final JMenuItem itemRotateThumbnail270 = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.Action.Rotate.270", new Object[0]), ICON_ROTATE_270);
    private final JMenuItem itemRotateThumbnai180 = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.Action.Rotate.180", new Object[0]), ICON_ROTATE_180);
    private final JMenuItem itemReject = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.Action.Reject", new Object[0]), ICON_REJECTED);
    private final JMenuItem itemRefresh = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.Action.Refresh", new Object[0]), AppLookAndFeel.ICON_REFRESH);
    private final JMenuItem itemRating5 = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.Rating5", new Object[0]), ICON_XMP_RATING_5);
    private final JMenuItem itemRating4 = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.Rating4", new Object[0]), ICON_XMP_RATING_4);
    private final JMenuItem itemRating3 = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.Rating3", new Object[0]), ICON_XMP_RATING_3);
    private final JMenuItem itemRating2 = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.Rating2", new Object[0]), ICON_XMP_RATING_2);
    private final JMenuItem itemRating1 = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.Rating1", new Object[0]), ICON_XMP_RATING_1);
    private final JMenuItem itemRating0 = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.Rating0", new Object[0]), ICON_XMP_RATING_REMOVE);
    private final JMenuItem itemPick = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.Action.Pick", new Object[0]), ICON_PICKED);
    private final JMenuItem itemPasteMetadata = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.ItemPasteMetadata", new Object[0]), AppLookAndFeel.ICON_PASTE);
    private final JMenuItem itemPasteFromClipboard = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.ItemPasteFromClipboard", new Object[0]), AppLookAndFeel.ICON_PASTE);
    private final JMenuItem itemOpenFilesWithStandardApp = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.Action.OpenFiles", new Object[0]));
    private final JMenuItem itemFileSystemRenameFiles = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.Action.FileSystemRename", new Object[0]));
    private final JMenuItem itemFileSystemMoveFiles = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.Action.FileSystemMove", new Object[0]));
    private final JMenuItem itemFileSystemDeleteFiles = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.Action.FileSystemDeleteFiles", new Object[0]), AppLookAndFeel.ICON_DELETE);
    private final JMenuItem itemFileSystemCopyToDirectory = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.Action.FileSystemCopyToDirectory", new Object[0]), AppLookAndFeel.ICON_COPY);
    private final JMenuItem itemDeleteImageFromRepository = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.Action.DeleteImageFromRepository", new Object[0]));
    private final JMenuItem itemDeleteFromImageCollection = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.Action.DeleteFromImageCollection", new Object[0]), ICON_IMAGE_COLLECTION_REMOVE_FROM);
    private final JMenuItem itemCutToClipboard = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.ItemCutToClipboard", new Object[0]), AppLookAndFeel.ICON_CUT);
    private final JMenuItem itemCreateImageCollection = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.Action.CreateImageCollection", new Object[0]), ICON_IMAGE_COLLECTION);
    private final JMenuItem itemCopyToClipboard = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.ItemCopyToClipboard", new Object[0]), AppLookAndFeel.ICON_COPY);
    private final JMenuItem itemCopyMetadata = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.ItemCopyMetadata", new Object[0]), AppLookAndFeel.ICON_COPY);
    private final JMenuItem itemAddToImageCollection = new JMenuItem(Bundle.getString(ThumbnailsPopupMenu.class, "ThumbnailsPopupMenu.DisplayName.Action.AddToImageCollection", new Object[0]), ICON_IMAGE_COLLECTION_ADD_TO);
    private final List<ActionListener> actionListenersOpenFilesWithOtherApp = new ArrayList<ActionListener>();
    private final Map<JMenuItem, Program> programOfMenuItem = new HashMap<JMenuItem, Program>();
    private final Map<JMenuItem, Long> RATING_OF_ITEM = new HashMap<JMenuItem, Long>();
    private final Map<JMenuItem, FileProcessorPlugin> FILE_PROCESSOR_PLUGIN_OF_ITEM = new HashMap<JMenuItem, FileProcessorPlugin>();
    private final Map<JMenuItem, Action> ACTION_OF_ITEM = new HashMap<JMenuItem, Action>();
    public static final ThumbnailsPopupMenu INSTANCE = new ThumbnailsPopupMenu();

    private ThumbnailsPopupMenu() {
        this.init();
    }

    private void initRatingOfItem() {
        this.RATING_OF_ITEM.put(this.itemRating0, 0L);
        this.RATING_OF_ITEM.put(this.itemRating1, 1L);
        this.RATING_OF_ITEM.put(this.itemRating2, 2L);
        this.RATING_OF_ITEM.put(this.itemRating3, 3L);
        this.RATING_OF_ITEM.put(this.itemRating4, 4L);
        this.RATING_OF_ITEM.put(this.itemRating5, 5L);
    }

    private void addItems() {
        this.menuRefresh.add(this.itemUpdateThumbnail);
        this.menuRefresh.add(this.itemUpdateMetadata);
        this.menuRefresh.add(this.itemDeleteImageFromRepository);
        this.menuRefresh.add(this.itemRefresh);
        this.add(this.menuRefresh);
        this.menuRotateThumbnail.add(this.itemRotateThumbnail90);
        this.menuRotateThumbnail.add(this.itemRotateThumbnail270);
        this.menuRotateThumbnail.add(this.itemRotateThumbnai180);
        this.add(this.menuRotateThumbnail);
        this.add(new JPopupMenu.Separator());
        this.add(this.itemOpenFilesWithStandardApp);
        this.add(this.menuPrograms);
        this.add(this.menuActions);
        this.addPluginItems();
        this.add(new JPopupMenu.Separator());
        this.menuRating.add(this.itemRating0);
        this.menuRating.add(this.itemRating1);
        this.menuRating.add(this.itemRating2);
        this.menuRating.add(this.itemRating3);
        this.menuRating.add(this.itemRating4);
        this.menuRating.add(this.itemRating5);
        this.add(this.menuRating);
        this.menuSelection.add(this.itemPick);
        this.menuSelection.add(this.itemReject);
        this.add(this.menuSelection);
        this.menuImageCollection.add(this.itemCreateImageCollection);
        this.menuImageCollection.add(this.itemAddToImageCollection);
        this.menuImageCollection.add(this.itemDeleteFromImageCollection);
        this.add(this.menuImageCollection);
        this.menuMetadata.add(this.itemCopyMetadata);
        this.menuMetadata.add(this.itemPasteMetadata);
        this.add(this.menuMetadata);
        this.itemPasteMetadata.setEnabled(false);
        this.menuFsOps.add(this.itemCopyToClipboard);
        this.menuFsOps.add(this.itemCutToClipboard);
        this.menuFsOps.add(this.itemPasteFromClipboard);
        this.menuFsOps.add(new JPopupMenu.Separator());
        this.menuFsOps.add(this.itemFileSystemCopyToDirectory);
        this.menuFsOps.add(new JPopupMenu.Separator());
        this.menuFsOps.add(this.itemFileSystemRenameFiles);
        this.menuFsOps.add(this.itemFileSystemMoveFiles);
        this.menuFsOps.add(this.itemFileSystemDeleteFiles);
        this.menuFsOps.add(new JPopupMenu.Separator());
        this.menuFsOps.add(this.itemSelectAll);
        this.menuFsOps.add(this.itemSelectNothing);
        this.add(this.menuFsOps);
        this.lookupItems();
    }

    private void lookupItems() {
        Collection<ThumbnailsPopupMenuItemProvider> providers = Lookup.getDefault().lookupAll(ThumbnailsPopupMenuItemProvider.class);
        ArrayList<MenuItemProvider> rootItemProviders = new ArrayList<MenuItemProvider>();
        ArrayList<MenuItemProvider> refreshItemProviders = new ArrayList<MenuItemProvider>();
        ArrayList<MenuItemProvider> fileOperationItemProviders = new ArrayList<MenuItemProvider>();
        ArrayList<MenuItemProvider> metaDataItemProviders = new ArrayList<MenuItemProvider>();
        for (ThumbnailsPopupMenuItemProvider provider : providers) {
            rootItemProviders.addAll(provider.getRootMenuItems());
            refreshItemProviders.addAll(provider.getRefreshMenuItems());
            metaDataItemProviders.addAll(provider.getMetaDataMenuItems());
            fileOperationItemProviders.addAll(provider.getFileOperationsMenuItems());
        }
        this.insertMenuItems(rootItemProviders, null);
        this.insertMenuItems(refreshItemProviders, this.menuRefresh);
        this.insertMenuItems(metaDataItemProviders, this.menuMetadata);
        this.insertMenuItems(fileOperationItemProviders, this.menuFsOps);
    }

    private void insertMenuItems(List<MenuItemProvider> menuItemProviders, JMenu intoMenu) {
        Collections.sort(menuItemProviders, PositionProviderAscendingComparator.INSTANCE);
        LayerUtil.logWarningIfNotUniquePositions(menuItemProviders);
        for (MenuItemProvider menuItemProvider : menuItemProviders) {
            int itemIndex;
            int intoItemCount = intoMenu == null ? this.getComponentCount() : intoMenu.getItemCount();
            int itemProviderPosition = menuItemProvider.getPosition();
            int n = itemIndex = itemProviderPosition <= intoItemCount ? itemProviderPosition : intoItemCount;
            if (menuItemProvider.isSeparatorBefore()) {
                if (intoMenu == null) {
                    this.add((Component)new JPopupMenu.Separator(), itemIndex);
                } else {
                    intoMenu.add((Component)new JPopupMenu.Separator(), itemIndex);
                }
                ++itemIndex;
            }
            JMenuItem menuItem = menuItemProvider.getMenuItem();
            if (intoMenu == null) {
                this.add((Component)menuItem, itemIndex);
                continue;
            }
            intoMenu.add((Component)menuItem, itemIndex);
        }
    }

    private void addPluginItems() {
        if (!FileProcessorPluginManager.INSTANCE.hasEnabledPlugins()) {
            return;
        }
        this.add(this.menuPlugins);
        for (FileProcessorPlugin plugin : FileProcessorPluginManager.INSTANCE.getEnabledPlugins()) {
            if (!plugin.isAvailable()) continue;
            this.addItemsOf(plugin);
        }
    }

    private void addItemsOf(FileProcessorPlugin plugin) {
        PluginAction<FileProcessorPlugin> pluginAction = new PluginAction<FileProcessorPlugin>(plugin);
        JMenuItem pluginItem = new JMenuItem(pluginAction);
        this.ACTION_OF_ITEM.put(pluginItem, pluginAction);
        this.FILE_PROCESSOR_PLUGIN_OF_ITEM.put(pluginItem, plugin);
        this.menuPlugins.add(pluginItem);
    }

    public void setOtherPrograms() {
        this.menuPrograms.removeAll();
        this.programOfMenuItem.clear();
        ProgramsRepository repo = Lookup.getDefault().lookup(ProgramsRepository.class);
        List<Program> programs = repo.findAllPrograms(ProgramType.PROGRAM);
        if (!programs.isEmpty()) {
            for (Program program : programs) {
                String alias = program.getAlias();
                JMenuItem item = new JMenuItem(alias);
                for (ActionListener listener : this.actionListenersOpenFilesWithOtherApp) {
                    item.addActionListener(listener);
                }
                this.menuPrograms.add(item);
                if (program.getFile().exists()) {
                    item.setIcon(IconUtil.getSystemIcon(program.getFile()));
                }
                this.programOfMenuItem.put(item, program);
            }
        }
        this.menuPrograms.add(ADD_PROGRAM_ACTION);
    }

    public Action getActionOfItem(JMenuItem item) {
        return this.ACTION_OF_ITEM.get(item);
    }

    @EventSubscriber(eventClass=ProgramDeletedEvent.class)
    public void programDeleted(ProgramDeletedEvent evt) {
        this.updatePrograms(evt.getProgram());
    }

    @EventSubscriber(eventClass=ProgramInsertedEvent.class)
    public void programInserted(ProgramInsertedEvent evt) {
        this.updatePrograms(evt.getProgram());
    }

    @EventSubscriber(eventClass=ProgramUpdatedEvent.class)
    public void programUpdated(ProgramUpdatedEvent evt) {
        this.updatePrograms(evt.getProgram());
    }

    private void updatePrograms(Program updatedProgram) {
        if (!updatedProgram.isAction()) {
            this.setOtherPrograms();
        }
    }

    public JMenuItem getItemAddToImageCollection() {
        return this.itemAddToImageCollection;
    }

    public JMenuItem getItemFileSystemCopyToDirectory() {
        return this.itemFileSystemCopyToDirectory;
    }

    public JMenuItem getItemCreateImageCollection() {
        return this.itemCreateImageCollection;
    }

    public JMenuItem getItemDeleteFromImageCollection() {
        return this.itemDeleteFromImageCollection;
    }

    public JMenuItem getItemDeleteImageFromRepository() {
        return this.itemDeleteImageFromRepository;
    }

    public JMenuItem getItemFileSystemDeleteFiles() {
        return this.itemFileSystemDeleteFiles;
    }

    public JMenuItem getItemFileSystemMoveFiles() {
        return this.itemFileSystemMoveFiles;
    }

    public JMenuItem getItemFileSystemRenameFiles() {
        return this.itemFileSystemRenameFiles;
    }

    public JMenuItem getItemOpenFilesWithStandardApp() {
        return this.itemOpenFilesWithStandardApp;
    }

    public JMenuItem getItemRotateThumbnai180() {
        return this.itemRotateThumbnai180;
    }

    public JMenuItem getItemRotateThumbnail270() {
        return this.itemRotateThumbnail270;
    }

    public JMenuItem getItemRotateThumbnail90() {
        return this.itemRotateThumbnail90;
    }

    public JMenuItem getItemUpdateMetadata() {
        return this.itemUpdateMetadata;
    }

    public JMenuItem getItemUpdateThumbnail() {
        return this.itemUpdateThumbnail;
    }

    public JMenuItem getItemRefresh() {
        return this.itemRefresh;
    }

    public JMenuItem getItemPick() {
        return this.itemPick;
    }

    public JMenuItem getItemCopyMetadata() {
        return this.itemCopyMetadata;
    }

    public JMenuItem getItemPasteMetadata() {
        return this.itemPasteMetadata;
    }

    public JMenuItem getItemCopyToClipboard() {
        return this.itemCopyToClipboard;
    }

    public JMenuItem getItemPasteFromClipboard() {
        return this.itemPasteFromClipboard;
    }

    public JMenuItem getItemCutToClipboard() {
        return this.itemCutToClipboard;
    }

    public JMenuItem getItemReject() {
        return this.itemReject;
    }

    public JMenuItem getItemRating0() {
        return this.itemRating0;
    }

    public JMenuItem getItemRating1() {
        return this.itemRating1;
    }

    public JMenuItem getItemRating2() {
        return this.itemRating2;
    }

    public JMenuItem getItemRating3() {
        return this.itemRating3;
    }

    public JMenuItem getItemRating4() {
        return this.itemRating4;
    }

    public JMenuItem getItemRating5() {
        return this.itemRating5;
    }

    public JMenuItem getItemSelectAll() {
        return this.itemSelectAll;
    }

    public JMenuItem getItemSelectNothing() {
        return this.itemSelectNothing;
    }

    public JMenu getMenuRating() {
        return this.menuRating;
    }

    public JMenu getMenuPlugins() {
        return this.menuPlugins;
    }

    public JMenu getMenuFsOps() {
        return this.menuFsOps;
    }

    public JMenu getMenuImageCollection() {
        return this.menuImageCollection;
    }

    public JMenu getMenuMetadata() {
        return this.menuMetadata;
    }

    public JMenu getMenuPrograms() {
        return this.menuPrograms;
    }

    public JMenu getMenuActions() {
        return this.menuActions;
    }

    public JMenu getMenuRefresh() {
        return this.menuRefresh;
    }

    public JMenu getMenuRotateThumbnail() {
        return this.menuRotateThumbnail;
    }

    public JMenu getMenuSelection() {
        return this.menuSelection;
    }

    public Long getRatingOfItem(JMenuItem item) {
        return this.RATING_OF_ITEM.get(item);
    }

    public Set<JMenuItem> getFileProcessorPluginMenuItems() {
        return this.FILE_PROCESSOR_PLUGIN_OF_ITEM.keySet();
    }

    public FileProcessorPlugin getFileProcessorPluginOfItem(JMenuItem item) {
        return this.FILE_PROCESSOR_PLUGIN_OF_ITEM.get(item);
    }

    public synchronized void addActionListenerOpenFilesWithOtherApp(ActionListener listener) {
        this.actionListenersOpenFilesWithOtherApp.add(listener);
        this.setOtherPrograms();
    }

    public Program getProgram(Object source) {
        if (source instanceof JMenuItem) {
            return this.programOfMenuItem.get((JMenuItem)source);
        }
        return null;
    }

    private void init() {
        this.initRatingOfItem();
        this.addItems();
        this.itemDeleteFromImageCollection.setEnabled(false);
        this.setAccelerators();
        AnnotationProcessor.process(this);
    }

    private void setAccelerators() {
        this.itemDeleteFromImageCollection.setAccelerator(KeyEventUtil.getKeyStroke(127));
        this.itemFileSystemDeleteFiles.setAccelerator(KeyEventUtil.getKeyStroke(127));
        this.itemFileSystemRenameFiles.setAccelerator(KeyEventUtil.getKeyStroke(113));
        this.itemRefresh.setAccelerator(KeyEventUtil.getKeyStroke(116));
        this.itemCopyToClipboard.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(67));
        this.itemCutToClipboard.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(88));
        this.itemPasteFromClipboard.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(86));
        this.itemCopyMetadata.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcutWithShiftDown(67));
        this.itemPasteMetadata.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcutWithShiftDown(86));
        this.itemPick.setAccelerator(KeyEventUtil.getKeyStroke(80));
        this.itemReject.setAccelerator(KeyEventUtil.getKeyStroke(82));
        this.itemRating0.setAccelerator(KeyEventUtil.getKeyStroke(48));
        this.itemRating1.setAccelerator(KeyEventUtil.getKeyStroke(49));
        this.itemRating2.setAccelerator(KeyEventUtil.getKeyStroke(50));
        this.itemRating3.setAccelerator(KeyEventUtil.getKeyStroke(51));
        this.itemRating4.setAccelerator(KeyEventUtil.getKeyStroke(52));
        this.itemRating5.setAccelerator(KeyEventUtil.getKeyStroke(53));
        this.itemSelectAll.setAccelerator(KeyEventUtil.getKeyStrokeMenuShortcut(65));
    }
}

