/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jdesktop.swingx.JXList;
import org.jphototagger.domain.filefilter.FileFilterUtil;
import org.jphototagger.domain.metadata.MetaDataValueData;
import org.jphototagger.domain.metadata.SelectedFilesMetaDataEditor;
import org.jphototagger.domain.metadata.xmp.XmpDcSubjectsSubjectMetaDataValue;
import org.jphototagger.domain.repository.ImageCollectionsRepository;
import org.jphototagger.domain.templates.MetadataTemplate;
import org.jphototagger.lib.datatransfer.TransferUtil;
import org.jphototagger.lib.datatransfer.TransferableObject;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.datatransfer.DataTransferSupport;
import org.jphototagger.program.datatransfer.Flavor;
import org.jphototagger.program.module.favorites.FavoritesUtil;
import org.jphototagger.program.module.filesystem.FilesystemImageUtil;
import org.jphototagger.program.module.keywords.KeywordsUtil;
import org.jphototagger.program.module.miscmetadata.MiscMetadataUtil;
import org.jphototagger.program.module.thumbnails.ContentUtil;
import org.jphototagger.program.module.thumbnails.ThumbnailsPanel;
import org.jphototagger.program.resource.GUI;
import org.jphototagger.program.view.ViewUtil;
import org.openide.util.Lookup;

public final class ThumbnailsPanelTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        ThumbnailsPanel tnPanel = (ThumbnailsPanel)support.getComponent();
        return this.isMetadataDrop(support) || this.isImageCollection(tnPanel) || !support.isDataFlavorSupported(Flavor.THUMBNAILS_PANEL) && this.canImportFiles(tnPanel) && Flavor.hasFiles(support.getTransferable());
    }

    private boolean canImportFiles(ThumbnailsPanel tnPanel) {
        return ContentUtil.isSingleDirectoryContent(tnPanel.getOriginOfDisplayedThumbnails());
    }

    private boolean isMetadataDrop(TransferHandler.TransferSupport support) {
        return this.isThumbnailPos(support) && Flavor.isMetadataTransferred(support.getTransferable());
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        return new TransferableObject(FilesystemImageUtil.addSidecarFiles(((ThumbnailsPanel)c).getSelectedFiles()), this.getFlavors(c));
    }

    private DataFlavor[] getFlavors(JComponent c) {
        DataFlavor[] dataFlavorArray;
        if (((ThumbnailsPanel)c).getOriginOfDisplayedThumbnails().isFilesOfAnImageCollection()) {
            DataFlavor[] dataFlavorArray2 = new DataFlavor[4];
            dataFlavorArray2[0] = Flavor.THUMBNAILS_PANEL;
            dataFlavorArray2[1] = Flavor.FILE_LIST_FLAVOR;
            dataFlavorArray2[2] = Flavor.URI_LIST;
            dataFlavorArray = dataFlavorArray2;
            dataFlavorArray2[3] = Flavor.IMAGE_COLLECTION;
        } else {
            DataFlavor[] dataFlavorArray3 = new DataFlavor[3];
            dataFlavorArray3[0] = Flavor.THUMBNAILS_PANEL;
            dataFlavorArray3[1] = Flavor.FILE_LIST_FLAVOR;
            dataFlavorArray = dataFlavorArray3;
            dataFlavorArray3[2] = Flavor.URI_LIST;
        }
        return dataFlavorArray;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!support.isDrop()) {
            return false;
        }
        ThumbnailsPanel tnPanel = (ThumbnailsPanel)support.getComponent();
        if (this.isMetadataDrop(support)) {
            this.insertMetadata(support);
            return true;
        }
        if (tnPanel.isAFileSelected() && this.isImageCollection(tnPanel)) {
            this.moveSelectedImages(support, tnPanel);
            return true;
        }
        if (this.importFiles(this.getCurrentDirectory(), support)) {
            tnPanel.refresh();
            return true;
        }
        return false;
    }

    private boolean isImageCollection(ThumbnailsPanel panel) {
        if (panel == null) {
            throw new NullPointerException("panel == null");
        }
        return panel.getOriginOfDisplayedThumbnails().isFilesOfAnImageCollection();
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
    }

    private void moveSelectedImages(TransferHandler.TransferSupport support, ThumbnailsPanel panel) {
        Point dropPoint = support.getDropLocation().getDropPoint();
        panel.moveSelectedToIndex(panel.getImageMoveDropIndex(dropPoint.x, dropPoint.y));
        String imageCollectionName = this.getImageCollectionName();
        ImageCollectionsRepository repo = Lookup.getDefault().lookup(ImageCollectionsRepository.class);
        if (imageCollectionName != null) {
            repo.saveImageCollection(imageCollectionName, panel.getFiles());
        }
    }

    private String getImageCollectionName() {
        JXList listImageCollections = GUI.getAppPanel().getListImageCollections();
        Object selElement = null;
        int selectedIndex = listImageCollections.getSelectedIndex();
        if (selectedIndex >= 0) {
            int modelIndex = listImageCollections.convertIndexToModel(selectedIndex);
            selElement = listImageCollections.getModel().getElementAt(modelIndex);
        }
        return selElement == null ? null : selElement.toString();
    }

    private boolean insertMetadata(TransferHandler.TransferSupport support) {
        boolean selected;
        Transferable t = support.getTransferable();
        boolean dropOverSelectedThumbnail = this.isDropOverSelectedThumbnail(support);
        ThumbnailsPanel panel = (ThumbnailsPanel)support.getComponent();
        File imageFile = this.getImageFile(support);
        boolean bl = selected = panel.getSelectionCount() > 0;
        if (Flavor.hasKeywordsFromList(support)) {
            this.insertKeywords(t, dropOverSelectedThumbnail, imageFile);
        } else if (Flavor.hasKeywordsFromTree(support)) {
            this.insertHierarchicalKeywords(t, dropOverSelectedThumbnail, imageFile);
        } else if (Flavor.hasMetadataTemplate(support)) {
            this.insertTemplates(selected, support);
        } else if (Flavor.hasMetaDataValue(support)) {
            this.importMetaDataValueData(support, dropOverSelectedThumbnail, imageFile);
        } else {
            return false;
        }
        return true;
    }

    private void insertKeywords(Transferable t, boolean dropOverSelectedThumbnail, File imageFile) {
        this.importStrings(Flavor.KEYWORDS_LIST, DataTransferSupport.getKeywords(t), dropOverSelectedThumbnail, imageFile);
    }

    private void insertHierarchicalKeywords(Transferable t, boolean dropOverSelectedThumbnail, File imageFile) {
        ArrayList<String> keywords = new ArrayList<String>();
        for (DefaultMutableTreeNode node : DataTransferSupport.getKeywordNodes(t)) {
            if (dropOverSelectedThumbnail) {
                KeywordsUtil.addKeywordsToEditPanel(node);
                continue;
            }
            keywords.addAll(KeywordsUtil.getKeywordStrings(node, true));
        }
        if (!keywords.isEmpty()) {
            KeywordsUtil.saveKeywordsToImageFile(keywords, imageFile);
        }
    }

    private void insertTemplates(boolean selected, TransferHandler.TransferSupport support) {
        if (selected) {
            this.importMetadataTemplate(support);
        } else {
            this.errorMessageSelCount();
        }
    }

    private void importStrings(DataFlavor dataFlavor, Object[] strings, boolean dropOverSelectedThumbnail, File imageFile) {
        if (dataFlavor == null) {
            throw new NullPointerException("dataFlavor == null");
        }
        if (imageFile == null) {
            throw new NullPointerException("imageFile == null");
        }
        if (strings == null || strings.length <= 0) {
            return;
        }
        ArrayList<String> keywords = new ArrayList<String>(strings.length);
        for (Object o : strings) {
            keywords.add(o.toString());
        }
        if (dropOverSelectedThumbnail) {
            SelectedFilesMetaDataEditor editor = Lookup.getDefault().lookup(SelectedFilesMetaDataEditor.class);
            XmpDcSubjectsSubjectMetaDataValue column = dataFlavor.equals(Flavor.KEYWORDS_LIST) ? XmpDcSubjectsSubjectMetaDataValue.INSTANCE : null;
            for (String keyword : keywords) {
                editor.setOrAddText(column, keyword);
            }
        } else {
            KeywordsUtil.saveKeywordsToImageFile(keywords, imageFile);
        }
    }

    private boolean isDropOverSelectedThumbnail(TransferHandler.TransferSupport support) {
        if (support == null) {
            throw new NullPointerException("support == null");
        }
        Point p = support.getDropLocation().getDropPoint();
        ThumbnailsPanel panel = (ThumbnailsPanel)support.getComponent();
        return panel.isSelectedAtIndex(panel.getImageMoveDropIndex(p.x, p.y));
    }

    private boolean isThumbnailPos(TransferHandler.TransferSupport support) {
        Point p = support.getDropLocation().getDropPoint();
        ThumbnailsPanel panel = (ThumbnailsPanel)support.getComponent();
        int index = panel.getThumbnailIndexAtPoint(p.x, p.y);
        return panel.isIndex(index);
    }

    private File getImageFile(TransferHandler.TransferSupport support) {
        int index;
        Point p = support.getDropLocation().getDropPoint();
        ThumbnailsPanel panel = (ThumbnailsPanel)support.getComponent();
        if (panel.isIndex(index = panel.getThumbnailIndexAtPoint(p.x, p.y))) {
            return panel.getFileAtIndex(index);
        }
        return null;
    }

    private boolean importFiles(File targetDir, TransferHandler.TransferSupport support) {
        if (targetDir == null) {
            return false;
        }
        List<File> srcFiles = TransferUtil.getFiles(support.getTransferable(), TransferUtil.FilenameDelimiter.EMPTY);
        int dropAction = support.getDropAction();
        if (dropAction == 1) {
            FilesystemImageUtil.copyImageFiles(FileFilterUtil.getImageFiles(srcFiles), targetDir, FilesystemImageUtil.ConfirmOverwrite.YES);
            return true;
        }
        if (dropAction == 2) {
            FilesystemImageUtil.moveImageFiles(FileFilterUtil.getImageFiles(srcFiles), targetDir, FilesystemImageUtil.ConfirmOverwrite.YES);
            return true;
        }
        return false;
    }

    private File getCurrentDirectory() {
        JTree treeDirectories = GUI.getAppPanel().getTreeDirectories();
        JTree treeFavorites = GUI.getAppPanel().getTreeFavorites();
        if (treeDirectories.getSelectionCount() > 0) {
            return ViewUtil.getSelectedFile(treeDirectories);
        }
        if (treeFavorites.getSelectionCount() > 0) {
            return FavoritesUtil.getSelectedFavorite();
        }
        return null;
    }

    private void importMetadataTemplate(TransferHandler.TransferSupport support) {
        try {
            Object[] selTemplates = (Object[])support.getTransferable().getTransferData(Flavor.METADATA_TEMPLATES);
            if (selTemplates == null) {
                return;
            }
            assert (selTemplates.length == 1);
            SelectedFilesMetaDataEditor editor = Lookup.getDefault().lookup(SelectedFilesMetaDataEditor.class);
            editor.setMetadataTemplate((MetadataTemplate)selTemplates[0]);
        }
        catch (Throwable t) {
            Logger.getLogger(ThumbnailsPanelTransferHandler.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    private void importMetaDataValueData(TransferHandler.TransferSupport support, boolean dropOverSelectedThumbnail, File imageFile) {
        try {
            List mdValueData = (List)support.getTransferable().getTransferData(Flavor.META_DATA_VALUE);
            if (dropOverSelectedThumbnail) {
                if (!ViewUtil.checkSelImagesEditable(true)) {
                    return;
                }
                SelectedFilesMetaDataEditor editor = Lookup.getDefault().lookup(SelectedFilesMetaDataEditor.class);
                for (MetaDataValueData data : mdValueData) {
                    editor.setOrAddText(data.getMetaDataValue(), (String)data.getData());
                }
            } else {
                MiscMetadataUtil.saveToImageFile(mdValueData, imageFile);
            }
        }
        catch (Throwable t) {
            Logger.getLogger(ThumbnailsPanelTransferHandler.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    private void errorMessageSelCount() {
        String message = Bundle.getString(ThumbnailsPanelTransferHandler.class, "ThumbnailsPanelTransferHandler.Error.NoSelection", new Object[0]);
        MessageDisplayer.error(null, message);
    }
}

