/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.FileFilter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.TransferHandler;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.applifecycle.AppWillExitEvent;
import org.jphototagger.api.file.event.DirectoryRenamedEvent;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesChangedEvent;
import org.jphototagger.domain.event.listener.ThumbnailUpdateListener;
import org.jphototagger.domain.filefilter.UserDefinedFileFilter;
import org.jphototagger.domain.metadata.xmp.XmpSidecarFileResolver;
import org.jphototagger.domain.repository.event.imagefiles.ImageFileDeletedEvent;
import org.jphototagger.domain.repository.event.imagefiles.ImageFileInsertedEvent;
import org.jphototagger.domain.repository.event.imagefiles.ImageFileMovedEvent;
import org.jphototagger.domain.repository.event.userdefinedfilefilters.UserDefinedFileFilterUpdatedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpDeletedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpInsertedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpUpdatedEvent;
import org.jphototagger.domain.thumbnails.MainWindowThumbnailsComponent;
import org.jphototagger.domain.thumbnails.OriginOfDisplayedThumbnails;
import org.jphototagger.domain.thumbnails.ThumbnailFlag;
import org.jphototagger.domain.thumbnails.ThumbnailsPanelSettings;
import org.jphototagger.domain.thumbnails.event.ThumbnailsChangedEvent;
import org.jphototagger.domain.thumbnails.event.ThumbnailsPanelRefreshEvent;
import org.jphototagger.domain.thumbnails.event.ThumbnailsSelectionChangedEvent;
import org.jphototagger.domain.thumbnails.event.TypedThumbnailUpdateEvent;
import org.jphototagger.lib.api.PositionProviderAscendingComparator;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.comparator.FileSort;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.swing.MouseEventUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.MathUtil;
import org.jphototagger.lib.util.ObjectUtil;
import org.jphototagger.program.filefilter.AppFileFilters;
import org.jphototagger.program.module.thumbnails.ThumbnailDoubleklickController;
import org.jphototagger.program.module.thumbnails.ThumbnailPanelRenderer;
import org.jphototagger.program.module.thumbnails.ThumbnailsPanelTransferHandler;
import org.jphototagger.program.module.thumbnails.ThumbnailsPopupMenu;
import org.jphototagger.program.module.thumbnails.WarnOnEqualBasenamesTask;
import org.jphototagger.program.module.thumbnails.cache.RenderedThumbnailCache;
import org.jphototagger.program.types.ByteSizeUnit;
import org.jphototagger.program.types.FileAction;
import org.openide.util.Lookup;

public class ThumbnailsPanel
extends JPanel
implements ComponentListener,
MouseListener,
MouseMotionListener,
KeyListener,
ThumbnailUpdateListener {
    private static final String KEY_THUMBNAIL_WIDTH = "ThumbnailsPanel.ThumbnailWidth";
    private static final String KEY_SHOW_METADATA_OVERLAY = "UserSettings.ShowMetadataOverlay";
    private static final long serialVersionUID = 1L;
    private static final int MARGIN_THUMBNAIL = 3;
    public static final Color COLOR_FOREGROUND_PANEL = Color.WHITE;
    public static final Color COLOR_BACKGROUND_PANEL = new Color(32, 32, 32);
    private static final DateFormat TOOLTIP_FILE_DATE_FORMAT = DateFormat.getDateTimeInstance(2, 2);
    private int isClickInSelection = -1;
    private final Map<Integer, Set<ThumbnailFlag>> thumbnailFlagsAtIndex = new HashMap<Integer, Set<ThumbnailFlag>>();
    private final List<Integer> selectedThumbnailIndices = new ArrayList<Integer>();
    private int thumbnailCountPerRow = 0;
    private boolean dragThumbnailsEnabled = false;
    private boolean isDisplayThumbnailTooltip = this.getPersistedDisplayThumbnailTooltip();
    private boolean transferDataOfDraggedThumbnails = false;
    private final ThumbnailPanelRenderer renderer = new ThumbnailPanelRenderer(this);
    private final transient RenderedThumbnailCache renderedThumbnailCache = RenderedThumbnailCache.INSTANCE;
    private final ThumbnailsPopupMenu popupMenu = ThumbnailsPopupMenu.INSTANCE;
    private Comparator<File> fileSortComparator = FileSort.NAMES_ASCENDING.getComparator();
    private FileFilter fileFilter = AppFileFilters.INSTANCE.getAllAcceptedImageFilesFilter();
    private final List<File> files = Collections.synchronizedList(new ArrayList());
    private FileAction fileAction = FileAction.UNDEFINED;
    private OriginOfDisplayedThumbnails originOfOfDisplayedThumbnails = OriginOfDisplayedThumbnails.UNDEFINED_ORIGIN;
    private final transient ThumbnailDoubleklickController ctrlDoubleklick;
    private boolean drag;
    private boolean metaDataOverlay = this.readPersistedMetaDataOverlay();
    private volatile boolean notifySelChanged;
    private volatile boolean publishesChangedEvent;
    private volatile boolean notifyRefresh;
    private JViewport viewport;
    private static final Logger LOGGER = Logger.getLogger(ThumbnailsPanel.class.getName());
    private final Object thumbnailsChangedNotifyMonitor = new Object();
    private final XmpSidecarFileResolver xmpSidecarFileResolver = Lookup.getDefault().lookup(XmpSidecarFileResolver.class);
    private final Set<ThumbnailFlag> flagsToDisplay = EnumSet.of(ThumbnailFlag.ERROR_FILE_NOT_FOUND);

    public ThumbnailsPanel() {
        this.ctrlDoubleklick = new ThumbnailDoubleklickController(this);
        this.setDragEnabled(true);
        this.setTransferHandler(new ThumbnailsPanelTransferHandler());
        this.readProperties();
        this.renderedThumbnailCache.setRenderer(this.renderer);
        this.setBackground(COLOR_BACKGROUND_PANEL);
        this.listen();
    }

    private boolean getPersistedDisplayThumbnailTooltip() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs == null || !prefs.containsKey("UserSettings.DisplayThumbnailTooltip") ? true : prefs.getBoolean("UserSettings.DisplayThumbnailTooltip");
    }

    private void listen() {
        this.renderedThumbnailCache.addThumbnailUpdateListener(this);
        AnnotationProcessor.process(this);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        try {
            this.getDropTarget().addDropTargetListener(this.renderer);
        }
        catch (TooManyListenersException ex) {
            Logger.getLogger(ThumbnailsPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void clearSelectionAndFlags() {
        this.clearSelection();
        this.thumbnailFlagsAtIndex.clear();
    }

    public synchronized void rerender(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Illegal index: " + index);
        }
        File file = this.getFileAtIndex(index);
        if (file == null) {
            throw new IllegalArgumentException("Illegal index: " + index);
        }
        this.renderedThumbnailCache.rerender(file);
    }

    private synchronized void rerender(Collection<Integer> rerenderTargets) {
        if (rerenderTargets.size() > 700) {
            this.renderedThumbnailCache.clear();
            this.repaint();
        } else {
            for (Integer i : rerenderTargets) {
                if (!this.isIndex(i)) continue;
                this.rerender(i);
            }
        }
    }

    private synchronized void convertSelection(List<File> oldFiles, List<File> newFiles) {
        ArrayList<Integer> newSelection = new ArrayList<Integer>();
        for (int i : this.selectedThumbnailIndices) {
            File file;
            int newI;
            if (oldFiles.size() >= i || (newI = newFiles.indexOf(file = oldFiles.get(i))) < 0) continue;
            newSelection.add(newI);
        }
        this.selectedThumbnailIndices.clear();
        this.selectedThumbnailIndices.addAll(newSelection);
    }

    public synchronized void clearSelection() {
        this.clearSelectionAtIndices(new ArrayList<Integer>(this.selectedThumbnailIndices));
    }

    public synchronized void selectAll() {
        this.setSelectedAll(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSelectionAtIndices(List<Integer> indices) {
        if (!indices.isEmpty()) {
            ThumbnailsPanel thumbnailsPanel = this;
            synchronized (thumbnailsPanel) {
                this.selectedThumbnailIndices.clear();
                this.rerender(indices);
            }
            this.notifySelectionChanged();
        }
    }

    private synchronized int getFirstSelectedIndex() {
        if (this.selectedThumbnailIndices.size() > 0) {
            return this.selectedThumbnailIndices.get(0);
        }
        return -1;
    }

    private synchronized int getSelectedIndex() {
        if (this.selectedThumbnailIndices.size() == 1) {
            return this.selectedThumbnailIndices.get(0);
        }
        return -1;
    }

    public synchronized void setThumbnailWidth(int widthInPixels) {
        if (widthInPixels != this.renderer.getThumbnailWidth()) {
            float oldPosition = this.getRelativeScrollPosition();
            this.renderer.setThumbnailWidth(widthInPixels);
            this.setCountPerRow();
            this.setSize(this.getWidth(), this.getCalculatedHeight());
            this.setRelativeScrollPosition(oldPosition);
            this.repaint();
        }
    }

    private float getRelativeScrollPosition() {
        if (this.viewport != null) {
            int middle = this.viewport.getViewRect().y + this.viewport.getExtentSize().height / 2;
            return (float)middle / (float)this.getHeight();
        }
        return 0.0f;
    }

    private void setRelativeScrollPosition(float p) {
        if (this.viewport != null) {
            int newY = (int)(p * (float)this.getHeight()) - this.viewport.getExtentSize().height / 2;
            this.validateScrollPane();
            this.viewport.setViewPosition(new Point(0, Math.max(0, newY)));
        }
    }

    private synchronized void setDragEnabled(boolean enabled) {
        this.dragThumbnailsEnabled = enabled;
    }

    private synchronized int getThumbnailWidth() {
        return this.renderer.getThumbnailWidth();
    }

    public synchronized List<Integer> getSelectedIndices() {
        return new ArrayList<Integer>(this.selectedThumbnailIndices);
    }

    private synchronized void repaintAtIndex(int index) {
        this.repaint(this.getTopLeftOfTnIndex((int)index).x, this.getTopLeftOfTnIndex((int)index).y, this.renderer.getThumbnailAreaWidth(), this.renderer.getThumbnailAreaHeight());
    }

    private synchronized void repaintAtIndices(Collection<Integer> indices) {
        if (indices == null) {
            throw new NullPointerException("indices == null");
        }
        for (int index : indices) {
            this.repaintAtIndex(index);
        }
    }

    @Override
    public synchronized void thumbnailUpdated(final TypedThumbnailUpdateEvent event) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                int index = ThumbnailsPanel.this.getIndexOf(event.getSource());
                if (index >= 0) {
                    ThumbnailsPanel.this.repaintAtIndex(index);
                }
            }
        });
    }

    synchronized void setDisplayFlag(ThumbnailFlag flag, boolean display) {
        if (flag == ThumbnailFlag.ERROR_FILE_NOT_FOUND) {
            return;
        }
        if (display) {
            this.flagsToDisplay.add(flag);
        } else {
            this.flagsToDisplay.remove(flag);
        }
        this.setFlags();
        this.rerenderAll();
    }

    synchronized boolean isDisplayFlag(ThumbnailFlag flag) {
        return this.flagsToDisplay.contains(flag);
    }

    private synchronized void setFlags() {
        int count = this.files.size();
        this.thumbnailFlagsAtIndex.clear();
        for (int i = 0; i < count; ++i) {
            for (ThumbnailFlag flag : this.flagsToDisplay) {
                if (!flag.matches(this.files.get(i))) continue;
                this.addFlag(i, flag);
            }
        }
    }

    private synchronized void rerenderAll() {
        int filecount = this.files.size();
        for (int i = 0; i < filecount; ++i) {
            this.rerender(i);
        }
    }

    private synchronized void addFlag(int index, ThumbnailFlag flag) {
        Set<ThumbnailFlag> flags = this.thumbnailFlagsAtIndex.get(index);
        if (flags == null) {
            flags = EnumSet.noneOf(ThumbnailFlag.class);
            this.thumbnailFlagsAtIndex.put(index, flags);
        }
        flags.add(flag);
    }

    private synchronized Set<ThumbnailFlag> getFlagsAtIndex(int index) {
        return this.thumbnailFlagsAtIndex.get(index);
    }

    public synchronized List<ThumbnailFlag> getFlagsOfFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        Set<ThumbnailFlag> flags = this.thumbnailFlagsAtIndex.get(this.getIndexOf(file));
        return flags == null ? new ArrayList<ThumbnailFlag>(0) : new ArrayList<ThumbnailFlag>(flags);
    }

    private int getCountHorizontalLeftFromX(int x) {
        return x / (this.renderer.getThumbnailAreaWidth() + 3);
    }

    private int getCountHorizontalRightFromX(int x) {
        return this.getCountHorizontalLeftFromX(x - 1);
    }

    private int getCountVerticalAboveY(int y) {
        return y / (this.renderer.getThumbnailAreaHeight() + 3);
    }

    private boolean isThumbnailAreaInWidth(int x) {
        int startExtPadding = this.getCountHorizontalLeftFromX(x) * (this.renderer.getThumbnailAreaWidth() + 3);
        int endExtPadding = startExtPadding + 3;
        return x < startExtPadding || x > endExtPadding && endExtPadding + this.renderer.getThumbnailAreaWidth() + 3 <= this.getWidth();
    }

    private boolean isThumbnailAreaInHeight(int y) {
        int startExtPadding = this.getCountVerticalAboveY(y) * (this.renderer.getThumbnailAreaHeight() + 3);
        int endExtPadding = startExtPadding + 3;
        return y < startExtPadding || y > endExtPadding;
    }

    private boolean isThumbnailArea(int x, int y) {
        return this.isThumbnailAreaInWidth(x) && this.isThumbnailAreaInHeight(y);
    }

    public int getThumbnailIndexAtPoint(int x, int y) {
        if (this.isThumbnailArea(x, y)) {
            int tnOffset = (x - 3) / (this.renderer.getThumbnailAreaWidth() + 3);
            int firstInRow = this.getFirstPaintIndexAtHeight(y);
            return firstInRow + tnOffset;
        }
        return -1;
    }

    private synchronized int getFirstPaintIndexAtHeight(int height) {
        int rowsToStart = this.getRowCountInHeight(height);
        return rowsToStart * this.thumbnailCountPerRow;
    }

    private synchronized int getLastPaintIndexAtHeight(int height) {
        int rowsToEnd = this.getRowCountInHeight(height);
        return (rowsToEnd + 1) * this.thumbnailCountPerRow;
    }

    private int getRowCountInHeight(int height) {
        return (height - 3) / (this.renderer.getThumbnailAreaHeight() + 3);
    }

    public synchronized boolean isSelectedAtIndex(int index) {
        return this.selectedThumbnailIndices.contains(index);
    }

    public synchronized boolean isFileSelected(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        return this.selectedThumbnailIndices.contains(this.getIndexOf(file));
    }

    public synchronized int getSelectionCount() {
        return this.selectedThumbnailIndices.size();
    }

    public synchronized boolean isAFileSelected() {
        return !this.selectedThumbnailIndices.isEmpty();
    }

    public Point getTopLeftOfTnIndex(int index) {
        int rowIndex = this.getRowIndexAt(index);
        int columnIndex = this.getColumnIndexAt(index);
        int x = 3 + columnIndex * (this.renderer.getThumbnailAreaWidth() + 3);
        int y = 3 + rowIndex * (this.renderer.getThumbnailAreaHeight() + 3);
        return new Point(x, y);
    }

    public synchronized void setDrag(boolean drag) {
        this.drag = drag;
    }

    public synchronized int getImageMoveDropIndex(int x, int y) {
        int row = Math.max(0, (y - 3) / (this.renderer.getThumbnailAreaHeight() + 3));
        int col = Math.max(0, Math.min(this.getColumnCount(), (x - 3) / (this.renderer.getThumbnailAreaWidth() + 3)));
        if (row < 0 || col < 0) {
            return -1;
        }
        int index = Math.min(row * this.getColumnCount() + col, this.files.size() - 1);
        return index;
    }

    private synchronized int getColumnCount() {
        int tnWidth;
        int width = this.getWidth();
        int count = (int)((double)(width - 3) / (double)(tnWidth = this.renderer.getThumbnailAreaWidth()));
        return count > this.files.size() ? this.files.size() : count;
    }

    private void transferData(MouseEvent evt) {
        TransferHandler transferHandler;
        if (this.dragThumbnailsEnabled && this.isAFileSelected() && (transferHandler = this.getTransferHandler()) != null) {
            transferHandler.exportAsDrag(this, evt, 1);
        }
    }

    private synchronized boolean isClickInSelection(MouseEvent evt) {
        int clickIndex = this.getThumbnailIndexAtPoint(evt.getX(), evt.getY());
        return this.selectedThumbnailIndices.contains(clickIndex);
    }

    private synchronized void handleMousePressed(MouseEvent evt) {
        boolean isLeftClick = MouseEventUtil.isLeftClick(evt);
        if (isLeftClick && !this.hasFocus()) {
            this.requestFocus();
        }
        if (isLeftClick) {
            int thumbnailIndex = this.getThumbnailIndexAtPoint(evt.getX(), evt.getY());
            if (this.isIndex(thumbnailIndex)) {
                this.transferDataOfDraggedThumbnails = true;
                if (MouseEventUtil.isDoubleClick(evt)) {
                    this.doubleClickAt(thumbnailIndex);
                    this.setSelectedAtIndex(thumbnailIndex);
                } else if (evt.isControlDown()) {
                    if (!this.isSelectedAtIndex(thumbnailIndex)) {
                        this.addIndexToSelection(thumbnailIndex);
                    } else {
                        this.removeIndexFromSelection(thumbnailIndex);
                    }
                } else if (evt.isShiftDown()) {
                    this.enhanceSelectionTo(thumbnailIndex);
                } else if (this.isClickInSelection(evt)) {
                    this.isClickInSelection = thumbnailIndex;
                } else {
                    this.setSelectedAtIndex(thumbnailIndex);
                }
            } else {
                this.setSelectedAll(false);
            }
        } else if (MouseEventUtil.isPopupTrigger(evt)) {
            this.handlePopupTrigger(evt);
        }
    }

    private synchronized void handlePopupTrigger(MouseEvent evt) {
        int clickIndex = this.getThumbnailIndexAtPoint(evt.getX(), evt.getY());
        boolean isClickInSel = this.selectedThumbnailIndices.contains(clickIndex);
        if (!isClickInSel) {
            if (this.isIndex(clickIndex)) {
                this.setSelectedAtIndex(clickIndex);
            } else {
                this.clearSelection();
            }
        }
        this.showPopupMenu(evt);
    }

    private synchronized void handleMouseReleased() {
        if (this.isClickInSelection >= 0) {
            this.setSelectedAtIndex(this.isClickInSelection);
            this.isClickInSelection = -1;
        }
    }

    private synchronized void handleMouseDragged(MouseEvent evt) {
        this.isClickInSelection = -1;
        if (this.dragThumbnailsEnabled && this.transferDataOfDraggedThumbnails && this.isAFileSelected()) {
            this.transferData(evt);
            this.transferDataOfDraggedThumbnails = false;
        }
    }

    private void handleMouseMoved(MouseEvent evt) {
        if (this.dragThumbnailsEnabled) {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.showToolTip(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSelectedAll(boolean select) {
        ThumbnailsPanel thumbnailsPanel = this;
        synchronized (thumbnailsPanel) {
            HashSet<Integer> currentSelection = new HashSet<Integer>(this.selectedThumbnailIndices);
            this.selectedThumbnailIndices.clear();
            if (select) {
                for (int index = 0; index < this.files.size(); ++index) {
                    this.selectedThumbnailIndices.add(index);
                }
                this.renderedThumbnailCache.clear();
                this.repaint();
            } else {
                this.rerender(currentSelection);
            }
        }
        this.notifySelectionChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enhanceSelectionTo(int index) {
        boolean isEnhance;
        ThumbnailsPanel thumbnailsPanel = this;
        synchronized (thumbnailsPanel) {
            isEnhance = this.isAFileSelected();
            if (isEnhance) {
                HashSet<Integer> rerenderTargets = new HashSet<Integer>(this.selectedThumbnailIndices);
                int firstSelected = this.getFirstSelectedIndex();
                this.selectedThumbnailIndices.clear();
                int startIndex = index > firstSelected ? firstSelected : index;
                int endIndex = index > firstSelected ? index : firstSelected;
                for (int i = startIndex; i <= endIndex; ++i) {
                    this.selectedThumbnailIndices.add(i);
                }
                rerenderTargets.addAll(this.selectedThumbnailIndices);
                this.rerender(rerenderTargets);
                this.repaint();
            } else {
                this.setSelectedAtIndex(index);
            }
        }
        if (isEnhance) {
            this.notifySelectionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedIndices(List<Integer> indices) {
        if (indices == null) {
            throw new NullPointerException("indices == null");
        }
        ThumbnailsPanel thumbnailsPanel = this;
        synchronized (thumbnailsPanel) {
            Set<Integer> rerenderTargets = this.getValidIndicesOf(indices);
            this.selectedThumbnailIndices.clear();
            this.selectedThumbnailIndices.addAll(indices);
            if (this.selectedThumbnailIndices.size() > 0) {
                Collections.sort(this.selectedThumbnailIndices);
            }
            this.rerender(rerenderTargets);
        }
        this.notifySelectionChanged();
        this.repaint();
    }

    public synchronized void setSelectedFiles(Collection<? extends File> files) {
        ArrayList<Integer> indices = new ArrayList<Integer>(files.size());
        for (File file : files) {
            int index = this.getIndexOf(file);
            if (index < 0) continue;
            indices.add(index);
        }
        this.setSelectedIndices(indices);
    }

    private synchronized Set<Integer> getValidIndicesOf(Collection<Integer> indices) {
        HashSet<Integer> validIndices = new HashSet<Integer>(indices.size());
        if (indices.isEmpty() || this.files.isEmpty()) {
            return validIndices;
        }
        int maxIndex = this.files.size() - 1;
        for (int index : indices) {
            if (index < 0 || index > maxIndex) continue;
            validIndices.add(index);
        }
        return validIndices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSelectedAtIndex(int index) {
        ThumbnailsPanel thumbnailsPanel = this;
        synchronized (thumbnailsPanel) {
            if (!this.isIndex(index)) {
                assert (false) : "Invalid index: " + index;
                return;
            }
            HashSet<Integer> rerenderTargets = new HashSet<Integer>(this.selectedThumbnailIndices);
            this.selectedThumbnailIndices.clear();
            this.selectedThumbnailIndices.add(index);
            rerenderTargets.add(index);
            this.rerender(rerenderTargets);
        }
        this.notifySelectionChanged();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIndexToSelection(int index) {
        boolean isSelect;
        ThumbnailsPanel thumbnailsPanel = this;
        synchronized (thumbnailsPanel) {
            boolean bl = isSelect = !this.isSelectedAtIndex(index);
            if (isSelect) {
                this.selectedThumbnailIndices.add(index);
                Collections.sort(this.selectedThumbnailIndices);
                this.rerender(index);
            }
        }
        if (isSelect) {
            this.notifySelectionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeIndexFromSelection(int index) {
        boolean isRemove;
        ThumbnailsPanel thumbnailsPanel = this;
        synchronized (thumbnailsPanel) {
            isRemove = this.isSelectedAtIndex(index);
            if (isRemove) {
                this.selectedThumbnailIndices.remove((Object)index);
                this.rerender(index);
            }
        }
        if (isRemove) {
            this.notifySelectionChanged();
        }
    }

    private synchronized int getColumnIndexAt(int thumbnailIndex) {
        return thumbnailIndex > 0 && this.thumbnailCountPerRow > 0 ? thumbnailIndex % this.thumbnailCountPerRow : 0;
    }

    private synchronized int getRowIndexAt(int thumbnailIndex) {
        return this.thumbnailCountPerRow > 0 ? thumbnailIndex / this.thumbnailCountPerRow : 0;
    }

    private synchronized void handleMouseDoubleKlicked() {
        int indexSelectedThumbnail = this.getSelectedIndex();
        if (indexSelectedThumbnail >= 0) {
            this.doubleClickAt(indexSelectedThumbnail);
        }
    }

    private void forceRepaint() {
        this.revalidate();
        this.repaint();
    }

    private synchronized void prefetch(int low, int high, boolean xmp) {
        if (!this.isIndex(low)) {
            throw new IllegalArgumentException("Illegal low index: " + low);
        }
        if (!this.isIndex(high)) {
            throw new IllegalArgumentException("Illegal high index: " + high);
        }
        for (int i = low; i <= high; ++i) {
            File file = this.getFileAtIndex(i);
            assert (file != null) : "X: " + i + ", " + low + ", " + high + ".";
            this.renderedThumbnailCache.prefetch(file, this.renderer.getThumbnailWidth(), xmp);
        }
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        this.paintPanelBackground(g);
        if (this.files.size() > 0) {
            Rectangle rectClip = g.getClipBounds();
            int firstIndex = Math.min(this.files.size(), this.getFirstPaintIndexAtHeight(rectClip.y));
            int lastIndex = Math.min(this.getLastPaintIndexAtHeight(rectClip.y + rectClip.height), this.files.size());
            int firstColumn = Math.max(0, this.getCountHorizontalLeftFromX(rectClip.x));
            int lastColumn = Math.min(this.thumbnailCountPerRow - 1, this.getCountHorizontalRightFromX(rectClip.x + rectClip.width));
            for (int index = firstIndex; index < lastIndex; ++index) {
                if (index % this.thumbnailCountPerRow < firstColumn || index % this.thumbnailCountPerRow > lastColumn) continue;
                this.paintThumbnail(index, g);
            }
            this.paintPanelFocusBorder(g);
            int prefetchLowStart = Math.max(0, firstIndex - this.thumbnailCountPerRow * 5);
            int prefetchLowEnd = firstIndex - 1;
            int prefetchHighStart = lastIndex;
            int prefetchHighEnd = Math.min(this.files.size() - 1, lastIndex + this.thumbnailCountPerRow * 5);
            if (this.isIndex(prefetchHighStart) && this.isIndex(prefetchHighEnd)) {
                this.prefetch(prefetchHighStart, prefetchHighEnd, this.isMetaDataOverlay());
            }
            if (this.isIndex(prefetchLowStart) && this.isIndex(prefetchLowEnd)) {
                this.prefetch(prefetchLowStart, prefetchLowEnd, this.isMetaDataOverlay());
            }
        }
        if (this.drag) {
            this.renderer.paintImgDropMarker(g);
        }
    }

    private void paintPanelBackground(Graphics g) {
        Color oldColor = g.getColor();
        g.setColor(COLOR_BACKGROUND_PANEL);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(oldColor);
    }

    private synchronized void paintThumbnail(int index, Graphics g) {
        Point topLeft = this.getTopLeftOfTnIndex(index);
        Image im = this.renderedThumbnailCache.getThumbnail(this.getFileAtIndex(index), this.renderer.getThumbnailWidth(), this.isMetaDataOverlay());
        if (im != null) {
            g.drawImage(im, topLeft.x, topLeft.y, this.viewport);
        }
    }

    @EventSubscriber(eventClass=AppWillExitEvent.class)
    public void appWillExit(AppWillExitEvent evt) {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setInt(KEY_THUMBNAIL_WIDTH, this.getThumbnailWidth());
    }

    private String createTooltipTextForIndex(int index) {
        if (this.isIndex(index)) {
            File file = this.files.get(index);
            boolean fileExists = file.exists();
            Set<ThumbnailFlag> flags = this.getFlagsAtIndex(index);
            String flagText = flags == null ? "" : this.createFlagsDisplayName(new ArrayList<ThumbnailFlag>(flags));
            long length = fileExists ? file.length() : 0L;
            ByteSizeUnit unit = fileExists ? ByteSizeUnit.unit(length) : ByteSizeUnit.BYTE;
            long unitLength = fileExists ? length / unit.bytes() : 0L;
            String unitString = unit.toString();
            String fileDate = file.exists() ? TOOLTIP_FILE_DATE_FORMAT.format(new Date(file.lastModified())) : "?";
            return Bundle.getString(ThumbnailsPanel.class, "ThumbnailsPanel.TooltipText", file.getAbsolutePath(), unitLength, unitString, fileDate, this.getSidecarPathNameOfFile(file), flagText);
        }
        return "";
    }

    private String createFlagsDisplayName(List<ThumbnailFlag> flags) {
        Collections.sort(flags, PositionProviderAscendingComparator.INSTANCE);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < flags.size(); ++i) {
            sb.append(i == 0 ? "" : Character.valueOf(',')).append(flags.get(i).getDisplayName());
        }
        return sb.toString();
    }

    private String getSidecarPathNameOfFile(File file) {
        File sidecarFile = this.xmpSidecarFileResolver.getXmpSidecarFileOrNullIfNotExists(file);
        return sidecarFile == null ? "-" : sidecarFile.getAbsolutePath();
    }

    public synchronized OriginOfDisplayedThumbnails getOriginOfDisplayedThumbnails() {
        return this.originOfOfDisplayedThumbnails;
    }

    public synchronized FileAction getFileAction() {
        return this.fileAction;
    }

    public synchronized int getFileCount() {
        return this.files.size();
    }

    public synchronized boolean hasFiles() {
        return !this.files.isEmpty();
    }

    public synchronized List<File> getFiles() {
        return Collections.unmodifiableList(this.files);
    }

    private synchronized List<File> getFilesAtIndices(List<Integer> indices) {
        ArrayList<File> f = new ArrayList<File>();
        for (Integer index : indices) {
            if (!this.isIndex(index)) continue;
            f.add(this.files.get(index));
        }
        return f;
    }

    private synchronized List<Integer> getIndicesOfFiles(List<File> files, boolean onlyIfExists) {
        ArrayList<Integer> indices = new ArrayList<Integer>(files.size());
        for (File file : files) {
            int index = files.indexOf(file);
            if (onlyIfExists && (!onlyIfExists || index < 0)) continue;
            indices.add(index);
        }
        return indices;
    }

    public synchronized List<File> getSelectedFiles() {
        return this.getFilesAtIndices(this.getSelectedIndices());
    }

    public synchronized boolean isIndex(int index) {
        return index >= 0 && index < this.files.size();
    }

    public synchronized void moveSelectedToIndex(int index) {
        if (!this.isIndex(index)) {
            return;
        }
        List<Integer> selectedIndices = this.getSelectedIndices();
        if (selectedIndices.size() <= 0) {
            return;
        }
        Collections.sort(selectedIndices);
        if (selectedIndices.get(0) == index) {
            return;
        }
        List<File> selFiles = this.getFilesAtIndices(selectedIndices);
        ArrayList<File> filesWithoutMoved = new ArrayList<File>(this.files);
        int fileCount = filesWithoutMoved.size();
        filesWithoutMoved.removeAll(selFiles);
        ArrayList newOrderedFiles = new ArrayList(fileCount);
        newOrderedFiles.addAll(filesWithoutMoved.subList(0, index));
        newOrderedFiles.addAll(selFiles);
        newOrderedFiles.addAll(filesWithoutMoved.subList(index, filesWithoutMoved.size()));
        this.files.clear();
        this.files.addAll(newOrderedFiles);
        this.clearSelectionAtIndices(this.getIndicesOfFiles(selFiles, true));
        this.repaint();
    }

    private void notifyRefreshListeners(ThumbnailsPanelRefreshEvent evt) {
        if (!this.notifyRefresh) {
            this.notifyRefresh = true;
            LOGGER.log(Level.INFO, "Refreshing thumbnails view");
            EventBus.publish(evt);
            this.notifyRefresh = false;
        }
    }

    private void readProperties() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        if (prefs == null) {
            return;
        }
        int tnWidth = prefs.getInt(KEY_THUMBNAIL_WIDTH);
        if (tnWidth > 0) {
            this.setThumbnailWidth(tnWidth);
        }
    }

    public void refresh() {
        ThumbnailsPanelRefreshEvent evt = new ThumbnailsPanelRefreshEvent(this, this.originOfOfDisplayedThumbnails, this.getViewPosition());
        evt.setSelectedThumbnailIndices(new ArrayList<Integer>(this.selectedThumbnailIndices));
        this.notifyRefreshListeners(evt);
    }

    public void applyThumbnailsPanelSettings(ThumbnailsPanelSettings settings) {
        if (settings == null) {
            return;
        }
        this.setViewPosition(settings.getViewPosition());
        if (settings.hasSelectedFiles()) {
            this.setSelectedFiles(settings.getSelectedFiles());
        } else if (settings.hasSelectedIndices()) {
            this.setSelectedIndices(settings.getSelectedIndices());
        }
    }

    private void setViewPosition(Point pos) {
        if (this.viewport != null) {
            this.validateScrollPane();
            this.viewport.setViewPosition(pos);
        }
    }

    private void validateScrollPane() {
        MainWindowThumbnailsComponent component = Lookup.getDefault().lookup(MainWindowThumbnailsComponent.class);
        component.validateViewportPosition();
    }

    public Point getViewPosition() {
        JViewport vp = this.getViewport();
        return vp == null ? new Point(0, 0) : vp.getViewPosition();
    }

    public synchronized boolean containsFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        return this.files.contains(file);
    }

    public synchronized void removeFiles(Collection<? extends File> filesToRemove) {
        if (filesToRemove == null) {
            throw new NullPointerException("filesToRemove == null");
        }
        ArrayList<File> oldFiles = new ArrayList<File>(this.files);
        List<Integer> selIndicesToRemove = this.getSelectedIndicesOfFiles(filesToRemove);
        if (this.files.removeAll(filesToRemove)) {
            this.selectedThumbnailIndices.removeAll(selIndicesToRemove);
            this.convertSelection(oldFiles, this.files);
            Point viewPos = this.getViewPosition();
            this.setFiles(this.files, this.originOfOfDisplayedThumbnails);
            this.setViewPosition(viewPos);
            this.renderedThumbnailCache.remove(filesToRemove);
            this.refresh();
        }
    }

    private synchronized List<Integer> getSelectedIndicesOfFiles(Collection<? extends File> files) {
        ArrayList<Integer> selIndices = new ArrayList<Integer>(files.size());
        for (File file : files) {
            int index = this.getIndexOf(file);
            if (!this.selectedThumbnailIndices.contains(index)) continue;
            selIndices.add(index);
        }
        return selIndices;
    }

    public synchronized void renameFile(File fromFile, File toFile) {
        if (fromFile == null) {
            throw new NullPointerException("oldFile == null");
        }
        if (toFile == null) {
            throw new NullPointerException("newFile == null");
        }
        int index = this.files.indexOf(fromFile);
        if (index >= 0) {
            this.files.set(index, toFile);
        }
    }

    public synchronized void repaintFile(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        int index = this.getIndexOf(file);
        if (index > 0) {
            this.repaintAtIndices(Collections.singleton(index));
        }
    }

    public synchronized void setFileAction(FileAction fileAction) {
        if (fileAction == null) {
            throw new NullPointerException("fileAction == null");
        }
        this.fileAction = fileAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFiles(Collection<? extends File> files, OriginOfDisplayedThumbnails originOfOfDisplayedThumbnails) {
        if (files == null) {
            throw new NullPointerException("files == null");
        }
        if (originOfOfDisplayedThumbnails == null) {
            throw new NullPointerException("originOfOfDisplayedThumbnails == null");
        }
        ThumbnailsPanel thumbnailsPanel = this;
        synchronized (thumbnailsPanel) {
            List<File> filteredFiles;
            Logger.getLogger(ThumbnailsPanel.class.getName()).log(Level.FINE, "{0} new files to display", files.size());
            this.clearSelectionAndFlags();
            new WarnOnEqualBasenamesTask(files).start();
            this.originOfOfDisplayedThumbnails = originOfOfDisplayedThumbnails;
            List<File> list = filteredFiles = originOfOfDisplayedThumbnails.isFilterable() ? FileUtil.filterFiles(files, this.fileFilter) : new ArrayList<File>(files);
            if (originOfOfDisplayedThumbnails.isSortable()) {
                Collections.sort(filteredFiles, this.fileSortComparator);
            }
            this.files.clear();
            this.files.addAll(filteredFiles);
            this.scrollToTop();
            this.setFlags();
        }
        this.notifyThumbnailsChanged();
        this.forceRepaint();
    }

    public synchronized boolean isEmpty() {
        return this.files.isEmpty();
    }

    synchronized void setFileSortComparator(Comparator<File> comparator) {
        boolean comparatorChanged;
        if (comparator == null) {
            throw new NullPointerException("comparator == null");
        }
        boolean bl = comparatorChanged = !ObjectUtil.equals(comparator, this.fileSortComparator);
        if (comparatorChanged) {
            LOGGER.log(Level.FINEST, "Changing sort order to {0}", this.fileSortComparator);
            this.fileSortComparator = comparator;
            if (this.originOfOfDisplayedThumbnails.isSortable() && !this.isEmpty()) {
                this.setFiles(this.getFiles(), this.originOfOfDisplayedThumbnails);
            }
        }
    }

    synchronized void setFileFilter(FileFilter filter) {
        boolean filterChanged;
        if (filter == null) {
            throw new NullPointerException("filter == null");
        }
        boolean bl = filterChanged = !ObjectUtil.equals(this.fileFilter, filter);
        if (filterChanged) {
            LOGGER.log(Level.FINEST, "Changing file filter to {0}", filter);
            this.fileFilter = filter;
            if (this.originOfOfDisplayedThumbnails.isFilterable()) {
                this.refresh();
            }
        }
    }

    synchronized void sort() {
        if (this.files.isEmpty()) {
            return;
        }
        if (this.originOfOfDisplayedThumbnails.isSortable()) {
            List<File> selFiles = this.getSelectedFiles();
            this.setFiles(new ArrayList<File>(this.files), this.originOfOfDisplayedThumbnails);
            this.setSelectedIndices(this.getIndicesOfFiles(selFiles, true));
        }
    }

    private void paintPanelFocusBorder(Graphics g) {
        if (this.hasFocus()) {
            g.setColor(Color.white);
            int width = this.getWidth();
            int height = this.getHeight();
            g.drawRect(1, 1, width - 2, height - 2);
        }
    }

    private synchronized int getRowCount() {
        double count = (double)this.files.size() / (double)this.thumbnailCountPerRow;
        return this.files.size() > this.thumbnailCountPerRow ? (int)(MathUtil.isInteger(count) ? count : count + 1.0) : (this.files.isEmpty() ? 0 : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySelectionChanged() {
        Object object = this.thumbnailsChangedNotifyMonitor;
        synchronized (object) {
            if (!this.notifySelChanged) {
                this.notifySelChanged = true;
                EventBus.publish(new ThumbnailsSelectionChangedEvent(this, this.getSelectedFiles(), this.selectedThumbnailIndices));
                this.notifySelChanged = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyThumbnailsChanged() {
        Object object = this.thumbnailsChangedNotifyMonitor;
        synchronized (object) {
            if (!this.publishesChangedEvent) {
                this.publishesChangedEvent = true;
                EventBus.publish(new ThumbnailsChangedEvent(this, this.originOfOfDisplayedThumbnails, this.files));
                this.publishesChangedEvent = false;
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Container parent = this.getParent();
        int width = parent instanceof JViewport ? parent.getWidth() : this.getWidth();
        int heigth = this.getCalculatedHeight();
        return new Dimension(width, heigth);
    }

    private int getCalculatedHeight() {
        return 3 + this.getRowCount() * (this.renderer.getThumbnailAreaHeight() + 3);
    }

    @Override
    public void componentResized(ComponentEvent evt) {
        this.setCountPerRow();
    }

    private synchronized void setCountPerRow() {
        int tnAreaWidth;
        int width = this.getWidth();
        double count = (double)(width - 3) / (double)((tnAreaWidth = this.renderer.getThumbnailAreaWidth()) + 3);
        this.thumbnailCountPerRow = count >= 1.0 ? (int)count : 1;
    }

    @Override
    public void componentMoved(ComponentEvent evt) {
    }

    @Override
    public void componentShown(ComponentEvent evt) {
    }

    @Override
    public void componentHidden(ComponentEvent evt) {
    }

    private synchronized void setSelectedUp() {
        int indexSelectedThumbnail = this.getSelectedIndex();
        int indexToSelect = indexSelectedThumbnail - this.thumbnailCountPerRow;
        if (indexSelectedThumbnail >= 0 && this.isIndex(indexToSelect)) {
            this.setSelectedAtIndex(indexToSelect);
        }
    }

    private synchronized void setSelectedDown() {
        int indexSelectedThumbnail = this.getSelectedIndex();
        int indexToSelect = indexSelectedThumbnail + this.thumbnailCountPerRow;
        if (indexSelectedThumbnail >= 0 && this.isIndex(indexToSelect)) {
            this.setSelectedAtIndex(indexToSelect);
        }
    }

    private synchronized void setSelectedNext() {
        int indexSelectedThumbnail = this.getSelectedIndex();
        int indexToSelect = (indexSelectedThumbnail + 1) % this.files.size();
        if (indexSelectedThumbnail >= 0 && this.isIndex(indexToSelect)) {
            if (indexToSelect == 0) {
                this.scrollToTop();
            }
            this.setSelectedAtIndex(indexToSelect);
        }
    }

    private synchronized void setSelectedPrevious() {
        int indexSelectedThumbnail = this.getSelectedIndex();
        int indexToSelect = (indexSelectedThumbnail - 1) % this.files.size();
        if (indexToSelect < 0) {
            indexToSelect = this.files.size() - 1;
        }
        if (indexSelectedThumbnail >= 0 && this.isIndex(indexToSelect)) {
            if (indexToSelect >= this.files.size() - 1) {
                this.scrollToBottom();
            }
            this.setSelectedAtIndex(indexToSelect);
        }
    }

    public synchronized void setViewport(JViewport viewport) {
        if (viewport == null) {
            throw new NullPointerException("viewport == null");
        }
        this.viewport = viewport;
    }

    private synchronized JViewport getViewport() {
        return this.viewport;
    }

    public void scrollToTop() {
        this.setViewPosition(new Point(0, 0));
    }

    private void scrollToBottom() {
        this.setViewPosition(new Point(0, this.getHeight()));
    }

    private void checkScrollUp() {
        int viewPosBottom;
        int tnHeight;
        int topSel;
        if (this.viewport != null && this.getSelectedIndex() >= 0 && (topSel = this.getTopLeftOfTnIndex((int)this.getSelectedIndex()).y - (tnHeight = this.renderer.getThumbnailAreaHeight())) < (viewPosBottom = this.viewport.getViewPosition().y)) {
            this.scrollOneImageUp();
        }
    }

    private void checkScrollDown() {
        int viewPosBottom;
        int tnHeight;
        int bottomSel;
        if (this.viewport != null && this.getSelectedIndex() >= 0 && (bottomSel = this.getTopLeftOfTnIndex((int)this.getSelectedIndex()).y + (tnHeight = this.renderer.getThumbnailAreaHeight())) > (viewPosBottom = this.viewport.getViewPosition().y + this.viewport.getHeight())) {
            this.scrollOneImageDown();
        }
    }

    private void scrollOneImageUp() {
        if (this.viewport != null) {
            Point p = this.viewport.getViewPosition();
            int tnHeight = this.renderer.getThumbnailAreaHeight();
            int y = p.y - tnHeight >= 0 ? p.y - tnHeight : 0;
            this.validateScrollPane();
            this.viewport.setViewPosition(new Point(0, y));
        }
    }

    private void scrollOneImageDown() {
        if (this.viewport != null) {
            Point p = this.viewport.getViewPosition();
            this.validateScrollPane();
            this.viewport.setViewPosition(new Point(0, p.y + this.renderer.getThumbnailAreaHeight()));
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.handleMousePressed(evt);
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.handleMouseReleased();
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.handleMouseMoved(evt);
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        this.handleMouseDragged(evt);
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        if (keyCode == 116) {
            this.refresh();
        } else if (keyCode == 39) {
            this.setSelectedNext();
            this.checkScrollDown();
        } else if (keyCode == 37) {
            this.setSelectedPrevious();
            this.checkScrollUp();
        } else if (keyCode == 38) {
            this.setSelectedUp();
            this.checkScrollUp();
        } else if (keyCode == 40) {
            this.setSelectedDown();
            this.checkScrollDown();
        } else if (keyCode == 10) {
            this.handleMouseDoubleKlicked();
        } else if ((evt.getModifiers() & 2) == 2 && keyCode == 65) {
            this.setSelectedAll(true);
        } else if (keyCode == 36) {
            this.clearSelection();
            this.scrollToTop();
        } else if (keyCode == 35) {
            this.clearSelection();
            this.scrollToBottom();
        } else if (keyCode == 34 || keyCode == 33) {
            this.clearSelection();
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    synchronized boolean isMetaDataOverlay() {
        return this.metaDataOverlay;
    }

    synchronized void setMetaDataOverlay(boolean metaDataOverlay) {
        this.metaDataOverlay = metaDataOverlay;
        this.persistMetaDataOverlay();
        this.repaint();
    }

    public synchronized int getIndexOf(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        return this.files.indexOf(file);
    }

    public synchronized File getFileAtIndex(int index) {
        return this.isIndex(index) ? this.files.get(index) : null;
    }

    private void doubleClickAt(int index) {
        this.ctrlDoubleklick.doubleClickAtIndex(index);
    }

    private void showPopupMenu(MouseEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        this.popupMenu.show(this, evt.getX(), evt.getY());
    }

    private void showToolTip(MouseEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        if (!this.isDisplayThumbnailTooltip) {
            this.setToolTipText(null);
            return;
        }
        int index = this.getThumbnailIndexAtPoint(evt.getX(), evt.getY());
        String tooltipText = this.createTooltipTextForIndex(index);
        this.setToolTipText(tooltipText);
    }

    @EventSubscriber(eventClass=UserDefinedFileFilterUpdatedEvent.class)
    public synchronized void userDefinedFilterUpdated(UserDefinedFileFilterUpdatedEvent evt) {
        this.updateUserDefinedFileFilter(evt.getFilter());
    }

    private void updateUserDefinedFileFilter(UserDefinedFileFilter userDefinedFileFilter) {
        boolean fileFilterIsRegex = this.fileFilter instanceof UserDefinedFileFilter.RegexFileFilter;
        UserDefinedFileFilter.RegexFileFilter updatedFilter = userDefinedFileFilter.getFileFilter();
        if (fileFilterIsRegex && userDefinedFileFilter.filtersEquals(updatedFilter, (UserDefinedFileFilter.RegexFileFilter)this.fileFilter)) {
            this.fileFilter = userDefinedFileFilter.getFileFilter();
            this.refresh();
        }
    }

    private synchronized void removeFilesNotAcceptedByFileFilter(File file) {
        if (!this.fileFilter.accept(file) && this.files.contains(file)) {
            this.removeFiles(Collections.singleton(file));
        }
    }

    @EventSubscriber(eventClass=ImageFileInsertedEvent.class)
    public void imageFileInserted(ImageFileInsertedEvent evt) {
        this.removeFilesNotAcceptedByFileFilter(evt.getImageFile());
    }

    @EventSubscriber(eventClass=ImageFileMovedEvent.class)
    public void imageFileRenamed(ImageFileMovedEvent evt) {
        this.removeFilesNotAcceptedByFileFilter(evt.getOldImageFile());
        this.removeFilesNotAcceptedByFileFilter(evt.getNewImageFile());
    }

    @EventSubscriber(eventClass=ImageFileDeletedEvent.class)
    public void imageFileDeleted(ImageFileDeletedEvent evt) {
        this.removeFilesNotAcceptedByFileFilter(evt.getImageFile());
    }

    @EventSubscriber(eventClass=XmpInsertedEvent.class)
    public void xmpInserted(XmpInsertedEvent evt) {
        this.removeFilesNotAcceptedByFileFilter(evt.getImageFile());
    }

    @EventSubscriber(eventClass=XmpUpdatedEvent.class)
    public void xmpUpdated(XmpUpdatedEvent evt) {
        this.removeFilesNotAcceptedByFileFilter(evt.getImageFile());
    }

    @EventSubscriber(eventClass=XmpDeletedEvent.class)
    public void xmpDeleted(XmpDeletedEvent evt) {
        this.removeFilesNotAcceptedByFileFilter(evt.getImageFile());
    }

    @EventSubscriber(eventClass=PreferencesChangedEvent.class)
    public void preferencesChanged(PreferencesChangedEvent evt) {
        if ("UserSettings.DisplayThumbnailTooltip".equals(evt.getKey())) {
            boolean displayThumbnailTooltip;
            this.isDisplayThumbnailTooltip = displayThumbnailTooltip = ((Boolean)evt.getNewValue()).booleanValue();
            if (!displayThumbnailTooltip) {
                this.setToolTipText(null);
            }
        }
    }

    private boolean readPersistedMetaDataOverlay() {
        Preferences preferences = Lookup.getDefault().lookup(Preferences.class);
        if (preferences != null && preferences.containsKey(KEY_SHOW_METADATA_OVERLAY)) {
            return preferences.getBoolean(KEY_SHOW_METADATA_OVERLAY);
        }
        return false;
    }

    private void persistMetaDataOverlay() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setBoolean(KEY_SHOW_METADATA_OVERLAY, this.metaDataOverlay);
    }

    @Override
    public boolean requestFocusInWindow() {
        boolean requested = super.requestFocusInWindow();
        this.repaint();
        return requested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventSubscriber(eventClass=DirectoryRenamedEvent.class)
    public void directoryRenamed(DirectoryRenamedEvent evt) {
        if (this.originOfOfDisplayedThumbnails.isInSameFileSystemDirectory() && !this.isEmpty()) {
            ThumbnailsPanel thumbnailsPanel = this;
            synchronized (thumbnailsPanel) {
                File thisDirectory = this.files.get(0).getParentFile();
                File oldDirectory = evt.getOldName();
                File newDirectory = evt.getNewName();
                if (!ObjectUtil.equals(thisDirectory, oldDirectory) || newDirectory == null) {
                    return;
                }
                ArrayList<File> newFiles = new ArrayList<File>(this.files.size());
                String newDirectoryPath = newDirectory.getAbsolutePath();
                for (File file : this.files) {
                    File newFile = new File(newDirectoryPath + File.separator + file.getName());
                    newFiles.add(newFile);
                }
                this.setFiles(newFiles, this.originOfOfDisplayedThumbnails);
            }
        }
    }
}

