/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.windows.StatusLineElementProvider;
import org.jphototagger.domain.thumbnails.event.ThumbnailZoomChangedEvent;
import org.jphototagger.domain.thumbnails.event.ThumbnailsChangedEvent;
import org.jphototagger.domain.thumbnails.event.ThumbnailsSelectionChangedEvent;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public class ThumbnailsInfoPanel
extends JPanel
implements StatusLineElementProvider {
    private static final long serialVersionUID = 1L;
    private int thumbnailZoom;
    private int thumbnailCount;
    private int selectionCount;
    private JLabel thumbnailInfoLabel;

    public ThumbnailsInfoPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.initThumbnailZoom();
        this.listen();
    }

    private void initThumbnailZoom() {
        Preferences preferences = Lookup.getDefault().lookup(Preferences.class);
        Integer value = preferences.getInt("org.jphototagger.program.controller.thumbnail.ControllerSliderThumbnailSize.SliderValue");
        this.thumbnailZoom = value.equals(Integer.MIN_VALUE) ? 100 : value;
    }

    private void listen() {
        AnnotationProcessor.process(this);
    }

    @EventSubscriber(eventClass=ThumbnailsSelectionChangedEvent.class)
    public void thumbnailsSelectionChanged(ThumbnailsSelectionChangedEvent evt) {
        this.selectionCount = evt.getSelectionCount();
        this.setCount();
    }

    @EventSubscriber(eventClass=ThumbnailsChangedEvent.class)
    public void thumbnailsChanged(ThumbnailsChangedEvent evt) {
        this.setCount();
    }

    @EventSubscriber(eventClass=ThumbnailZoomChangedEvent.class)
    public void thumbnailZoomChanged(ThumbnailZoomChangedEvent evt) {
        this.thumbnailZoom = evt.getZoomValue();
        this.setLabel();
    }

    private void setCount() {
        this.thumbnailCount = GUI.getThumbnailsPanel().getFileCount();
        this.setLabel();
    }

    private void setLabel() {
        String info = Bundle.getString(ThumbnailsInfoPanel.class, "ThumbnailsInfoPanel.Text", this.thumbnailCount, this.selectionCount, this.thumbnailZoom);
        this.thumbnailInfoLabel.setText(info);
        this.thumbnailInfoLabel.setToolTipText(info);
    }

    @Override
    public Component getStatusLineElement() {
        return this;
    }

    @Override
    public int getPosition() {
        return 0;
    }

    private void initComponents() {
        this.thumbnailInfoLabel = new JLabel();
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.thumbnailInfoLabel.setHorizontalAlignment(2);
        this.thumbnailInfoLabel.setName("thumbnailInfoLabel");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.thumbnailInfoLabel, gridBagConstraints);
    }
}

