/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.Comparator;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesChangedEvent;
import org.jphototagger.api.windows.WaitDisplayer;
import org.jphototagger.domain.filefilter.UserDefinedFileFilter;
import org.jphototagger.domain.thumbnails.ThumbnailsPanelBottomComponentProvider;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.swing.ExpandCollapseComponentPanel;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.program.module.thumbnails.FileFiltersComboBoxModel;
import org.jphototagger.program.module.thumbnails.FileFiltersListCellRenderer;
import org.jphototagger.program.module.thumbnails.ThumbnailsPanel;
import org.jphototagger.program.module.thumbnails.ThumbnailsSortComboBoxModel;
import org.openide.util.Lookup;

public class ThumbnailsAreaPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String KEY_THUMBNAIL_PANEL_VIEWPORT_VIEW_POSITION = "org.jphototagger.program.view.panels.controller.ViewportViewPosition";
    private final FileFiltersComboBoxModel fileFiltersComboBoxModel = new FileFiltersComboBoxModel();
    private final ThumbnailsSortComboBoxModel thumbnailsSortComboBoxModel = new ThumbnailsSortComboBoxModel();
    private final Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
    private ExpandCollapseComponentPanel expandCollapseBottomComponentsPanel;
    private boolean bottomComponentsPanelAdded;
    private final ItemListener fileSortChangedListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                this.persistSortOrder();
                WaitDisplayer waitDisplayer = Lookup.getDefault().lookup(WaitDisplayer.class);
                waitDisplayer.show();
                ThumbnailsAreaPanel.this.thumbnailsPanel.setFileSortComparator(ThumbnailsAreaPanel.this.getFileSortComparator());
                waitDisplayer.hide();
            }
        }

        private void persistSortOrder() {
            ThumbnailsAreaPanel.this.prefs.setInt("ThumbnailsSortComboBoxModel.SelIndex", ThumbnailsAreaPanel.this.comboBoxFileSort.getSelectedIndex());
        }
    };
    private final ItemListener fileFilterChangedListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ThumbnailsAreaPanel.this.setFileFilter(e.getItem());
            }
        }
    };
    private final ListDataListener fileFilterListDataListener = new ListDataListener(){

        @Override
        public void contentsChanged(ListDataEvent e) {
            Object selectedItem;
            int index1;
            int index0 = e.getIndex0();
            if (index0 != (index1 = e.getIndex1()) || index0 < 0) {
                return;
            }
            int selectedIndex = ThumbnailsAreaPanel.this.comboBoxFileFilters.getSelectedIndex();
            if (selectedIndex == index0 && (selectedItem = ThumbnailsAreaPanel.this.comboBoxFileFilters.getSelectedItem()) != null) {
                ThumbnailsAreaPanel.this.setFileFilter(selectedItem);
            }
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }
    };
    private JComboBox<Object> comboBoxFileFilters;
    private JComboBox<Object> comboBoxFileSort;
    private JLabel labelFileFilters;
    private JLabel labelFileSort;
    private JLabel labelInfo;
    private JPanel panelBottomComponents;
    private JPanel panelDisplayedThumbnailFilters;
    private ThumbnailsPanel thumbnailsPanel;
    private JScrollPane thumbnailsPanelScrollPane;

    public ThumbnailsAreaPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.createBottomPanel();
        this.thumbnailsPanelScrollPane.getVerticalScrollBar().setUnitIncrement(30);
        this.comboBoxFileSort.addItemListener(this.fileSortChangedListener);
        this.comboBoxFileFilters.addItemListener(this.fileFilterChangedListener);
        this.fileFiltersComboBoxModel.addListDataListener(this.fileFilterListDataListener);
        this.thumbnailsPanel.setViewport(this.thumbnailsPanelScrollPane.getViewport());
        MnemonicUtil.setMnemonics(this);
        this.fileFiltersComboBoxModel.selectPersistedItem();
        this.thumbnailsSortComboBoxModel.selectPersistedItem();
        this.thumbnailsPanel.setFileSortComparator(this.getFileSortComparator());
        this.initSetFileFilter(this.comboBoxFileFilters.getSelectedItem());
        AnnotationProcessor.process(this);
    }

    private void initSetFileFilter(Object item) {
        if (item instanceof FileFilter) {
            this.thumbnailsPanel.setFileFilter((FileFilter)item);
        } else if (item instanceof UserDefinedFileFilter) {
            this.thumbnailsPanel.setFileFilter(((UserDefinedFileFilter)item).getFileFilter());
        }
    }

    private void createBottomPanel() {
        boolean isAdd;
        this.lookupAndAddBottomComponents();
        this.createExpandCollapseBottomComponentsPanel();
        boolean bl = isAdd = this.prefs == null || !this.prefs.containsKey("UserSettings.DisplayThumbnailsBottomPanel") || this.prefs.containsKey("UserSettings.DisplayThumbnailsBottomPanel") && this.prefs.getBoolean("UserSettings.DisplayThumbnailsBottomPanel");
        if (isAdd) {
            this.addBottomComponentsPanel();
        }
    }

    private Comparator<File> getFileSortComparator() {
        ThumbnailsSortComboBoxModel.FileSorter fileSorter = (ThumbnailsSortComboBoxModel.FileSorter)this.comboBoxFileSort.getSelectedItem();
        return fileSorter.getComparator();
    }

    private void setFileFilter(Object item) {
        WaitDisplayer waitDisplayer = Lookup.getDefault().lookup(WaitDisplayer.class);
        waitDisplayer.show();
        if (item instanceof FileFilter) {
            this.thumbnailsPanel.setFileFilter((FileFilter)item);
        } else if (item instanceof UserDefinedFileFilter) {
            this.thumbnailsPanel.setFileFilter(((UserDefinedFileFilter)item).getFileFilter());
        }
        this.persistFileFilter();
        waitDisplayer.hide();
    }

    private void persistFileFilter() {
        this.prefs.setInt("ComboBoxModelFileFilters.SelIndex", this.comboBoxFileFilters.getSelectedIndex());
    }

    ThumbnailsPanel getThumbnailsPanel() {
        return this.thumbnailsPanel;
    }

    void persistViewportPosition() {
        this.prefs.setScrollPane(KEY_THUMBNAIL_PANEL_VIEWPORT_VIEW_POSITION, this.thumbnailsPanelScrollPane);
    }

    void restoreViewportPosition() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (Throwable t) {
                    Logger.getLogger(ThumbnailsAreaPanel.class.getName()).log(Level.SEVERE, null, t);
                }
                EventQueueUtil.invokeInDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        Preferences preferences = Lookup.getDefault().lookup(Preferences.class);
                        preferences.applyScrollPaneSettings(ThumbnailsAreaPanel.KEY_THUMBNAIL_PANEL_VIEWPORT_VIEW_POSITION, ThumbnailsAreaPanel.this.thumbnailsPanelScrollPane);
                    }
                });
            }
        }, "JPhotoTagger: Restoring viewport position").start();
    }

    void validateViewportPosition() {
        this.thumbnailsPanelScrollPane.validate();
    }

    private void removeBottomComponentsPanel() {
        if (this.bottomComponentsPanelAdded) {
            this.remove(this.expandCollapseBottomComponentsPanel);
            this.bottomComponentsPanelAdded = false;
        }
    }

    private void addBottomComponentsPanel() {
        if (!this.bottomComponentsPanelAdded) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridwidth = 0;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            this.add((Component)this.expandCollapseBottomComponentsPanel, gbc);
            this.expandCollapseBottomComponentsPanel.readExpandedState();
            this.bottomComponentsPanelAdded = true;
        }
    }

    private void lookupAndAddBottomComponents() {
        Collection<ThumbnailsPanelBottomComponentProvider> providers = Lookup.getDefault().lookupAll(ThumbnailsPanelBottomComponentProvider.class);
        for (ThumbnailsPanelBottomComponentProvider provider : providers) {
            Component component = provider.getComponent();
            GridBagConstraints constraints = this.createBottomComponentConstraints();
            this.panelBottomComponents.add(component, constraints);
        }
    }

    private void createExpandCollapseBottomComponentsPanel() {
        this.expandCollapseBottomComponentsPanel = new ExpandCollapseComponentPanel(this.panelBottomComponents);
        this.expandCollapseBottomComponentsPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(95, 95, 95)));
    }

    private GridBagConstraints createBottomComponentConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 5, 5, 5);
        return gbc;
    }

    @EventSubscriber(eventClass=PreferencesChangedEvent.class)
    public void preferencesChanged(PreferencesChangedEvent evt) {
        if ("UserSettings.DisplayThumbnailsBottomPanel".equals(evt.getKey())) {
            Boolean display = (Boolean)evt.getNewValue();
            if (display.booleanValue()) {
                this.addBottomComponentsPanel();
            } else {
                this.removeBottomComponentsPanel();
            }
            ComponentUtil.forceRepaint(this);
        }
    }

    private void initComponents() {
        this.panelBottomComponents = new JPanel();
        this.labelInfo = new JLabel();
        this.panelDisplayedThumbnailFilters = new JPanel();
        this.labelFileFilters = new JLabel();
        this.comboBoxFileFilters = new JComboBox();
        this.labelFileSort = new JLabel();
        this.comboBoxFileSort = new JComboBox();
        this.thumbnailsPanelScrollPane = new JScrollPane();
        this.thumbnailsPanel = new ThumbnailsPanel();
        this.panelBottomComponents.setName("panelBottomComponents");
        this.panelBottomComponents.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/thumbnails/Bundle");
        this.labelInfo.setText(bundle.getString("ThumbnailsAreaPanel.labelInfo.text"));
        this.labelInfo.setName("labelInfo");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelBottomComponents.add((Component)this.labelInfo, gridBagConstraints);
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.panelDisplayedThumbnailFilters.setName("panelDisplayedThumbnailFilters");
        this.panelDisplayedThumbnailFilters.setLayout(new GridBagLayout());
        this.labelFileFilters.setText(bundle.getString("ThumbnailsAreaPanel.labelFileFilters.text"));
        this.labelFileFilters.setName("labelFileFilters");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelDisplayedThumbnailFilters.add((Component)this.labelFileFilters, gridBagConstraints);
        this.comboBoxFileFilters.setModel(this.fileFiltersComboBoxModel);
        this.comboBoxFileFilters.setName("comboBoxFileFilters");
        this.comboBoxFileFilters.setRenderer(new FileFiltersListCellRenderer());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelDisplayedThumbnailFilters.add(this.comboBoxFileFilters, gridBagConstraints);
        this.labelFileSort.setText(bundle.getString("ThumbnailsAreaPanel.labelFileSort.text"));
        this.labelFileSort.setName("labelFileSort");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.panelDisplayedThumbnailFilters.add((Component)this.labelFileSort, gridBagConstraints);
        this.comboBoxFileSort.setModel(this.thumbnailsSortComboBoxModel);
        this.comboBoxFileSort.setName("comboBoxFileSort");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelDisplayedThumbnailFilters.add(this.comboBoxFileSort, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.panelDisplayedThumbnailFilters, gridBagConstraints);
        this.thumbnailsPanelScrollPane.setName("thumbnailsPanelScrollPane");
        this.thumbnailsPanel.setName("thumbnailsPanel");
        GroupLayout thumbnailsPanelLayout = new GroupLayout(this.thumbnailsPanel);
        this.thumbnailsPanel.setLayout(thumbnailsPanelLayout);
        thumbnailsPanelLayout.setHorizontalGroup(thumbnailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 538, Short.MAX_VALUE));
        thumbnailsPanelLayout.setVerticalGroup(thumbnailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 268, Short.MAX_VALUE));
        this.thumbnailsPanelScrollPane.setViewportView(this.thumbnailsPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.thumbnailsPanelScrollPane, gridBagConstraints);
    }
}

