/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesChangedEvent;
import org.jphototagger.api.windows.StatusLineElementProvider;
import org.jphototagger.domain.thumbnails.event.ThumbnailZoomChangedEvent;
import org.jphototagger.domain.thumbnails.event.ThumbnailsChangedEvent;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.swing.KeyEventUtil;
import org.jphototagger.program.module.thumbnails.ThumbnailDimensionsSettingsDialog;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public class ThumbnailSizePanel
extends JPanel
implements AWTEventListener,
ChangeListener,
StatusLineElementProvider {
    private static final long serialVersionUID = 1L;
    private static final int STEP_WIDTH = 1;
    private static final int LARGER_STEP_WIDTH = 10;
    private static final int MIN_MAGINFICATION_PERCENT = 10;
    private static final int MAX_MAGINFICATION_PERCENT = 100;
    private int currentValue = 100;
    private JButton thumbnailDimensionsButton;
    private JSlider thumbnailSizeSlider;

    public ThumbnailSizePanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.initSlider();
        this.listen();
    }

    private void listen() {
        this.thumbnailSizeSlider.addChangeListener(this);
        AnnotationProcessor.process(this);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
    }

    private int getMaxTnWidth() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        int width = prefs.getInt("UserSettings.MaxThumbnailWidth");
        return width != Integer.MIN_VALUE ? width : 150;
    }

    private void initSlider() {
        this.readProperties();
        this.thumbnailSizeSlider.setMinimum(10);
        this.thumbnailSizeSlider.setMaximum(100);
        this.thumbnailSizeSlider.setMajorTickSpacing(1);
        this.thumbnailSizeSlider.setMinorTickSpacing(1);
        this.thumbnailSizeSlider.setValue(this.currentValue);
        this.setThumbnailWidth();
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        this.handleSliderMoved();
    }

    @Override
    public void eventDispatched(AWTEvent awtEvent) {
        KeyEvent keyEvent = (KeyEvent)awtEvent;
        if (keyEvent.getID() == 401) {
            this.keyPressed(keyEvent);
        }
    }

    private void keyPressed(KeyEvent evt) {
        if (KeyEventUtil.isMenuShortcut(evt, 521)) {
            this.moveSlider(10, true);
        } else if (KeyEventUtil.isMenuShortcut(evt, 45)) {
            this.moveSlider(10, false);
        }
    }

    private void moveSlider(int stepWidth, boolean increase) {
        if (increase) {
            this.addToSliderValue(stepWidth);
        } else {
            this.addToSliderValue(-stepWidth);
        }
    }

    private void addToSliderValue(int increment) {
        int value = this.thumbnailSizeSlider.getValue();
        int newValue = Math.min(Math.max(value + increment, 10), 100);
        this.thumbnailSizeSlider.setValue(newValue);
    }

    @EventSubscriber(eventClass=ThumbnailsChangedEvent.class)
    public void thumbnailsChanged(ThumbnailsChangedEvent evt) {
        this.setThumbnailWidth();
    }

    @EventSubscriber(eventClass=PreferencesChangedEvent.class)
    public void applySettings(PreferencesChangedEvent evt) {
        if ("UserSettings.MaxThumbnailWidth".equals(evt.getKey())) {
            this.setThumbnailWidth();
        }
    }

    private void handleSliderMoved() {
        int value = this.thumbnailSizeSlider.getValue();
        if (value != this.currentValue) {
            this.currentValue = value;
            this.writeProperties();
            this.setThumbnailWidth();
            EventBus.publish(new ThumbnailZoomChangedEvent(this.thumbnailSizeSlider, this.currentValue));
        }
    }

    private void readProperties() {
        Preferences preferences = Lookup.getDefault().lookup(Preferences.class);
        Integer value = preferences.getInt("org.jphototagger.program.controller.thumbnail.ControllerSliderThumbnailSize.SliderValue");
        if (!value.equals(Integer.MIN_VALUE)) {
            this.currentValue = value;
        }
    }

    private void setThumbnailWidth() {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                int width = (int)((double)ThumbnailSizePanel.this.getMaxTnWidth() * ((double)ThumbnailSizePanel.this.currentValue / 100.0));
                GUI.getThumbnailsPanel().setThumbnailWidth(width);
            }
        });
    }

    private void writeProperties() {
        Preferences preferences = Lookup.getDefault().lookup(Preferences.class);
        preferences.setInt("org.jphototagger.program.controller.thumbnail.ControllerSliderThumbnailSize.SliderValue", this.currentValue);
    }

    private void showThumbnailDimensionsDialog() {
        ThumbnailDimensionsSettingsDialog dialog = new ThumbnailDimensionsSettingsDialog();
        dialog.setVisible(true);
    }

    @Override
    public Component getStatusLineElement() {
        return this;
    }

    @Override
    public int getPosition() {
        return 900;
    }

    private void initComponents() {
        this.thumbnailSizeSlider = new JSlider();
        this.thumbnailDimensionsButton = new JButton();
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.thumbnailSizeSlider.setMajorTickSpacing(5);
        this.thumbnailSizeSlider.setMinimum(10);
        this.thumbnailSizeSlider.setSnapToTicks(true);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/thumbnails/Bundle");
        this.thumbnailSizeSlider.setToolTipText(bundle.getString("ThumbnailSizePanel.thumbnailSizeSlider.toolTipText"));
        this.thumbnailSizeSlider.setName("thumbnailSizeSlider");
        this.thumbnailSizeSlider.setPreferredSize(new Dimension(200, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.thumbnailSizeSlider, gridBagConstraints);
        this.thumbnailDimensionsButton.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_thumbnail_size.png")));
        this.thumbnailDimensionsButton.setToolTipText(bundle.getString("ThumbnailSizePanel.thumbnailDimensionsButton.toolTipText"));
        this.thumbnailDimensionsButton.setBorder(null);
        this.thumbnailDimensionsButton.setContentAreaFilled(false);
        this.thumbnailDimensionsButton.setName("thumbnailDimensionsButton");
        this.thumbnailDimensionsButton.setPreferredSize(new Dimension(16, 16));
        this.thumbnailDimensionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThumbnailSizePanel.this.thumbnailDimensionsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.thumbnailDimensionsButton, gridBagConstraints);
    }

    private void thumbnailDimensionsButtonActionPerformed(ActionEvent evt) {
        this.showThumbnailDimensionsDialog();
    }
}

