/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpDcSubjectsSubjectMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpRatingMetaDataValue;
import org.jphototagger.domain.thumbnails.ThumbnailFlag;
import org.jphototagger.program.datatransfer.Flavor;
import org.jphototagger.program.module.thumbnails.ThumbnailsPanel;
import org.jphototagger.program.module.thumbnails.cache.RenderedThumbnailCacheIndirection;
import org.jphototagger.program.module.thumbnails.cache.ThumbnailRenderer;
import org.jphototagger.program.module.thumbnails.cache.XmpCache;

public class ThumbnailPanelRenderer
implements ThumbnailRenderer,
DropTargetListener {
    private static final int FLAG_WIDTH = 10;
    private static final int FLAG_HEIGHT = 10;
    private static final int FLAG_PADDING = 5;
    private static final int FONT_HEIGHT = 10;
    private static final Font FONT = new Font("Arial", 0, 10);
    private static int FONT_PIXEL_HEIGHT = -1;
    private static int FONT_PIXEL_DESCENT = -1;
    private static final Color COLOR_TEXT = Color.lightGray;
    private static final Color COLOR_BACKGROUND_PADDING_THUMBNAIL = new Color(0, 0, 0);
    private static final Color COLOR_BORDER_THUMBNAIL = new Color(64, 64, 64);
    private static final Color COLOR_TEXT_HIGHLIGHTED = new Color(255, 255, 168);
    private static final Color COLOR_TEXT_BACKGROUND = new Color(0, 0, 128);
    private static final Color COLOR_BACKGROUND_PADDING_THUMBNAIL_HIGHLIGHTED = new Color(112, 122, 148);
    private static final Color COLOR_BACKGROUND_PADDING_THUMBNAIL_DRAG_OVER = new Color(169, 171, 176);
    private static final Color COLOR_DROP_MARKER = new Color(225, 225, 225);
    private static final Color COLOR_BORDER_THUMBNAIL_HIGHLIGHTED = new Color(128, 128, 164);
    private int maxCharCountText = 35;
    private static final int MARGIN_THUMBNAIL = 3;
    private static final int WIDHT_BORDER_THUMBNAIL = 1;
    private static final int MAX_CHAR_COUNT_PER_150_PX = 30;
    private int thumbnailWidth = 0;
    private int dragIndex = -1;
    private int dropIndex = -1;
    private int oldDropIndex = -1;
    private final XmpCache xmpCache = XmpCache.INSTANCE;
    private static final int STAR_COUNT = 6;
    private final Image[] starImage = new Image[6];
    private final ThumbnailsPanel panel;

    public ThumbnailPanelRenderer(ThumbnailsPanel _panel) {
        if (_panel == null) {
            throw new NullPointerException("_panel == null");
        }
        this.panel = _panel;
        this.computeFontHeight();
        this.loadRatingImages();
    }

    private void computeFontHeight() {
        FONT_PIXEL_HEIGHT = this.panel.getFontMetrics(FONT).getHeight();
        FONT_PIXEL_DESCENT = this.panel.getFontMetrics(FONT).getDescent() + this.panel.getFontMetrics(FONT).getLeading() / 2;
    }

    private void loadRatingImages() {
        for (int i = 0; i < 6; ++i) {
            this.starImage[i] = new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_xmp_rating_" + Integer.toString(i) + ".png")).getImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDragOver(File file) {
        ThumbnailsPanel thumbnailsPanel = this.panel;
        synchronized (thumbnailsPanel) {
            if (file == null || this.dragIndex < 0) {
                return false;
            }
            File dragOverFile = this.panel.getFileAtIndex(this.dragIndex);
            return this.panel.getIndexOf(file) >= 0 && file.equals(dragOverFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image getRenderedThumbnail(Image scaled, RenderedThumbnailCacheIndirection rtci, boolean dummy) {
        if (scaled == null) {
            throw new NullPointerException("scaled == null");
        }
        if (rtci == null) {
            throw new NullPointerException("rtci == null");
        }
        ThumbnailsPanel thumbnailsPanel = this.panel;
        synchronized (thumbnailsPanel) {
            int sw = scaled.getWidth(null);
            int sh = scaled.getHeight(null);
            int length = sw > sh ? sw : sh;
            int w = length + 6 + 2;
            int h = w + FONT_PIXEL_HEIGHT;
            BufferedImage bi = new BufferedImage(w, h, 1);
            Graphics2D g2 = bi.createGraphics();
            if (!dummy) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            g2.setFont(FONT);
            g2.setColor(ThumbnailsPanel.COLOR_BACKGROUND_PANEL);
            g2.fillRect(0, 0, w, h);
            this.paintThumbnailBackground(g2, this.panel.isFileSelected(rtci.file), this.isDragOver(rtci.file));
            this.paintThumbnail(scaled, g2);
            if (!dummy) {
                this.paintThumbnailFlags(g2, rtci.file);
                this.paintThumbnailText(g2, rtci.file);
                rtci.renderedForKeywords = this.panel.isMetaDataOverlay();
                boolean actualOverlay = false;
                if (this.panel.isMetaDataOverlay()) {
                    actualOverlay = this.paintThumbnailKeywords(g2, rtci.file);
                    actualOverlay |= this.paintThumbnailStars(g2, rtci.file);
                }
                rtci.hasKeywords = actualOverlay;
            }
            g2.dispose();
            return bi;
        }
    }

    private void paintThumbnailBackground(Graphics2D g, boolean isSelected, boolean isDrag) {
        Color backgroundColor = isSelected ? COLOR_BACKGROUND_PADDING_THUMBNAIL_HIGHLIGHTED : (isDrag ? COLOR_BACKGROUND_PADDING_THUMBNAIL_DRAG_OVER : COLOR_BACKGROUND_PADDING_THUMBNAIL);
        Color borderColor = isSelected ? COLOR_BORDER_THUMBNAIL_HIGHLIGHTED : COLOR_BORDER_THUMBNAIL;
        Color oldColor = g.getColor();
        g.setColor(backgroundColor);
        int width = this.thumbnailWidth + 6 + 1;
        int height = this.thumbnailWidth + 6 + 1;
        int arcWidth = 6;
        int arcHeight = 6;
        g.fillRoundRect(0, 0, width, height, 6, 6);
        g.setColor(borderColor);
        int roundWidth = this.thumbnailWidth + 6 + 1;
        int roundHeight = this.thumbnailWidth + 6 + 1;
        int roundArcHeight = 6;
        int roundArcHeigth = 6;
        g.drawRoundRect(0, 0, roundWidth, roundHeight, 6, 6);
        g.setColor(oldColor);
    }

    private void paintThumbnailFlags(Graphics g, File file) {
        List<ThumbnailFlag> flags = this.panel.getFlagsOfFile(file);
        int flagCount = flags.size();
        if (flagCount < 1) {
            return;
        }
        Color oldColor = g.getColor();
        int y = this.thumbnailWidth + 6 - 10;
        for (int i = 0; i < flagCount; ++i) {
            int x = this.thumbnailWidth + 6 - 10 * (i + 1);
            int n = i == 0 ? 0 : 5;
            ThumbnailFlag flag = flags.get(i);
            g.setColor(flag.getFillColor());
            g.fillRect(x -= n, y, 10, 10);
            g.setColor(flag.getBorderColor());
            g.drawRect(x, y, 10, 10);
        }
        g.setColor(oldColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintImgDropMarker(Graphics g) {
        ThumbnailsPanel thumbnailsPanel = this.panel;
        synchronized (thumbnailsPanel) {
            if (this.dropIndex < 0) {
                return;
            }
            Point topLeft = this.panel.getTopLeftOfTnIndex(this.dropIndex);
            Color oldColor = g.getColor();
            g.setColor(COLOR_DROP_MARKER);
            int xCenter = topLeft.x + 1 + this.thumbnailWidth / 2;
            int y = topLeft.y - 4;
            int halfTopWidth = 10;
            int height = 10;
            g.fillPolygon(this.getDropMarkerTriangle(xCenter, y, 10, 10));
            g.setColor(oldColor);
        }
    }

    private Polygon getDropMarkerTriangle(int xCenter, int y, int halfTopWidth, int height) {
        int[] xs = new int[]{xCenter - halfTopWidth, xCenter + halfTopWidth, xCenter};
        int[] ys = new int[]{y, y, y + height};
        return new Polygon(xs, ys, xs.length);
    }

    private void paintThumbnail(Image thumbnail, Graphics g) {
        int indentTop = this.getThumbnailTopIndent(thumbnail);
        int indentLeft = this.getThumbnailLeftIndent(thumbnail);
        g.drawImage(thumbnail, indentLeft, indentTop, null);
    }

    private void paintThumbnailText(Graphics g, File file) {
        int lenTitle;
        String text = this.getFormattedText(file);
        int width = this.getThumbnailAreaWidth();
        int space = width - (lenTitle = g.getFontMetrics().stringWidth(text));
        int xText = space > 0 ? (space + 1) / 2 : 0;
        Color oldColor = g.getColor();
        g.setColor(this.panel.isFileSelected(file) ? COLOR_TEXT_HIGHLIGHTED : COLOR_TEXT);
        g.drawString(text, xText, this.getThumbnailAreaHeight() - FONT_PIXEL_DESCENT);
        g.setColor(oldColor);
    }

    private boolean paintThumbnailKeywords(Graphics g, File file) {
        List<String> keywords = this.getKeywords(file);
        if (keywords == null || keywords.isEmpty()) {
            return false;
        }
        Collections.sort(keywords);
        int width = this.getThumbnailAreaWidth();
        int height = this.getThumbnailAreaHeightNoText();
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D g2 = bi.createGraphics();
        g2.setColor(new Color(0, 0, 0, 0));
        g2.fillRect(0, 0, width, height);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(COLOR_TEXT_BACKGROUND);
        g2.setFont(FONT);
        Iterator<String> is = keywords.iterator();
        int i = 0;
        while (is.hasNext()) {
            String text = is.next();
            int x = 1;
            int y = 1 + (i + 1) * FONT_PIXEL_HEIGHT - FONT_PIXEL_DESCENT;
            g2.drawString(text, x + 1, y);
            g2.drawString(text, x - 1, y);
            g2.drawString(text, x, y + 1);
            g2.drawString(text, x, y - 1);
            ++i;
        }
        g2.dispose();
        float frac = 0.11111111f;
        float[] kernel = new float[]{frac, frac, frac, frac, frac, frac, frac, frac, frac};
        ConvolveOp op = new ConvolveOp(new Kernel(3, 3, kernel), 1, null);
        BufferedImage bi2 = op.filter(bi, null);
        g2 = bi2.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(COLOR_TEXT_HIGHLIGHTED);
        g2.setFont(FONT);
        is = keywords.iterator();
        int i2 = 0;
        while (is.hasNext()) {
            g2.drawString(is.next(), 1, 1 + (i2 + 1) * FONT_PIXEL_HEIGHT - FONT_PIXEL_DESCENT);
            ++i2;
        }
        g2.dispose();
        g.drawImage(bi2, 0, 0, null);
        return true;
    }

    private boolean paintThumbnailStars(Graphics g, File file) {
        int stars = this.getRating(file);
        if (stars >= 0) {
            int i = Math.min(5, stars);
            g.drawImage(this.starImage[i], this.getThumbnailAreaWidth() - this.starImage[i].getWidth(null), 0, null);
            return true;
        }
        return false;
    }

    private String getFormattedText(File file) {
        String text = this.getText(file);
        int charCountText = text.length();
        if (charCountText <= this.maxCharCountText) {
            return text;
        }
        return "..." + text.substring(text.length() - this.maxCharCountText + 2);
    }

    private int getThumbnailLeftIndent(Image thumbnail) {
        int indentLeft = (this.getThumbnailAreaWidth() - thumbnail.getWidth(null) + 1) / 2;
        if (indentLeft < 0) {
            indentLeft = 0;
        }
        return indentLeft;
    }

    private int getThumbnailTopIndent(Image thumbnail) {
        int indentTop = (this.getThumbnailAreaHeightNoText() - thumbnail.getHeight(null) + 1) / 2;
        if (indentTop < 0) {
            indentTop = 0;
        }
        return indentTop;
    }

    public int getThumbnailAreaHeight() {
        return this.getThumbnailAreaHeightNoText() + FONT_PIXEL_HEIGHT;
    }

    private int getThumbnailAreaHeightNoText() {
        return this.thumbnailWidth + 6 + 2;
    }

    public int getThumbnailAreaWidth() {
        return this.thumbnailWidth + 6 + 2;
    }

    public void setThumbnailWidth(int width) {
        this.thumbnailWidth = width;
        this.maxCharCountText = (int)(30.0 * (double)width / 150.0);
    }

    public int getThumbnailWidth() {
        return this.thumbnailWidth;
    }

    protected String getText(File file) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        String filename = file.getAbsolutePath();
        int indexPathSeparator = filename.lastIndexOf(File.separator);
        if (indexPathSeparator >= 0 && indexPathSeparator + 1 < filename.length()) {
            filename = filename.substring(indexPathSeparator + 1);
        }
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getKeywords(File file) {
        ThumbnailsPanel thumbnailsPanel = this.panel;
        synchronized (thumbnailsPanel) {
            if (file == null) {
                throw new NullPointerException("file == null");
            }
            Xmp xmp = this.xmpCache.getXmp(file);
            if (xmp == null || !xmp.contains(XmpDcSubjectsSubjectMetaDataValue.INSTANCE)) {
                return null;
            }
            return (List)xmp.getValue(XmpDcSubjectsSubjectMetaDataValue.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRating(File file) {
        ThumbnailsPanel thumbnailsPanel = this.panel;
        synchronized (thumbnailsPanel) {
            Long rating;
            if (file == null) {
                throw new NullPointerException("file == null");
            }
            Xmp xmp = this.xmpCache.getXmp(file);
            if (xmp == null) {
                return 0;
            }
            Long l = rating = xmp.contains(XmpRatingMetaDataValue.INSTANCE) ? (Long)xmp.getValue(XmpRatingMetaDataValue.INSTANCE) : null;
            if (rating == null) {
                return 0;
            }
            return rating.intValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearDrag() {
        ThumbnailsPanel thumbnailsPanel = this.panel;
        synchronized (thumbnailsPanel) {
            this.panel.setDrag(false);
            if (this.dropIndex >= 0 || this.oldDropIndex >= 0) {
                this.dropIndex = -1;
                this.oldDropIndex = -1;
                this.panel.repaint();
            }
            if (this.panel.isIndex(this.dragIndex)) {
                int oldDragIndex = this.dragIndex;
                this.dragIndex = -1;
                if (this.panel.isIndex(oldDragIndex)) {
                    this.panel.rerender(oldDragIndex);
                }
            }
        }
    }

    private boolean isImageCollectionDrag(Transferable t) {
        return t.isDataFlavorSupported(Flavor.IMAGE_COLLECTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        ThumbnailsPanel thumbnailsPanel = this.panel;
        synchronized (thumbnailsPanel) {
            this.panel.setDrag(true);
            if (Flavor.isMetadataTransferred(dtde.getTransferable())) {
                Point loc = dtde.getLocation();
                int index = this.panel.getThumbnailIndexAtPoint(loc.x, loc.y);
                if (index != this.dragIndex && this.panel.isIndex(index)) {
                    int oldDragIndex = this.dragIndex;
                    this.dragIndex = index;
                    if (this.panel.isIndex(oldDragIndex)) {
                        this.panel.rerender(oldDragIndex);
                    }
                    this.panel.rerender(index);
                }
            } else if (this.isImageCollectionDrag(dtde.getTransferable())) {
                Point loc = dtde.getLocation();
                int index = this.panel.getImageMoveDropIndex(loc.x, loc.y);
                if (index != this.dropIndex && this.panel.isIndex(index)) {
                    this.oldDropIndex = this.dropIndex;
                    this.dropIndex = index;
                    this.panel.repaint();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dragExit(DropTargetEvent dte) {
        ThumbnailsPanel thumbnailsPanel = this.panel;
        synchronized (thumbnailsPanel) {
            this.clearDrag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(DropTargetDropEvent dtde) {
        ThumbnailsPanel thumbnailsPanel = this.panel;
        synchronized (thumbnailsPanel) {
            this.clearDrag();
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }
}

