/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails;

import java.io.File;
import java.util.Arrays;
import org.jphototagger.domain.programs.Program;
import org.jphototagger.domain.repository.ProgramsRepository;
import org.jphototagger.lib.awt.DesktopUtil;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.program.module.programs.StartPrograms;
import org.jphototagger.program.module.thumbnails.ThumbnailsPanel;
import org.openide.util.Lookup;

public final class ThumbnailDoubleklickController {
    private final ThumbnailsPanel panel;
    private final ProgramsRepository repo = Lookup.getDefault().lookup(ProgramsRepository.class);

    public ThumbnailDoubleklickController(ThumbnailsPanel panel) {
        if (panel == null) {
            throw new NullPointerException("panel == null");
        }
        this.panel = panel;
    }

    public void doubleClickAtIndex(int index) {
        this.openImageAtIndex(index);
    }

    private void openImageAtIndex(int index) {
        if (this.panel.isIndex(index)) {
            File selectedFile = this.panel.getFileAtIndex(index);
            Program program = this.findDefaultImageOpenProgram(selectedFile);
            if (program == null) {
                DesktopUtil.open(selectedFile, "ThumbnailDoubleklickController.OpenWithDesktop");
            } else {
                StartPrograms startPrograms = new StartPrograms();
                boolean waitForTermination = false;
                startPrograms.startProgram(program, Arrays.asList(selectedFile), waitForTermination);
            }
        }
    }

    private Program findDefaultImageOpenProgram(File file) {
        Program program = this.repo.findDefaultProgram(FileUtil.getSuffix(file));
        return program == null ? this.repo.findDefaultImageOpenProgram() : program;
    }
}

