/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesChangedEvent;
import org.jphototagger.api.storage.Persistence;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.openide.util.Lookup;

public class ThumbnailDimensionsSettingsPanel
extends JPanel
implements Persistence {
    private static final long serialVersionUID = 1L;
    private boolean listenToMaxThumbnailWidthChanges = true;
    private JLabel labelMaxThumbnailWidth;
    private JLabel labelUpdateAllThumbnails;
    private JSpinner spinnerMaxThumbnailWidth;

    public ThumbnailDimensionsSettingsPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        MnemonicUtil.setMnemonics(this);
        AnnotationProcessor.process(this);
    }

    private void handleStateChangedSpinnerMaxThumbnailWidth() {
        this.setMaxThumbnailWidth((Integer)this.spinnerMaxThumbnailWidth.getValue());
    }

    private void setMaxThumbnailWidth(int width) {
        Preferences preferences = Lookup.getDefault().lookup(Preferences.class);
        preferences.setInt("UserSettings.MaxThumbnailWidth", width);
    }

    @Override
    public void restore() {
        this.spinnerMaxThumbnailWidth.setValue(this.getMaxThumbnailWidth());
    }

    private int getMaxThumbnailWidth() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        int width = prefs.getInt("UserSettings.MaxThumbnailWidth");
        return width != Integer.MIN_VALUE ? width : 150;
    }

    @Override
    public void persist() {
    }

    @EventSubscriber(eventClass=PreferencesChangedEvent.class)
    public void preferencesChanged(PreferencesChangedEvent evt) {
        if ("UserSettings.MaxThumbnailWidth".equals(evt.getKey())) {
            this.listenToMaxThumbnailWidthChanges = false;
            this.spinnerMaxThumbnailWidth.setValue((Integer)evt.getNewValue());
            this.listenToMaxThumbnailWidthChanges = true;
        }
    }

    private void initComponents() {
        this.labelMaxThumbnailWidth = new JLabel();
        this.spinnerMaxThumbnailWidth = new JSpinner();
        this.labelUpdateAllThumbnails = new JLabel();
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.labelMaxThumbnailWidth.setHorizontalAlignment(4);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/thumbnails/Bundle");
        this.labelMaxThumbnailWidth.setText(bundle.getString("ThumbnailDimensionsSettingsPanel.labelMaxThumbnailWidth.text"));
        this.labelMaxThumbnailWidth.setName("labelMaxThumbnailWidth");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.labelMaxThumbnailWidth, gridBagConstraints);
        this.spinnerMaxThumbnailWidth.setModel(new SpinnerNumberModel(150, 50, 400, 50));
        this.spinnerMaxThumbnailWidth.setName("spinnerMaxThumbnailWidth");
        this.spinnerMaxThumbnailWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ThumbnailDimensionsSettingsPanel.this.spinnerMaxThumbnailWidthStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.spinnerMaxThumbnailWidth, gridBagConstraints);
        this.labelUpdateAllThumbnails.setHorizontalAlignment(2);
        this.labelUpdateAllThumbnails.setText(bundle.getString("ThumbnailDimensionsSettingsPanel.labelUpdateAllThumbnails.text"));
        this.labelUpdateAllThumbnails.setName("labelUpdateAllThumbnails");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(7, 6, 6, 6);
        this.add((Component)this.labelUpdateAllThumbnails, gridBagConstraints);
    }

    private void spinnerMaxThumbnailWidthStateChanged(ChangeEvent evt) {
        this.handleStateChangedSpinnerMaxThumbnailWidth();
    }
}

