/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JTabbedPane;
import org.jphototagger.domain.thumbnails.ThumbnailCreator;
import org.jphototagger.lib.api.PositionProviderAscendingComparator;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.openide.util.Lookup;

public class ThumbnailCreatorSettingsDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private JTabbedPane tabbedPane;

    public ThumbnailCreatorSettingsDialog() {
        super(ComponentUtil.findFrameWithIcon(), true);
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        ArrayList<ThumbnailCreator> creators = new ArrayList<ThumbnailCreator>(Lookup.getDefault().lookupAll(ThumbnailCreator.class));
        Collections.sort(creators, PositionProviderAscendingComparator.INSTANCE);
        for (ThumbnailCreator creator : creators) {
            Component settingsComponent = creator.getSettingsComponent();
            if (settingsComponent == null) continue;
            this.tabbedPane.add(creator.getDisplayName(), settingsComponent);
        }
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/thumbnails/Bundle");
        this.setTitle(bundle.getString("ThumbnailCreatorSettingsDialog.title"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane, -1, 611, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane, -1, 413, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ThumbnailCreatorSettingsDialog dialog = new ThumbnailCreatorSettingsDialog();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

