/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.domain.repository.ThumbnailsRepository;
import org.jphototagger.image.util.ImageTransform;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.program.module.thumbnails.ThumbnailsPopupMenu;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class RotateThumbnailsController
implements ActionListener {
    private final Map<JMenuItem, Float> angleOfItem = new HashMap<JMenuItem, Float>();
    private final ThumbnailsRepository tnRepo = Lookup.getDefault().lookup(ThumbnailsRepository.class);

    public RotateThumbnailsController() {
        this.initAngleOfItem();
        this.listen();
    }

    private void initAngleOfItem() {
        ThumbnailsPopupMenu popup = ThumbnailsPopupMenu.INSTANCE;
        this.angleOfItem.put(popup.getItemRotateThumbnail90(), new Float(90.0f));
        this.angleOfItem.put(popup.getItemRotateThumbnai180(), new Float(180.0f));
        this.angleOfItem.put(popup.getItemRotateThumbnail270(), new Float(270.0f));
    }

    private void listen() {
        ThumbnailsPopupMenu popup = ThumbnailsPopupMenu.INSTANCE;
        popup.getItemRotateThumbnail90().addActionListener(this);
        popup.getItemRotateThumbnai180().addActionListener(this);
        popup.getItemRotateThumbnail270().addActionListener(this);
    }

    private float getRotateAngle(Object obj) {
        JMenuItem menuItem;
        Float angle = new Float(0.0f);
        if (obj instanceof JMenuItem && this.angleOfItem.containsKey(menuItem = (JMenuItem)obj)) {
            angle = this.angleOfItem.get(menuItem);
        }
        return angle.floatValue();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.rotateSelectedImages(this.getRotateAngle(evt.getSource()));
    }

    private void rotateSelectedImages(final float rotateAngle) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){
            private final ImageFilesRepository repo = Lookup.getDefault().lookup(ImageFilesRepository.class);

            @Override
            public void run() {
                List<File> selFiles = GUI.getSelectedImageFiles();
                for (File imageFile : selFiles) {
                    Image rotatedTn;
                    Image unrotatedTn = RotateThumbnailsController.this.tnRepo.findThumbnail(imageFile);
                    if (unrotatedTn == null || (rotatedTn = ImageTransform.rotate(unrotatedTn, rotateAngle)) == null) continue;
                    this.repo.updateThumbnail(imageFile, rotatedTn);
                }
            }
        });
    }
}

