/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.domain.metadata.thumbnails.ThumbnailInfoProvider;
import org.jphototagger.domain.metadata.xmp.XmpSidecarFileResolver;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.domain.thumbnails.ThumbnailsPanelBottomComponentProvider;
import org.jphototagger.domain.thumbnails.event.ThumbnailsSelectionChangedEvent;
import org.jphototagger.lib.api.PositionProviderAscendingComparator;
import org.jphototagger.lib.awt.DesktopUtil;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.CollectionUtil;
import org.jphototagger.program.module.thumbnails.info.SidecarSuffixInfoAddedEvent;
import org.jphototagger.program.module.thumbnails.info.SidecarSuffixInfoRemovedEvent;
import org.jphototagger.program.types.ByteSizeUnit;
import org.openide.util.Lookup;

public class InfoOfSelectedThumbnailPanel
extends JPanel
implements ThumbnailsPanelBottomComponentProvider {
    private static final long serialVersionUID = 1L;
    private static final String PROMPT_DATE_TIME_TAKEN = Bundle.getString(InfoOfSelectedThumbnailPanel.class, "InfoOfSelectedThumbnailPanel.Prompt.DateTimeTaken", new Object[0]);
    private static final String PROMPT_DATE_TIME_LAST_MODIFIED = Bundle.getString(InfoOfSelectedThumbnailPanel.class, "InfoOfSelectedThumbnailPanel.Prompt.LastModified", new Object[0]);
    private final XmpSidecarFileResolver xmpSidecarFileResolver = Lookup.getDefault().lookup(XmpSidecarFileResolver.class);
    private File selectedFile;
    private JButton buttonOpenDirectoryOfSelectedFile;
    private JCheckBox checkBoxSelectedFileHasSidecarFile;
    private JLabel labelSelectedFileDate;
    private JLabel labelSelectedFileDatePrompt;
    private JLabel labelSelectedFilePathName;
    private JLabel labelSelectedFilePathPrompt;
    private JLabel labelSelectedFileSize;
    private JLabel labelSelectedFileSizePrompt;
    private JPanel panelContent;
    private JPanel panelPadding;
    private JPanel panelSelectedFileDateSizeXmpExists;
    private JPanel panelSelectedFilePath;
    private JPanel panelThumbnailInfoProviders;

    public InfoOfSelectedThumbnailPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.lookupThumbnailInfoProviders();
        AnnotationProcessor.process(this);
    }

    private void lookupThumbnailInfoProviders() {
        ArrayList<ThumbnailInfoProvider> providers = new ArrayList<ThumbnailInfoProvider>(Lookup.getDefault().lookupAll(ThumbnailInfoProvider.class));
        Collections.sort(providers, PositionProviderAscendingComparator.INSTANCE);
        for (ThumbnailInfoProvider provider : providers) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.gridwidth = 0;
            this.panelThumbnailInfoProviders.add(provider.getComponent(), gbc);
        }
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @EventSubscriber(eventClass=ThumbnailsSelectionChangedEvent.class)
    public void thumbnailsSelectionChanged(final ThumbnailsSelectionChangedEvent evt) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                int selectionCount = evt.getSelectionCount();
                if (selectionCount == 1) {
                    List<File> selectedFiles = evt.getSelectedFiles();
                    InfoOfSelectedThumbnailPanel.this.selectedFile = CollectionUtil.getFirstElement(selectedFiles);
                } else {
                    InfoOfSelectedThumbnailPanel.this.selectedFile = null;
                }
                InfoOfSelectedThumbnailPanel.this.selectedFileChanged();
            }
        });
    }

    private void selectedFileChanged() {
        this.reset();
        if (this.selectedFile == null) {
            return;
        }
        this.labelSelectedFilePathName.setText(this.selectedFile.getAbsolutePath());
        File sidecarFile = this.xmpSidecarFileResolver.getXmpSidecarFileOrNullIfNotExists(this.selectedFile);
        this.checkBoxSelectedFileHasSidecarFile.setSelected(sidecarFile != null);
        this.buttonOpenDirectoryOfSelectedFile.setEnabled(this.selectedFile.getParentFile() != null);
        this.setDateTimeTake();
        this.setSize();
    }

    private void setDateTimeTake() {
        ImageFilesRepository repo = Lookup.getDefault().lookup(ImageFilesRepository.class);
        long millis = repo.findExifDateTimeOriginalTimestamp(this.selectedFile);
        this.labelSelectedFileDatePrompt.setText(millis > 0L ? PROMPT_DATE_TIME_TAKEN : PROMPT_DATE_TIME_LAST_MODIFIED);
        if (millis <= 0L) {
            millis = this.selectedFile.lastModified();
        }
        this.setDateToLabel(millis, this.labelSelectedFileDate);
    }

    private void setDateToLabel(long millis, JLabel label) {
        DateFormat df = DateFormat.getDateTimeInstance(0, 0);
        label.setText(df.format(new Date(millis)));
    }

    private void setSize() {
        long length = this.selectedFile.length();
        ByteSizeUnit unit = ByteSizeUnit.unit(length);
        long unitLength = length / unit.bytes();
        this.labelSelectedFileSize.setText(unitLength + " " + unit.toString());
    }

    private void reset() {
        this.labelSelectedFilePathName.setText("");
        this.labelSelectedFileDate.setText("");
        this.labelSelectedFileSize.setText("");
        this.checkBoxSelectedFileHasSidecarFile.setSelected(false);
        this.buttonOpenDirectoryOfSelectedFile.setEnabled(false);
    }

    private void openDirectoryOfSelectedFile() {
        File directory;
        if (this.selectedFile != null && (directory = this.selectedFile.getParentFile()) != null) {
            DesktopUtil.open(directory, "JPhotoTagger.BrowseFolder.Executable");
        }
    }

    @EventSubscriber(eventClass=SidecarSuffixInfoAddedEvent.class)
    public void suffixInfoAdded(SidecarSuffixInfoAddedEvent evt) {
        ComponentUtil.forceRepaint(this);
    }

    @EventSubscriber(eventClass=SidecarSuffixInfoRemovedEvent.class)
    public void suffixInfoRemoved(SidecarSuffixInfoRemovedEvent evt) {
        ComponentUtil.forceRepaint(this);
    }

    private void initComponents() {
        this.panelContent = new JPanel();
        this.panelSelectedFilePath = new JPanel();
        this.labelSelectedFilePathPrompt = new JLabel();
        this.labelSelectedFilePathPrompt.setFont(ComponentUtil.createBoldFont(this.labelSelectedFilePathPrompt.getFont()));
        this.labelSelectedFilePathName = new JLabel();
        this.buttonOpenDirectoryOfSelectedFile = new JButton();
        this.panelSelectedFileDateSizeXmpExists = new JPanel();
        this.labelSelectedFileDatePrompt = new JLabel();
        this.labelSelectedFileDatePrompt.setFont(ComponentUtil.createBoldFont(this.labelSelectedFileDatePrompt.getFont()));
        this.labelSelectedFileDate = new JLabel();
        this.labelSelectedFileSizePrompt = new JLabel();
        this.labelSelectedFileSizePrompt.setFont(ComponentUtil.createBoldFont(this.labelSelectedFileSizePrompt.getFont()));
        this.labelSelectedFileSize = new JLabel();
        this.checkBoxSelectedFileHasSidecarFile = new JCheckBox();
        this.panelThumbnailInfoProviders = new JPanel();
        this.panelPadding = new JPanel();
        this.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/thumbnails/Bundle");
        this.panelContent.setBorder(BorderFactory.createTitledBorder(bundle.getString("InfoOfSelectedThumbnailPanel.panelContent.border.title")));
        this.panelContent.setLayout(new GridBagLayout());
        this.panelSelectedFilePath.setLayout(new GridBagLayout());
        this.labelSelectedFilePathPrompt.setText(bundle.getString("InfoOfSelectedThumbnailPanel.labelSelectedFilePathPrompt.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelSelectedFilePath.add((Component)this.labelSelectedFilePathPrompt, gridBagConstraints);
        this.labelSelectedFilePathName.setText(bundle.getString("InfoOfSelectedThumbnailPanel.labelSelectedFilePathName.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelSelectedFilePath.add((Component)this.labelSelectedFilePathName, gridBagConstraints);
        this.buttonOpenDirectoryOfSelectedFile.setText(bundle.getString("InfoOfSelectedThumbnailPanel.buttonOpenDirectoryOfSelectedFile.text"));
        this.buttonOpenDirectoryOfSelectedFile.setEnabled(false);
        this.buttonOpenDirectoryOfSelectedFile.setMargin(new Insets(0, 0, 0, 0));
        this.buttonOpenDirectoryOfSelectedFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InfoOfSelectedThumbnailPanel.this.buttonOpenDirectoryOfSelectedFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelSelectedFilePath.add((Component)this.buttonOpenDirectoryOfSelectedFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panelContent.add((Component)this.panelSelectedFilePath, gridBagConstraints);
        this.panelSelectedFileDateSizeXmpExists.setLayout(new GridBagLayout());
        this.labelSelectedFileDatePrompt.setText(bundle.getString("InfoOfSelectedThumbnailPanel.labelSelectedFileDatePrompt.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelSelectedFileDateSizeXmpExists.add((Component)this.labelSelectedFileDatePrompt, gridBagConstraints);
        this.labelSelectedFileDate.setText(bundle.getString("InfoOfSelectedThumbnailPanel.labelSelectedFileDate.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelSelectedFileDateSizeXmpExists.add((Component)this.labelSelectedFileDate, gridBagConstraints);
        this.labelSelectedFileSizePrompt.setText(bundle.getString("InfoOfSelectedThumbnailPanel.labelSelectedFileSizePrompt.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelSelectedFileDateSizeXmpExists.add((Component)this.labelSelectedFileSizePrompt, gridBagConstraints);
        this.labelSelectedFileSize.setText(bundle.getString("InfoOfSelectedThumbnailPanel.labelSelectedFileSize.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelSelectedFileDateSizeXmpExists.add((Component)this.labelSelectedFileSize, gridBagConstraints);
        this.checkBoxSelectedFileHasSidecarFile.setText(bundle.getString("InfoOfSelectedThumbnailPanel.checkBoxSelectedFileHasSidecarFile.text"));
        this.checkBoxSelectedFileHasSidecarFile.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelSelectedFileDateSizeXmpExists.add((Component)this.checkBoxSelectedFileHasSidecarFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelContent.add((Component)this.panelSelectedFileDateSizeXmpExists, gridBagConstraints);
        this.panelThumbnailInfoProviders.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelContent.add((Component)this.panelThumbnailInfoProviders, gridBagConstraints);
        GroupLayout panelPaddingLayout = new GroupLayout(this.panelPadding);
        this.panelPadding.setLayout(panelPaddingLayout);
        panelPaddingLayout.setHorizontalGroup(panelPaddingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panelPaddingLayout.setVerticalGroup(panelPaddingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.panelContent.add((Component)this.panelPadding, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panelContent, gridBagConstraints);
    }

    private void buttonOpenDirectoryOfSelectedFileActionPerformed(ActionEvent evt) {
        this.openDirectoryOfSelectedFile();
    }
}

