/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails;

import javax.swing.DefaultComboBoxModel;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.filefilter.UserDefinedFileFilter;
import org.jphototagger.domain.repository.Repository;
import org.jphototagger.domain.repository.UserDefinedFileFiltersRepository;
import org.jphototagger.domain.repository.event.userdefinedfilefilters.UserDefinedFileFilterDeletedEvent;
import org.jphototagger.domain.repository.event.userdefinedfilefilters.UserDefinedFileFilterInsertedEvent;
import org.jphototagger.domain.repository.event.userdefinedfilefilters.UserDefinedFileFilterUpdatedEvent;
import org.jphototagger.domain.repository.event.userdefinedfiletypes.UserDefinedFileTypeDeletedEvent;
import org.jphototagger.domain.repository.event.userdefinedfiletypes.UserDefinedFileTypeInsertedEvent;
import org.jphototagger.domain.repository.event.userdefinedfiletypes.UserDefinedFileTypeUpdatedEvent;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.io.filefilter.RegexFileFilter;
import org.jphototagger.program.filefilter.AppFileFilters;
import org.openide.util.Lookup;

public final class FileFiltersComboBoxModel
extends DefaultComboBoxModel<Object> {
    private static final long serialVersionUID = 1L;
    static final String PERSISTED_SELECTED_ITEM_KEY = "ComboBoxModelFileFilters.SelIndex";
    private RegexFileFilter allAcceptedFileImageFilesFilter;
    private RegexFileFilter userDefinedFileTypesFilter;
    private final UserDefinedFileFiltersRepository udffRepo = Lookup.getDefault().lookup(UserDefinedFileFiltersRepository.class);

    public FileFiltersComboBoxModel() {
        this.insertElements();
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process(this);
    }

    private void insertElements() {
        Repository repo = Lookup.getDefault().lookup(Repository.class);
        if (repo == null || !repo.isInit()) {
            return;
        }
        this.allAcceptedFileImageFilesFilter = AppFileFilters.INSTANCE.getAllAcceptedImageFilesFilter();
        this.addElement(this.allAcceptedFileImageFilesFilter);
        this.addElement(AppFileFilters.INSTANCE.getAcceptedJpegFilesFilter());
        this.addElement(AppFileFilters.INSTANCE.getAcceptedTiffFilesFilter());
        this.addElement(AppFileFilters.INSTANCE.getAcceptedRawFilesFilter());
        this.addElement(AppFileFilters.INSTANCE.getAcceptedDngFilesFilter());
        this.userDefinedFileTypesFilter = AppFileFilters.INSTANCE.getUserDefinedFileTypesFilter();
        if (this.userDefinedFileTypesFilter != null) {
            this.addElement(this.userDefinedFileTypesFilter);
        }
        this.addElement(AppFileFilters.NO_XMP);
        this.addElement(AppFileFilters.XMP_RATING_1_STAR);
        this.addElement(AppFileFilters.XMP_RATING_2_STARS);
        this.addElement(AppFileFilters.XMP_RATING_3_STARS);
        this.addElement(AppFileFilters.XMP_RATING_4_STARS);
        this.addElement(AppFileFilters.XMP_RATING_5_STARS);
        for (UserDefinedFileFilter filter : this.udffRepo.findAllUserDefinedFileFilters()) {
            this.addElement(filter);
        }
    }

    void selectPersistedItem() {
        int index;
        Preferences references = Lookup.getDefault().lookup(Preferences.class);
        if (references.containsKey(PERSISTED_SELECTED_ITEM_KEY) && (index = references.getInt(PERSISTED_SELECTED_ITEM_KEY)) >= 0 && index < this.getSize()) {
            this.setSelectedItem(this.getElementAt(index));
        }
    }

    private void updateFilter(UserDefinedFileFilter filter) {
        int index = this.getIndexOf(filter);
        if (index >= 0) {
            ((UserDefinedFileFilter)this.getElementAt(index)).set(filter);
            this.fireContentsChanged(this, index, index);
        }
    }

    private void deleteFilter(UserDefinedFileFilter filter) {
        this.removeElement(filter);
    }

    private void insertFilter(UserDefinedFileFilter filter) {
        this.addElement(filter);
    }

    @EventSubscriber(eventClass=UserDefinedFileFilterInsertedEvent.class)
    public void userDefinedFileFilterInserted(UserDefinedFileFilterInsertedEvent evt) {
        this.insertFilter(evt.getFilter());
    }

    @EventSubscriber(eventClass=UserDefinedFileFilterDeletedEvent.class)
    public void userDefinedFileFilterDeleted(UserDefinedFileFilterDeletedEvent evt) {
        this.deleteFilter(evt.getFilter());
    }

    @EventSubscriber(eventClass=UserDefinedFileFilterUpdatedEvent.class)
    public void userDefinedFileFilterUpdated(UserDefinedFileFilterUpdatedEvent evt) {
        this.updateFilter(evt.getFilter());
    }

    @EventSubscriber(eventClass=UserDefinedFileTypeInsertedEvent.class)
    public void userDefinedFileTypeUpdated(UserDefinedFileTypeInsertedEvent evt) {
        this.replaceUserDefinedFileTypesFilter();
    }

    @EventSubscriber(eventClass=UserDefinedFileTypeUpdatedEvent.class)
    public void userDefinedFileTypeUpdated(UserDefinedFileTypeUpdatedEvent evt) {
        this.replaceUserDefinedFileTypesFilter();
    }

    @EventSubscriber(eventClass=UserDefinedFileTypeDeletedEvent.class)
    public void userDefinedFileTypeUpdated(UserDefinedFileTypeDeletedEvent evt) {
        this.replaceUserDefinedFileTypesFilter();
    }

    private void replaceUserDefinedFileTypesFilter() {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                int index = FileFiltersComboBoxModel.this.userDefinedFileTypesFilter == null ? -1 : FileFiltersComboBoxModel.this.getIndexOf(FileFiltersComboBoxModel.this.userDefinedFileTypesFilter);
                RegexFileFilter newUserDefinedFileTypesFilter = AppFileFilters.INSTANCE.createUserDefinedFileFilter();
                if (index >= 0) {
                    if (newUserDefinedFileTypesFilter == null) {
                        FileFiltersComboBoxModel.this.removeElementAt(index);
                    } else {
                        FileFiltersComboBoxModel.this.userDefinedFileTypesFilter.set(newUserDefinedFileTypesFilter);
                    }
                    FileFiltersComboBoxModel.this.fireContentsChanged(this, index, index);
                } else if (newUserDefinedFileTypesFilter != null) {
                    FileFiltersComboBoxModel.this.userDefinedFileTypesFilter = newUserDefinedFileTypesFilter;
                    FileFiltersComboBoxModel.this.addElement(FileFiltersComboBoxModel.this.userDefinedFileTypesFilter);
                }
                index = FileFiltersComboBoxModel.this.getIndexOf(FileFiltersComboBoxModel.this.allAcceptedFileImageFilesFilter);
                FileFiltersComboBoxModel.this.allAcceptedFileImageFilesFilter.set(AppFileFilters.INSTANCE.createAllAcceptedImagesFileFilter());
                FileFiltersComboBoxModel.this.fireContentsChanged(this, index, index);
            }
        });
    }
}

