/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.jphototagger.api.component.Selectable;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.thumbnails.ThumbnailFlag;
import org.jphototagger.domain.thumbnails.ThumbnailsDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

final class DisplaySidecarFlagAction
extends AbstractAction
implements Selectable {
    private static final long serialVersionUID = 1L;
    private static final String PREF_KEY_SELECTED = "DisplaySidecarFlagAction.Selected";
    private boolean selected = this.getSelectedFromThumbnailsDisplayer();

    DisplaySidecarFlagAction() {
        super(Bundle.getString(DisplaySidecarFlagAction.class, "DisplaySidecarFlagAction.Name", new Object[0]));
        this.setSelectedKey();
        this.restore();
    }

    private void setSelectedKey() {
        this.putValue("SwingSelectedKey", this.selected ? Boolean.TRUE : null);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.toggleMetaDataOverlay();
        this.persist();
    }

    private void toggleMetaDataOverlay() {
        ThumbnailsDisplayer thumbnailsDisplayer = Lookup.getDefault().lookup(ThumbnailsDisplayer.class);
        boolean isDisplay = !thumbnailsDisplayer.isDisplayFlag(ThumbnailFlag.HAS_SIDECAR_FILE);
        thumbnailsDisplayer.setDisplayFlag(ThumbnailFlag.HAS_SIDECAR_FILE, isDisplay);
        this.selected = isDisplay;
        this.setSelectedKey();
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
        this.setSelectedKey();
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    private boolean getSelectedFromThumbnailsDisplayer() {
        ThumbnailsDisplayer thumbnailsDisplayer = Lookup.getDefault().lookup(ThumbnailsDisplayer.class);
        return thumbnailsDisplayer == null ? false : thumbnailsDisplayer.isDisplayFlag(ThumbnailFlag.HAS_SIDECAR_FILE);
    }

    private void persist() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setBoolean(PREF_KEY_SELECTED, this.isSelected());
    }

    private void restore() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        if (prefs.containsKey(PREF_KEY_SELECTED)) {
            ThumbnailsDisplayer thumbnailsDisplayer = Lookup.getDefault().lookup(ThumbnailsDisplayer.class);
            boolean sel = prefs.getBoolean(PREF_KEY_SELECTED);
            this.setSelected(sel);
            thumbnailsDisplayer.setDisplayFlag(ThumbnailFlag.HAS_SIDECAR_FILE, sel);
        }
    }
}

