/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JMenuItem;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.domain.metadata.SelectedFilesMetaDataEditor;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.thumbnails.event.ThumbnailsSelectionChangedEvent;
import org.jphototagger.lib.swing.KeyEventUtil;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.thumbnails.ThumbnailsPopupMenu;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class CopyPasteMetadataController
implements ActionListener,
KeyListener {
    private Xmp xmp;

    public CopyPasteMetadataController() {
        this.listen();
    }

    private void listen() {
        this.getCopyItem().addActionListener(this);
        this.getPasteItem().addActionListener(this);
        GUI.getThumbnailsPanel().addKeyListener(this);
        AnnotationProcessor.process(this);
    }

    private JMenuItem getCopyItem() {
        return ThumbnailsPopupMenu.INSTANCE.getItemCopyMetadata();
    }

    private JMenuItem getPasteItem() {
        return ThumbnailsPopupMenu.INSTANCE.getItemPasteMetadata();
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        if (KeyEventUtil.isMenuShortcutWithShiftDown(evt, 67)) {
            this.copy();
        } else if (KeyEventUtil.isMenuShortcutWithShiftDown(evt, 86)) {
            this.paste();
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.getCopyItem()) {
            this.copy();
        } else if (evt.getSource() == this.getPasteItem()) {
            this.paste();
        }
    }

    private void copy() {
        SelectedFilesMetaDataEditor editor = Lookup.getDefault().lookup(SelectedFilesMetaDataEditor.class);
        Xmp xmpOfEditPanel = editor.createXmpFromInput();
        this.xmp = new Xmp(xmpOfEditPanel);
        this.setPasteItemEnabled(true);
    }

    private void paste() {
        if (this.xmp == null) {
            return;
        }
        SelectedFilesMetaDataEditor editor = Lookup.getDefault().lookup(SelectedFilesMetaDataEditor.class);
        if (!this.checkSelected() || !this.checkCanEdit(editor)) {
            return;
        }
        editor.setXmp(this.xmp);
        this.setPasteItemEnabled(false);
        this.xmp = null;
    }

    private void setPasteItemEnabled(boolean enabled) {
        JMenuItem pasteItem = this.getPasteItem();
        pasteItem.setEnabled(enabled);
    }

    private boolean checkSelected() {
        int selCount = GUI.getThumbnailsPanel().getSelectionCount();
        if (selCount <= 0) {
            String message = Bundle.getString(CopyPasteMetadataController.class, "CopyPasteMetadataController.Error.NoSelection", new Object[0]);
            MessageDisplayer.error(null, message);
            return false;
        }
        return true;
    }

    private boolean checkCanEdit(SelectedFilesMetaDataEditor editor) {
        if (!editor.isEditable()) {
            String message = Bundle.getString(CopyPasteMetadataController.class, "CopyPasteMetadataController.Error.NotEditable", new Object[0]);
            MessageDisplayer.error(null, message);
            return false;
        }
        return true;
    }

    @EventSubscriber(eventClass=ThumbnailsSelectionChangedEvent.class)
    public void thumbnailsSelectionChanged(ThumbnailsSelectionChangedEvent evt) {
        boolean aFileIsSelected = evt.isAFileSelected();
        JMenuItem copyItem = this.getCopyItem();
        copyItem.setEnabled(aFileIsSelected);
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }
}

