/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.thumbnails;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JMenuItem;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.domain.thumbnails.event.ThumbnailsSelectionChangedEvent;
import org.jphototagger.lib.swing.KeyEventUtil;
import org.jphototagger.lib.util.ClipboardUtil;
import org.jphototagger.program.module.thumbnails.ThumbnailsPanel;
import org.jphototagger.program.module.thumbnails.ThumbnailsPopupMenu;
import org.jphototagger.program.resource.GUI;
import org.jphototagger.program.types.FileAction;

public final class CopyOrCutFilesToClipboardController
implements ActionListener,
KeyListener {
    private final ThumbnailsPanel tnPanel = GUI.getThumbnailsPanel();
    private final ThumbnailsPopupMenu popup = ThumbnailsPopupMenu.INSTANCE;

    public CopyOrCutFilesToClipboardController() {
        this.listen();
    }

    private void listen() {
        this.getCopyItem().addActionListener(this);
        this.getCutItem().addActionListener(this);
        this.tnPanel.addKeyListener(this);
        AnnotationProcessor.process(this);
    }

    private JMenuItem getCopyItem() {
        return ThumbnailsPopupMenu.INSTANCE.getItemCopyToClipboard();
    }

    private JMenuItem getCutItem() {
        return ThumbnailsPopupMenu.INSTANCE.getItemCutToClipboard();
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        if (!this.tnPanel.isAFileSelected()) {
            return;
        }
        if (KeyEventUtil.isMenuShortcut(evt, 67)) {
            this.perform(FileAction.COPY);
        } else if (KeyEventUtil.isMenuShortcut(evt, 88)) {
            this.perform(FileAction.CUT);
        }
    }

    private void perform(FileAction fa) {
        this.tnPanel.setFileAction(fa);
        this.transferSelectedFiles();
        this.popup.getItemPasteFromClipboard().setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.tnPanel.isAFileSelected()) {
            this.setFileAction(evt.getSource());
            this.transferSelectedFiles();
            this.popup.getItemPasteFromClipboard().setEnabled(true);
        }
    }

    public void setFileAction(Object source) {
        if (source == this.getCopyItem()) {
            this.tnPanel.setFileAction(FileAction.COPY);
        } else if (source == this.getCutItem()) {
            this.tnPanel.setFileAction(FileAction.CUT);
        } else assert (false) : "Invalid source: " + source;
    }

    private void transferSelectedFiles() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        ClipboardUtil.copyToClipboard(this.tnPanel.getSelectedFiles(), clipboard, null);
    }

    @EventSubscriber(eventClass=ThumbnailsSelectionChangedEvent.class)
    public void thumbnailsSelectionChanged(ThumbnailsSelectionChangedEvent evt) {
        boolean imagesSelected = evt.isAFileSelected();
        this.getCopyItem().setEnabled(imagesSelected);
        this.getCutItem().setEnabled(imagesSelected);
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }
}

