/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.search;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.MetaDataValueIds;
import org.jphototagger.domain.metadata.exif.ExifDateTimeOriginalMetaDataValue;
import org.jphototagger.domain.metadata.search.AdvancedSearchMetaDataValues;
import org.jphototagger.domain.metadata.search.Comparator;
import org.jphototagger.domain.metadata.search.Operator;
import org.jphototagger.domain.metadata.search.SavedSearchPanel;
import org.jphototagger.domain.metadata.xmp.XmpIptc4XmpCoreDateCreatedMetaDataValue;
import org.jphototagger.lib.thirdparty.DateChooserDialog;
import org.jphototagger.program.app.ui.AppLookAndFeel;
import org.jphototagger.program.datatransfer.DropTextComponentTransferHandler;

public final class SearchMetaDataValuePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String SEL_LEFT_BRACKET = "<html><font color=\"#000000\"><b>(</b></font></html>";
    private static final String NOT_SEL_LEFT_BRACKET = "<html><font color=\"#777777\"><b>(</b></font></html>";
    private static final String SEL_RIGHT_BRACKET = "<html><font color=\"#000000\"><b>)</b></font></html>";
    private static final String NOT_SEL_RIGHT_BRACKET = "<html><font color=\"#777777\"><b>)</b></font></html>";
    private MetaDataValue.ValueType prevColumnDataType;
    private boolean isOperatorsEnabled = true;
    private boolean listenToActions = true;
    private boolean changed;
    private final ListCellRenderer<Object> columnRenderer = new DefaultListCellRenderer(){
        private static final long serialVersionUID = 1L;

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            MetaDataValue metaDataValue = (MetaDataValue)value;
            label.setIcon(metaDataValue.getCategoryIcon());
            label.setText(metaDataValue.getDescription());
            return label;
        }
    };
    private JButton buttonCalendar;
    public JButton buttonRemoveColumn;
    private JComboBox<Object> comboBoxColumns;
    private JComboBox<Object> comboBoxComparators;
    private JComboBox<Object> comboBoxOperators;
    private JFormattedTextField textFieldValue;
    private JToggleButton toggleButtonBracketLeft1;
    private JToggleButton toggleButtonBracketLeft2;
    private JToggleButton toggleButtonBracketRight;

    public SearchMetaDataValuePanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.setComboboxSelIndices();
        this.setFormatter();
        this.setToggleButtonsTexts(this.toggleButtonBracketLeft1, true);
        this.setToggleButtonsTexts(this.toggleButtonBracketLeft2, true);
        this.setToggleButtonsTexts(this.toggleButtonBracketRight, false);
    }

    public void reset() {
        this.listenToActions = false;
        this.toggleButtonBracketLeft1.setSelected(false);
        this.toggleButtonBracketLeft2.setSelected(false);
        this.toggleButtonBracketRight.setSelected(false);
        this.comboBoxColumns.setSelectedIndex(0);
        this.comboBoxComparators.setSelectedIndex(0);
        this.comboBoxOperators.setSelectedIndex(0);
        this.textFieldValue.setText("");
        this.setChanged(false);
        this.setFormatter();
        this.setInputVerifier();
        this.listenToActions = true;
    }

    private void setFormatter() {
        String value = this.textFieldValue.getText();
        MetaDataValue column = this.getColumn();
        MetaDataValue.ValueType columnDataType = column.getValueType();
        this.textFieldValue.setFormatterFactory(column.getFormatterFactory());
        if (columnDataType.equals((Object)this.prevColumnDataType) && !value.isEmpty()) {
            this.textFieldValue.setText(value);
        }
        this.prevColumnDataType = column.getValueType();
    }

    private void setInputVerifier() {
        this.textFieldValue.setInputVerifier(this.getColumn().getInputVerifier());
    }

    private MetaDataValue getColumn() {
        return (MetaDataValue)this.comboBoxColumns.getSelectedItem();
    }

    private void checkToggleButtons() {
        if (this.toggleButtonBracketLeft2.isSelected()) {
            this.toggleButtonBracketLeft1.setSelected(false);
        }
        if (this.toggleButtonBracketLeft1.isSelected()) {
            this.toggleButtonBracketLeft2.setSelected(false);
        }
        this.toggleButtonBracketLeft1.setEnabled(this.isOperatorsEnabled && !this.toggleButtonBracketLeft2.isSelected());
        this.toggleButtonBracketLeft2.setEnabled(!this.toggleButtonBracketLeft1.isSelected());
        this.setToggleButtonsText();
    }

    private void setToggleButtonsText() {
        this.setToggleButtonsTexts(this.toggleButtonBracketLeft1, true);
        this.setToggleButtonsTexts(this.toggleButtonBracketLeft2, true);
        this.setToggleButtonsTexts(this.toggleButtonBracketRight, false);
    }

    private void setToggleButtonsTexts(JToggleButton tb, boolean left) {
        boolean right;
        boolean sel = tb.isSelected();
        boolean bl = right = !left;
        tb.setText(left && sel ? SEL_LEFT_BRACKET : (left && !sel ? NOT_SEL_LEFT_BRACKET : (right && sel ? SEL_RIGHT_BRACKET : NOT_SEL_RIGHT_BRACKET)));
    }

    private void setComboboxSelIndices() {
        this.listenToActions = false;
        this.comboBoxOperators.setSelectedIndex(0);
        this.comboBoxColumns.setSelectedIndex(0);
        this.comboBoxComparators.setSelectedIndex(0);
        this.listenToActions = true;
    }

    public JTextField getTextFieldValue() {
        return this.textFieldValue;
    }

    public int getCountOpenBrackets() {
        int count = 0;
        if (this.toggleButtonBracketLeft1.isSelected()) {
            ++count;
        }
        if (this.toggleButtonBracketLeft2.isSelected()) {
            ++count;
        }
        return count;
    }

    public int getCountClosedBrackets() {
        int count = 0;
        if (this.toggleButtonBracketRight.isSelected()) {
            ++count;
        }
        return count;
    }

    public boolean canCreateSql() {
        return this.comboBoxOperators.getModel().getSelectedItem() != null && this.comboBoxColumns.getModel().getSelectedItem() != null && this.comboBoxComparators.getModel().getSelectedItem() != null && !this.textFieldValue.getText().trim().isEmpty();
    }

    public String getValue() {
        return this.textFieldValue.getText();
    }

    public SavedSearchPanel getSavedSearchPanel() {
        this.listenToActions = false;
        SavedSearchPanel savedSearchPanel = new SavedSearchPanel();
        savedSearchPanel.setBracketRightSelected(this.toggleButtonBracketRight.isSelected());
        savedSearchPanel.setColumnId(MetaDataValueIds.getId((MetaDataValue)this.comboBoxColumns.getModel().getSelectedItem()));
        savedSearchPanel.setComparatorId(((Comparator)((Object)this.comboBoxComparators.getModel().getSelectedItem())).getId());
        savedSearchPanel.setBracketLeft1Selected(this.toggleButtonBracketLeft1.isSelected());
        savedSearchPanel.setBracketLeft2Selected(this.toggleButtonBracketLeft2.isSelected());
        savedSearchPanel.setOperatorId(((Operator)((Object)this.comboBoxOperators.getModel().getSelectedItem())).getId());
        String value = this.textFieldValue.getText();
        savedSearchPanel.setValue(value.isEmpty() ? null : value);
        this.listenToActions = true;
        return savedSearchPanel;
    }

    public void setSavedSearchPanel(SavedSearchPanel savedSearchPanel) {
        if (savedSearchPanel == null) {
            throw new NullPointerException("savedSearchPanel == null");
        }
        this.listenToActions = false;
        this.toggleButtonBracketRight.setSelected(savedSearchPanel.isBracketRightSelected());
        this.comboBoxColumns.getModel().setSelectedItem(MetaDataValueIds.getMetaDataValue(savedSearchPanel.getColumnId()));
        this.comboBoxComparators.getModel().setSelectedItem((Object)Comparator.get(savedSearchPanel.getComparatorId()));
        this.toggleButtonBracketLeft1.setSelected(savedSearchPanel.isBracketLeft1Selected());
        this.toggleButtonBracketLeft2.setSelected(savedSearchPanel.isBracketLeft2Selected());
        this.comboBoxOperators.getModel().setSelectedItem((Object)Operator.get(savedSearchPanel.getOperatorId()));
        if (savedSearchPanel.hasValue()) {
            this.textFieldValue.setText(savedSearchPanel.getValue());
        }
        this.setToggleButtonsText();
        this.listenToActions = true;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public boolean isChanged() {
        return this.changed;
    }

    private void setDate() {
        GregorianCalendar cal = DateChooserDialog.showDialog(this, AppLookAndFeel.getAppIcons());
        if (cal != null) {
            String year = Integer.toString(cal.get(1));
            String month = this.getDateFormatted(Integer.toString(cal.get(2)));
            String day = this.getDateFormatted(Integer.toString(cal.get(5)));
            this.textFieldValue.setText(year + "-" + month + "-" + day);
            this.setChanged(true);
        }
    }

    private String getDateFormatted(String dayOrMonth) {
        if (dayOrMonth.length() < 2) {
            return "0" + dayOrMonth;
        }
        return dayOrMonth;
    }

    private void setChanged() {
        if (this.listenToActions) {
            this.setChanged(true);
        }
    }

    private void handleButtonCalendarActionPerformed() {
        if (this.listenToActions) {
            this.setDate();
        }
    }

    private void handleTaggleButtonBracketLeft2ActionPerformed() {
        this.setToggleButtonsTexts(this.toggleButtonBracketLeft2, true);
        if (this.listenToActions) {
            this.checkToggleButtons();
            this.setChanged(true);
        }
    }

    private void handleTaggleButtonBracketLeftActionPerformed() {
        this.setToggleButtonsTexts(this.toggleButtonBracketLeft1, true);
        if (this.listenToActions) {
            this.checkToggleButtons();
            this.setChanged(true);
        }
    }

    private void handleTextFieldValueKeyTyped(KeyEvent evt) {
        if (this.listenToActions) {
            this.setChanged(true);
        }
    }

    private void handleColumnChanged() {
        this.setChanged();
        this.setFormatter();
        this.setInputVerifier();
        this.setEnabledCalendarButton();
    }

    private void setEnabledCalendarButton() {
        Object selItem = this.comboBoxColumns.getModel().getSelectedItem();
        this.buttonCalendar.setEnabled(selItem.equals(ExifDateTimeOriginalMetaDataValue.INSTANCE) || selItem.equals(XmpIptc4XmpCoreDateCreatedMetaDataValue.INSTANCE));
    }

    private void initComponents() {
        this.toggleButtonBracketLeft1 = new JToggleButton();
        this.comboBoxOperators = new JComboBox();
        this.toggleButtonBracketLeft2 = new JToggleButton();
        this.comboBoxColumns = new JComboBox();
        this.comboBoxComparators = new JComboBox();
        this.textFieldValue = new JFormattedTextField();
        this.textFieldValue.setTransferHandler(new DropTextComponentTransferHandler());
        this.toggleButtonBracketRight = new JToggleButton();
        this.buttonCalendar = new JButton();
        this.buttonRemoveColumn = new JButton();
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.toggleButtonBracketLeft1.setText("(");
        this.toggleButtonBracketLeft1.setMargin(new Insets(2, 2, 2, 2));
        this.toggleButtonBracketLeft1.setName("toggleButtonBracketLeft1");
        this.toggleButtonBracketLeft1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchMetaDataValuePanel.this.toggleButtonBracketLeft1ActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.toggleButtonBracketLeft1, gridBagConstraints);
        this.comboBoxOperators.setModel(new DefaultComboBoxModel<Operator>(Operator.values()));
        this.comboBoxOperators.setName("comboBoxOperators");
        this.comboBoxOperators.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchMetaDataValuePanel.this.comboBoxOperatorsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add(this.comboBoxOperators, gridBagConstraints);
        this.toggleButtonBracketLeft2.setText("(");
        this.toggleButtonBracketLeft2.setMargin(new Insets(2, 2, 2, 2));
        this.toggleButtonBracketLeft2.setName("toggleButtonBracketLeft2");
        this.toggleButtonBracketLeft2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchMetaDataValuePanel.this.toggleButtonBracketLeft2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.toggleButtonBracketLeft2, gridBagConstraints);
        this.comboBoxColumns.setModel(new DefaultComboBoxModel<Object>(AdvancedSearchMetaDataValues.get().toArray()));
        this.comboBoxColumns.setName("comboBoxColumns");
        this.comboBoxColumns.setRenderer(this.columnRenderer);
        this.comboBoxColumns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchMetaDataValuePanel.this.comboBoxColumnsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add(this.comboBoxColumns, gridBagConstraints);
        this.comboBoxComparators.setModel(new DefaultComboBoxModel<Comparator>(Comparator.values()));
        this.comboBoxComparators.setName("comboBoxComparators");
        this.comboBoxComparators.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchMetaDataValuePanel.this.comboBoxComparatorsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add(this.comboBoxComparators, gridBagConstraints);
        this.textFieldValue.setColumns(10);
        this.textFieldValue.setFocusLostBehavior(3);
        this.textFieldValue.setName("textFieldValue");
        this.textFieldValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                SearchMetaDataValuePanel.this.textFieldValueKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.textFieldValue, gridBagConstraints);
        this.toggleButtonBracketRight.setText(")");
        this.toggleButtonBracketRight.setMargin(new Insets(2, 2, 2, 2));
        this.toggleButtonBracketRight.setName("toggleButtonBracketRight");
        this.toggleButtonBracketRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchMetaDataValuePanel.this.toggleButtonBracketRightActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.toggleButtonBracketRight, gridBagConstraints);
        this.buttonCalendar.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_calendar.png")));
        this.buttonCalendar.setMnemonic('1');
        this.buttonCalendar.setMargin(new Insets(0, 0, 0, 0));
        this.buttonCalendar.setMaximumSize(new Dimension(16, 16));
        this.buttonCalendar.setMinimumSize(new Dimension(16, 16));
        this.buttonCalendar.setName("buttonCalendar");
        this.buttonCalendar.setPreferredSize(new Dimension(16, 16));
        this.buttonCalendar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchMetaDataValuePanel.this.buttonCalendarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.buttonCalendar, gridBagConstraints);
        this.buttonRemoveColumn.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_delete12.png")));
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/search/Bundle");
        this.buttonRemoveColumn.setToolTipText(bundle.getString("SearchMetaDataValuePanel.buttonRemoveColumn.toolTipText"));
        this.buttonRemoveColumn.setMargin(new Insets(2, 2, 2, 2));
        this.buttonRemoveColumn.setMaximumSize(new Dimension(16, 16));
        this.buttonRemoveColumn.setMinimumSize(new Dimension(16, 16));
        this.buttonRemoveColumn.setName("buttonRemoveColumn");
        this.buttonRemoveColumn.setPreferredSize(new Dimension(16, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.buttonRemoveColumn, gridBagConstraints);
    }

    private void toggleButtonBracketLeft1ActionPerformed(ActionEvent evt) {
        this.handleTaggleButtonBracketLeftActionPerformed();
    }

    private void toggleButtonBracketLeft2ActionPerformed(ActionEvent evt) {
        this.handleTaggleButtonBracketLeft2ActionPerformed();
    }

    private void buttonCalendarActionPerformed(ActionEvent evt) {
        this.handleButtonCalendarActionPerformed();
    }

    private void comboBoxOperatorsActionPerformed(ActionEvent evt) {
        this.setChanged();
    }

    private void comboBoxColumnsActionPerformed(ActionEvent evt) {
        this.handleColumnChanged();
    }

    private void comboBoxComparatorsActionPerformed(ActionEvent evt) {
        this.setChanged();
    }

    private void toggleButtonBracketRightActionPerformed(ActionEvent evt) {
        this.setToggleButtonsTexts(this.toggleButtonBracketRight, false);
        this.setChanged();
    }

    private void textFieldValueKeyTyped(KeyEvent evt) {
        this.handleTextFieldValueKeyTyped(evt);
    }
}

