/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.search;

import javax.swing.DefaultListModel;
import org.jphototagger.domain.metadata.search.SavedSearch;
import org.jphototagger.domain.repository.SavedSearchesRepository;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public final class SavedSearchesUtil {
    public static void focusAppPanelList() {
        GUI.getAppPanel().getListSavedSearches().requestFocus();
    }

    public static int getIndexOfSavedSearch(DefaultListModel<?> model, String name) {
        if (model == null) {
            throw new NullPointerException("model == null");
        }
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        int size = model.size();
        for (int i = 0; i < size; ++i) {
            SavedSearch savedSearch;
            Object element = model.get(i);
            if (!(element instanceof SavedSearch) || !(savedSearch = (SavedSearch)element).getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public static boolean insert(SavedSearch savedSearch) {
        if (savedSearch == null) {
            throw new NullPointerException("savedSearch == null");
        }
        if (SavedSearchesUtil.ensureNotOverwrite(savedSearch.getName())) {
            SavedSearchesRepository repo = Lookup.getDefault().lookup(SavedSearchesRepository.class);
            if (repo.saveSavedSearch(savedSearch)) {
                return true;
            }
            String message = Bundle.getString(SavedSearchesUtil.class, "SavedSearchesHelper.Error.Insert", savedSearch);
            MessageDisplayer.error(null, message);
        }
        return false;
    }

    public static boolean update(SavedSearch savedSearch) {
        if (savedSearch == null) {
            throw new NullPointerException("savedSearch == null");
        }
        SavedSearchesRepository repo = Lookup.getDefault().lookup(SavedSearchesRepository.class);
        if (repo.updateSavedSearch(savedSearch)) {
            return true;
        }
        String message = Bundle.getString(SavedSearchesUtil.class, "SavedSearchesHelper.Error.Update", savedSearch);
        MessageDisplayer.error(null, message);
        return false;
    }

    public static void delete(SavedSearch savedSearch) {
        SavedSearchesRepository repo;
        if (savedSearch == null) {
            throw new NullPointerException("savedSearch == null");
        }
        String searchName = savedSearch.getName();
        if (SavedSearchesUtil.confirmDelete(searchName) && !(repo = Lookup.getDefault().lookup(SavedSearchesRepository.class)).deleteSavedSearch(searchName)) {
            String message = Bundle.getString(SavedSearchesUtil.class, "SavedSearchesHelper.Error.Delete", new Object[0]);
            MessageDisplayer.error(null, message);
        }
    }

    public static void rename(SavedSearch savedSearch) {
        SavedSearchesRepository repo;
        if (savedSearch == null) {
            throw new NullPointerException("oldSearch == null");
        }
        if (!savedSearch.isValid()) {
            assert (false) : savedSearch;
            return;
        }
        String fromName = savedSearch.getName();
        String toName = SavedSearchesUtil.getNotExistingName(fromName);
        if (toName != null && !(repo = Lookup.getDefault().lookup(SavedSearchesRepository.class)).updateRenameSavedSearch(fromName, toName)) {
            String message = Bundle.getString(SavedSearchesUtil.class, "SavedSearchesHelper.Error.Rename", fromName);
            MessageDisplayer.error(null, message);
        }
    }

    public static String getNotExistingName(String suggestName) {
        if (suggestName == null) {
            throw new NullPointerException("suggestName == null");
        }
        boolean wantInput = true;
        String input = null;
        String suggest = suggestName;
        SavedSearchesRepository repo = Lookup.getDefault().lookup(SavedSearchesRepository.class);
        while (wantInput) {
            wantInput = false;
            input = SavedSearchesUtil.getInput(suggest);
            if (input == null || !repo.existsSavedSearch(input)) continue;
            wantInput = SavedSearchesUtil.confirmInputNotExistingName(input);
            if (wantInput) {
                suggest = input;
            }
            input = null;
        }
        return input;
    }

    private static String getInput(String fromName) {
        String info = Bundle.getString(SavedSearchesUtil.class, "SavedSearchesHelper.Input.NewName", new Object[0]);
        String input = fromName;
        return MessageDisplayer.input(info, input);
    }

    private static boolean confirmInputNotExistingName(String input) {
        String message = Bundle.getString(SavedSearchesUtil.class, "SavedSearchesHelper.Confirm.InputDifferentName", input);
        return MessageDisplayer.confirmYesNo(null, message);
    }

    private static boolean confirmDelete(String name) {
        String message = Bundle.getString(SavedSearchesUtil.class, "SavedSearchesHelper.Confirm.Delete", name);
        return MessageDisplayer.confirmYesNo(null, message);
    }

    private static boolean ensureNotOverwrite(String name) {
        SavedSearchesRepository repo = Lookup.getDefault().lookup(SavedSearchesRepository.class);
        if (repo.existsSavedSearch(name)) {
            String message = Bundle.getString(SavedSearchesUtil.class, "SavedSearchesHelper.Error.Exists", name);
            MessageDisplayer.error(null, message);
            return false;
        }
        return true;
    }

    private SavedSearchesUtil() {
    }
}

