/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.search;

import java.util.List;
import javax.swing.DefaultListModel;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.domain.metadata.search.SavedSearch;
import org.jphototagger.domain.repository.Repository;
import org.jphototagger.domain.repository.SavedSearchesRepository;
import org.jphototagger.domain.repository.event.search.SavedSearchDeletedEvent;
import org.jphototagger.domain.repository.event.search.SavedSearchInsertedEvent;
import org.jphototagger.domain.repository.event.search.SavedSearchRenamedEvent;
import org.jphototagger.domain.repository.event.search.SavedSearchUpdatedEvent;
import org.jphototagger.program.module.search.SavedSearchesUtil;
import org.openide.util.Lookup;

public final class SavedSearchesListModel
extends DefaultListModel<Object> {
    private static final long serialVersionUID = 1L;
    private final SavedSearchesRepository savedSearchRepo = Lookup.getDefault().lookup(SavedSearchesRepository.class);

    public SavedSearchesListModel() {
        this.addElements();
        this.listen();
    }

    private void listen() {
        AnnotationProcessor.process(this);
    }

    private void addElements() {
        Repository repo = Lookup.getDefault().lookup(Repository.class);
        if (repo == null || !repo.isInit()) {
            return;
        }
        List<SavedSearch> savedSearches = this.savedSearchRepo.findAllSavedSearches();
        for (SavedSearch savedSearch : savedSearches) {
            this.addElement(savedSearch);
        }
    }

    private void insertSavedSearch(SavedSearch search) {
        if (!this.contains(search)) {
            this.addElement(search);
        }
    }

    private void deleteSearch(String name) {
        int index = SavedSearchesUtil.getIndexOfSavedSearch(this, name);
        if (index >= 0) {
            this.remove(index);
        }
    }

    private void renameSearch(String fromName, String toName) {
        int index = SavedSearchesUtil.getIndexOfSavedSearch(this, fromName);
        if (index >= 0) {
            SavedSearch savedSearch = (SavedSearch)this.get(index);
            savedSearch.setName(toName);
            this.fireContentsChanged(this, index, index);
        }
    }

    private void insertSearch(SavedSearch savedSearch) {
        this.insertSavedSearch(savedSearch);
    }

    private void updateSearch(SavedSearch savedSearch) {
        int index = this.indexOf(savedSearch);
        if (index >= 0) {
            this.set(index, savedSearch);
        } else {
            this.insertSavedSearch(savedSearch);
        }
    }

    @EventSubscriber(eventClass=SavedSearchInsertedEvent.class)
    public void searchInserted(SavedSearchInsertedEvent evt) {
        this.insertSearch(evt.getSavedSearch());
    }

    @EventSubscriber(eventClass=SavedSearchUpdatedEvent.class)
    public void searchUpdated(SavedSearchUpdatedEvent evt) {
        this.updateSearch(evt.getSavedSearch());
    }

    @EventSubscriber(eventClass=SavedSearchDeletedEvent.class)
    public void searchDeleted(SavedSearchDeletedEvent evt) {
        this.deleteSearch(evt.getSearchName());
    }

    @EventSubscriber(eventClass=SavedSearchRenamedEvent.class)
    public void searchRenamed(SavedSearchRenamedEvent evt) {
        String fromName = evt.getFromName();
        String toName = evt.getToName();
        this.renameSearch(fromName, toName);
    }
}

