/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.preferences.PreferencesChangedEvent;
import org.jphototagger.api.windows.MainWindowManager;
import org.jphototagger.api.windows.WaitDisplayer;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.search.SearchComponent;
import org.jphototagger.domain.metadata.selections.AutoCompleteDataOfMetaDataValue;
import org.jphototagger.domain.metadata.selections.FastSearchMetaDataValues;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpDcSubjectsSubjectMetaDataValue;
import org.jphototagger.domain.repository.FindRepository;
import org.jphototagger.domain.repository.ImageFilesRepository;
import org.jphototagger.domain.repository.event.xmp.XmpDeletedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpInsertedEvent;
import org.jphototagger.domain.repository.event.xmp.XmpUpdatedEvent;
import org.jphototagger.domain.thumbnails.OriginOfDisplayedThumbnails;
import org.jphototagger.domain.thumbnails.ThumbnailsDisplayer;
import org.jphototagger.domain.thumbnails.event.ThumbnailsChangedEvent;
import org.jphototagger.domain.thumbnails.event.ThumbnailsPanelRefreshEvent;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.swing.ImageTextArea;
import org.jphototagger.lib.swing.KeyEventUtil;
import org.jphototagger.lib.swing.util.Autocomplete;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.ListUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.swing.util.TreeUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.app.ui.AppLookAndFeel;
import org.jphototagger.program.misc.AutocompleteUtil;
import org.jphototagger.program.module.search.FastSearchComboBoxModel;
import org.jphototagger.program.module.search.FastSearchMetaDataValuesListCellRenderer;
import org.jphototagger.program.resource.GUI;
import org.openide.util.Lookup;

public class FastSearchPanel
extends JPanel
implements ActionListener,
SearchComponent {
    private static final long serialVersionUID = 1L;
    private static final String DELIMITER_SEARCH_WORDS = ";";
    private final Map<JTree, List<TreePath>> selectedTreePaths = new HashMap<JTree, List<TreePath>>();
    private final Map<JList<?>, List<?>> selectedListValues = new HashMap();
    private final ButtonRestoreDisabler buttonRestoreDisabler;
    private final FindRepository findRepo = Lookup.getDefault().lookup(FindRepository.class);
    private final SelectSearchTextAreaAction selectSearchTextAreaAction = new SelectSearchTextAreaAction();
    private final Autocomplete autocomplete;
    private boolean isAutocomplete;
    private JButton buttonRestoreSelection;
    private JComboBox<Object> fastSearchComboBox;
    private JButton searchButton;
    private JTextArea textAreaSearch;

    public FastSearchPanel() {
        this.initComponents();
        if (this.getPersistedAutocomplete()) {
            this.autocomplete = new Autocomplete(this.isAutocompleteFastSearchIgnoreCase());
            this.autocomplete.setTransferFocusForward(false);
        } else {
            this.autocomplete = null;
            this.isAutocomplete = false;
        }
        this.buttonRestoreDisabler = new ButtonRestoreDisabler();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.setAutocomplete(true);
        this.initTextArea();
        MnemonicUtil.setMnemonics(this);
        this.toggleDisplaySearchButton();
        this.listen();
    }

    private void initTextArea() {
        Border border = UIManager.getBorder("TextField.border");
        this.textAreaSearch.setBorder(border == null ? BorderFactory.createLineBorder(Color.BLACK) : border);
        Font font = UIManager.getFont("TextField.font");
        if (font != null) {
            this.textAreaSearch.setFont(font);
        }
    }

    private boolean isAutocompleteFastSearchIgnoreCase() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.Autocomplete.IgnoreCase") ? prefs.getBoolean("UserSettings.Autocomplete.IgnoreCase") : false;
    }

    private boolean getPersistedAutocomplete() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.EnableAutoComplete") ? prefs.getBoolean("UserSettings.EnableAutoComplete") : true;
    }

    private void listen() {
        AnnotationProcessor.process(this);
        this.textAreaSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    FastSearchPanel.this.search();
                }
            }
        });
        this.searchButton.addActionListener(this);
        this.fastSearchComboBox.addActionListener(this);
        AnnotationProcessor.process(this);
    }

    public void setAutocomplete(boolean ac) {
        if (this.autocomplete == null) {
            return;
        }
        this.isAutocomplete = ac;
        if (ac) {
            this.decorateTextFieldSearch();
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.isAutocomplete && evt.getSource() == this.fastSearchComboBox && this.fastSearchComboBox.getSelectedIndex() >= 0) {
            this.decorateTextFieldSearch();
        } else if (evt.getSource() == this.searchButton) {
            this.search();
        }
    }

    private void decorateTextFieldSearch() {
        if (this.autocomplete == null || !this.getPersistedAutocomplete()) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                FastSearchPanel.this.autocomplete.decorate(FastSearchPanel.this.textAreaSearch, FastSearchPanel.this.isSearchAllDefinedMetaDataValues() ? AutoCompleteDataOfMetaDataValue.INSTANCE.getFastSearchData().get() : AutoCompleteDataOfMetaDataValue.INSTANCE.get(FastSearchPanel.this.getSearchMetaDataValue()).get(), true);
            }
        }, "JPhotoTagger: Updating autocomplete for search text field").start();
    }

    private void clearSelection() {
        this.setSelectedTreePaths(TreeUtil.clearSelection(GUI.getAppPanel().getSelectionTrees()));
        this.setSelectedListValues(ListUtil.clearSelection(GUI.getAppPanel().getSelectionLists()));
        this.buttonRestoreSelection.setEnabled(this.itemsWereSelected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean itemsWereSelected() {
        Map<JComponent, List<TreePath>> map = this.selectedTreePaths;
        synchronized (map) {
            if (!this.selectedTreePaths.isEmpty()) {
                return true;
            }
        }
        map = this.selectedListValues;
        synchronized (map) {
            if (!this.selectedListValues.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSelectedTreePaths(Map<JTree, List<TreePath>> selectedTreePaths) {
        Map<JTree, List<TreePath>> map = this.selectedTreePaths;
        synchronized (map) {
            this.selectedTreePaths.clear();
            this.selectedTreePaths.putAll(selectedTreePaths);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSelectedListValues(Map<JList<?>, List<?>> selectedListIndices) {
        Map<JList<?>, List<?>> map = this.selectedListValues;
        synchronized (map) {
            this.selectedListValues.clear();
            this.selectedListValues.putAll(selectedListIndices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreSelection() {
        Map<JComponent, List<TreePath>> map = this.selectedTreePaths;
        synchronized (map) {
            for (JTree jTree : this.selectedTreePaths.keySet()) {
                List<TreePath> paths = this.selectedTreePaths.get(jTree);
                jTree.setSelectionPaths(paths.toArray(new TreePath[paths.size()]));
            }
        }
        map = this.selectedListValues;
        synchronized (map) {
            for (JList jList : this.selectedListValues.keySet()) {
                ListUtil.setSelectedValues(jList, this.selectedListValues.get(jList));
            }
        }
    }

    private void search() {
        this.search(this.textAreaSearch.getText());
    }

    private void search(final String searchText) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){
            private final ImageFilesRepository imageFileRepo = Lookup.getDefault().lookup(ImageFilesRepository.class);

            @Override
            public void run() {
                String userInput = searchText.trim();
                if (!userInput.isEmpty()) {
                    WaitDisplayer waitDisplayer = Lookup.getDefault().lookup(WaitDisplayer.class);
                    waitDisplayer.show();
                    FastSearchPanel.this.clearSelection();
                    List<File> imageFiles = this.searchFiles(userInput);
                    if (imageFiles != null) {
                        this.setTitle(userInput);
                        ThumbnailsDisplayer tDisplayer = Lookup.getDefault().lookup(ThumbnailsDisplayer.class);
                        tDisplayer.displayFiles(imageFiles, OriginOfDisplayedThumbnails.FILES_FOUND_BY_FAST_SEARCH);
                    }
                    waitDisplayer.hide();
                }
            }

            private void setTitle(String userInput) {
                String title = Bundle.getString(FastSearchPanel.class, "FastSearchController.AppFrame.Title.FastSearch", userInput);
                MainWindowManager mainWindowManager = Lookup.getDefault().lookup(MainWindowManager.class);
                mainWindowManager.setMainWindowTitle(title);
            }

            private List<File> searchFiles(String userInput) {
                if (FastSearchPanel.this.isSearchAllDefinedMetaDataValues()) {
                    return FastSearchPanel.this.findRepo.findImageFilesLikeOr(FastSearchMetaDataValues.get(), userInput);
                }
                List searchWords = FastSearchPanel.this.getSearchWords(userInput);
                MetaDataValue searchValue = FastSearchPanel.this.getSearchMetaDataValue();
                if (searchValue == null) {
                    return null;
                }
                boolean isKeywordSearch = searchValue.equals(XmpDcSubjectsSubjectMetaDataValue.INSTANCE);
                if (searchWords.size() == 1) {
                    if (isKeywordSearch) {
                        return new ArrayList<File>(this.imageFileRepo.findImageFilesContainingDcSubject((String)searchWords.get(0), true));
                    }
                    return FastSearchPanel.this.findRepo.findImageFilesLikeOr(Arrays.asList(searchValue), userInput);
                }
                if (searchWords.size() > 1) {
                    if (isKeywordSearch) {
                        return new ArrayList<File>(this.imageFileRepo.findImageFilesContainingAllDcSubjects(searchWords));
                    }
                    return new ArrayList<File>(this.imageFileRepo.findImageFilesContainingAllWordsInMetaDataValue(searchWords, searchValue));
                }
                return null;
            }
        });
    }

    private List<String> getSearchWords(String userInput) {
        ArrayList<String> words = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(userInput, DELIMITER_SEARCH_WORDS);
        while (st.hasMoreTokens()) {
            words.add(st.nextToken().trim());
        }
        return words;
    }

    private MetaDataValue getSearchMetaDataValue() {
        assert (!this.isSearchAllDefinedMetaDataValues()) : "More than one search value!";
        if (this.isSearchAllDefinedMetaDataValues()) {
            return null;
        }
        return (MetaDataValue)this.fastSearchComboBox.getSelectedItem();
    }

    @EventSubscriber(eventClass=ThumbnailsPanelRefreshEvent.class)
    public void refresh(ThumbnailsPanelRefreshEvent evt) {
        OriginOfDisplayedThumbnails origin;
        if (this.textAreaSearch.isEnabled() && (origin = evt.getOriginOfDisplayedThumbnails()).isFilesFoundByFastSearch()) {
            this.search(this.textAreaSearch.getText());
        }
    }

    @EventSubscriber(eventClass=ThumbnailsChangedEvent.class)
    public void thumbnailsChanged(ThumbnailsChangedEvent evt) {
        OriginOfDisplayedThumbnails origin = evt.getOriginOfDisplayedThumbnails();
        if (!origin.isFilesFoundByFastSearch()) {
            this.textAreaSearch.setText("");
        }
    }

    private boolean isSearchAllDefinedMetaDataValues() {
        Object selItem = this.fastSearchComboBox.getSelectedItem();
        return selItem != null && selItem.equals("AllDefined");
    }

    private void addAutocompleteWordsOf(Xmp xmp) {
        if (!this.getPersistedAutocomplete()) {
            return;
        }
        if (this.isSearchAllDefinedMetaDataValues()) {
            AutocompleteUtil.addFastSearchAutocompleteData(this.autocomplete, xmp);
        } else {
            AutocompleteUtil.addAutocompleteData(this.getSearchMetaDataValue(), this.autocomplete, xmp);
        }
    }

    private boolean isAutocomplete() {
        return this.autocomplete != null && this.getPersistedAutocomplete();
    }

    @EventSubscriber(eventClass=XmpInsertedEvent.class)
    public void xmpInserted(XmpInsertedEvent evt) {
        this.addAutocompleteWordsOf(evt.getXmp());
    }

    @EventSubscriber(eventClass=XmpDeletedEvent.class)
    public void xmpDeleted(XmpDeletedEvent evt) {
        this.addAutocompleteWordsOf(evt.getXmp());
    }

    @EventSubscriber(eventClass=XmpUpdatedEvent.class)
    public void xmpUpdated(XmpUpdatedEvent evt) {
        this.addAutocompleteWordsOf(evt.getUpdatedXmp());
    }

    private boolean isDisplaySearchButton() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.DisplaySearchButton") ? prefs.getBoolean("UserSettings.DisplaySearchButton") : true;
    }

    @EventSubscriber(eventClass=PreferencesChangedEvent.class)
    public void userPropertyChanged(PreferencesChangedEvent evt) {
        String key = evt.getKey();
        if ("UserSettings.DisplaySearchButton".equals(key)) {
            this.toggleDisplaySearchButton();
        }
    }

    private void toggleDisplaySearchButton() {
        boolean toDo;
        int zOrder = this.getComponentZOrder(this.searchButton);
        boolean containsButton = zOrder >= 0;
        boolean displaySearchButton = this.isDisplaySearchButton();
        boolean bl = toDo = containsButton && !displaySearchButton || !containsButton && displaySearchButton;
        if (!toDo) {
            return;
        }
        if (displaySearchButton) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(3, 3, 0, 0);
            this.add((Component)this.searchButton, gbc);
        } else {
            this.remove(this.searchButton);
        }
        ComponentUtil.forceRepaint(this);
    }

    @Override
    public Action getSelectSearchComponentAction() {
        return this.selectSearchTextAreaAction;
    }

    @Override
    public Component getSearchComponent() {
        return this;
    }

    private void initComponents() {
        this.fastSearchComboBox = new JComboBox();
        this.textAreaSearch = new ImageTextArea();
        ((ImageTextArea)this.textAreaSearch).setImage(AppLookAndFeel.getLocalizedImage("/org/jphototagger/program/resource/images/textfield_search.png"));
        ((ImageTextArea)this.textAreaSearch).setConsumeEnter(true);
        this.searchButton = new JButton();
        this.buttonRestoreSelection = new JButton();
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.fastSearchComboBox.setModel(new FastSearchComboBoxModel());
        this.fastSearchComboBox.setName("fastSearchComboBox");
        this.fastSearchComboBox.setRenderer(new FastSearchMetaDataValuesListCellRenderer());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add(this.fastSearchComboBox, gridBagConstraints);
        this.textAreaSearch.setRows(1);
        this.textAreaSearch.setMinimumSize(new Dimension(0, 18));
        this.textAreaSearch.setName("textAreaSearch");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add((Component)this.textAreaSearch, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/search/Bundle");
        this.searchButton.setText(bundle.getString("FastSearchPanel.searchButton.text"));
        this.searchButton.setMargin(new Insets(1, 1, 1, 1));
        this.searchButton.setName("searchButton");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.add((Component)this.searchButton, gridBagConstraints);
        this.buttonRestoreSelection.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/program/resource/icons/icon_restore_selection.png")));
        this.buttonRestoreSelection.setToolTipText(bundle.getString("FastSearchPanel.buttonRestoreSelection.toolTipText"));
        this.buttonRestoreSelection.setEnabled(false);
        this.buttonRestoreSelection.setMargin(new Insets(0, 0, 0, 0));
        this.buttonRestoreSelection.setName("buttonRestoreSelection");
        this.buttonRestoreSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FastSearchPanel.this.buttonRestoreSelectionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.add((Component)this.buttonRestoreSelection, gridBagConstraints);
    }

    private void buttonRestoreSelectionActionPerformed(ActionEvent evt) {
        this.restoreSelection();
        this.setSelectedTreePaths(Collections.emptyMap());
        this.setSelectedListValues(Collections.emptyMap());
    }

    private final class ButtonRestoreDisabler
    implements ListSelectionListener,
    TreeSelectionListener {
        private ButtonRestoreDisabler() {
            for (JList jList : GUI.getAppPanel().getSelectionLists()) {
                jList.addListSelectionListener(this);
            }
            for (JTree jTree : GUI.getAppPanel().getSelectionTrees()) {
                jTree.addTreeSelectionListener(this);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting() && e.getFirstIndex() >= 0) {
                FastSearchPanel.this.buttonRestoreSelection.setEnabled(false);
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (e.isAddedPath()) {
                FastSearchPanel.this.buttonRestoreSelection.setEnabled(false);
            }
        }
    }

    private class SelectSearchTextAreaAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private SelectSearchTextAreaAction() {
            super(Bundle.getString(SelectSearchTextAreaAction.class, "SelectSearchTextAreaAction.Name", new Object[0]));
            this.putValue("SmallIcon", IconUtil.getImageIcon(SelectSearchTextAreaAction.class, "search.png"));
            this.putValue("AcceleratorKey", KeyEventUtil.getKeyStrokeMenuShortcut(70));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FastSearchPanel.this.textAreaSearch.requestFocusInWindow();
        }
    }
}

