/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.search;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.jdesktop.swingx.JXList;
import org.jphototagger.domain.metadata.search.SavedSearch;
import org.jphototagger.lib.swing.KeyEventUtil;
import org.jphototagger.lib.swing.MouseEventUtil;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.program.module.search.AdvancedSearchDialog;
import org.jphototagger.program.module.search.SavedSearchesPopupMenu;
import org.jphototagger.program.resource.GUI;

public final class EditSavedSearchController
implements ActionListener,
KeyListener {
    private final MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (MouseEventUtil.isDoubleClick(e)) {
                Object source = e.getSource();
                if (!(source instanceof JXList)) {
                    return;
                }
                JXList list = (JXList)source;
                int index = list.locationToIndex(e.getPoint());
                if (index >= 0) {
                    Object element = list.getElementAt(index);
                    if (!(element instanceof SavedSearch)) {
                        return;
                    }
                    EditSavedSearchController.this.showAdvancedSearchDialog((SavedSearch)element);
                }
            }
        }
    };

    public EditSavedSearchController() {
        this.listen();
    }

    private void listen() {
        SavedSearchesPopupMenu.INSTANCE.getItemEdit().addActionListener(this);
        JXList savedSearchesList = GUI.getSavedSearchesList();
        savedSearchesList.addKeyListener(this);
        savedSearchesList.addMouseListener(this.mouseListener);
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        Object value;
        JXList list = GUI.getSavedSearchesList();
        if (KeyEventUtil.isMenuShortcut(evt, 69) && !list.isSelectionEmpty() && (value = list.getSelectedValue()) instanceof SavedSearch) {
            this.showAdvancedSearchDialog((SavedSearch)value);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.showAdvancedSearchDialog(SavedSearchesPopupMenu.INSTANCE.getSavedSearch());
    }

    private void showAdvancedSearchDialog(SavedSearch savedSearch) {
        AdvancedSearchDialog.INSTANCE.getAdvancedSearchPanel().setSavedSearch(savedSearch);
        ComponentUtil.show(AdvancedSearchDialog.INSTANCE);
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }
}

