/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.search;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.storage.Persistence;
import org.jphototagger.domain.event.listener.ListenerSupport;
import org.jphototagger.domain.metadata.search.ParamStatement;
import org.jphototagger.domain.metadata.search.SavedSearch;
import org.jphototagger.domain.metadata.search.SavedSearchPanel;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.TabOrEnterLeavingTextArea;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.swing.util.MnemonicUtil;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.datatransfer.DropListTransferHandler;
import org.jphototagger.program.datatransfer.DropTextComponentTransferHandler;
import org.jphototagger.program.factory.ControllerFactory;
import org.jphototagger.program.module.editmetadata.EditRepeatableTextEntryPanel;
import org.jphototagger.program.module.search.AdvancedSearchController;
import org.jphototagger.program.module.search.NameListener;
import org.jphototagger.program.module.search.SavedSearchesUtil;
import org.jphototagger.program.module.search.SearchMetaDataValuePanel;
import org.openide.util.Lookup;

public final class AdvancedSearchPanel
extends JPanel
implements Persistence {
    private static final String KEY_SELECTED_TAB_INDEX = "AdvancedSearchPanel.SelectedTabIndex";
    private static final long serialVersionUID = 1L;
    private final List<SearchMetaDataValuePanel> searchColumnPanels = new LinkedList<SearchMetaDataValuePanel>();
    private final Map<Component, Component> defaultInputOfComponent = new HashMap<Component, Component>();
    private final Map<JButton, SearchMetaDataValuePanel> searchPanelOfRemoveButton = new HashMap<JButton, SearchMetaDataValuePanel>();
    private String searchName;
    private boolean isSavedSearch;
    private boolean columnRemoved;
    private boolean customSqlChanged;
    private final transient ListenerSupport<NameListener> ls = new ListenerSupport();
    private final JPanel panelPadding = new JPanel();
    private JButton buttonAddColumn;
    private JButton buttonResetColumns;
    private JButton buttonSaveAs;
    private JButton buttonSaveSearch;
    private JButton buttonSearch;
    private JLabel labelCustomSqlInfo;
    private JLabel labelInfoDelete;
    private JLabel labelInfoKeywords;
    private JPanel panelButtons;
    private JPanel panelColumns;
    private JPanel panelCustomSql;
    private JPanel panelKeywords;
    private EditRepeatableTextEntryPanel panelKeywordsInput;
    private JPanel panelSimpleSql;
    private JScrollPane scrollPaneColumns;
    private JScrollPane scrollPaneCustomSqlQuery;
    private JTabbedPane tabbedPane;
    private JTextArea textAreaCustomSqlQuery;

    public AdvancedSearchPanel() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.setUndefinedSearchName();
        this.panelPadding.setSize(10, 2);
        this.listenToSearchPanels();
        this.setAutocomplete();
        this.panelKeywordsInput.setBundleKeyPosRenameDialog("AdvancedSearchPanel.Keywords.RenameDialog.Pos");
        this.setDefaultInputOfComponent();
        this.setFocusToInputInTab(this.tabbedPane.getSelectedComponent());
        MnemonicUtil.setMnemonics(this);
    }

    private void setUndefinedSearchName() {
        this.setSearchName(Bundle.getString(AdvancedSearchPanel.class, "AdvancedSearchPanel.UndefinedName", new Object[0]));
    }

    private void setAutocomplete() {
        if (this.isAutocomplete()) {
            this.panelKeywordsInput.enableAutocomplete();
        }
    }

    private boolean isAutocomplete() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        return prefs == null ? true : (prefs.containsKey("UserSettings.EnableAutoComplete") ? prefs.getBoolean("UserSettings.EnableAutoComplete") : true);
    }

    private void setDefaultInputOfComponent() {
        this.defaultInputOfComponent.put(this.panelKeywords, this.panelKeywordsInput.textAreaInput);
        this.defaultInputOfComponent.put(this.panelCustomSql, this.textAreaCustomSqlQuery);
    }

    private void addPanelPadding() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        this.panelColumns.add((Component)this.panelPadding, gbc);
    }

    private void setFirstColumn() {
        if (!this.searchColumnPanels.isEmpty()) {
            SearchMetaDataValuePanel scp = this.searchColumnPanels.get(0);
            this.defaultInputOfComponent.put(this.panelSimpleSql, scp.getTextFieldValue());
        }
    }

    public void empty() {
        this.removeAllColumns();
        this.emptyKeywordsPanel();
        this.textAreaCustomSqlQuery.setText("");
        this.setUndirty();
    }

    private void emptyKeywordsPanel() {
        ListModel model = this.panelKeywordsInput.getList().getModel();
        if (model instanceof DefaultListModel) {
            ((DefaultListModel)model).clear();
        }
        this.panelKeywordsInput.getTextArea().setText("");
    }

    public void willDispose() {
        this.checkChanged();
        this.setUndirty();
        this.setUndefinedSearchName();
    }

    private void setUndirty() {
        this.isSavedSearch = false;
        this.columnRemoved = false;
        this.customSqlChanged = false;
        this.panelKeywordsInput.setDirty(false);
        this.setSearchColumnPanelsUnchanged();
    }

    private void setSearchColumnPanelsUnchanged() {
        for (SearchMetaDataValuePanel panel : this.searchColumnPanels) {
            panel.setChanged(false);
        }
    }

    @Override
    public void restore() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        if (prefs.containsKey(KEY_SELECTED_TAB_INDEX)) {
            this.tabbedPane.setSelectedIndex(prefs.getInt(KEY_SELECTED_TAB_INDEX));
        }
    }

    @Override
    public void persist() {
        Preferences prefs = Lookup.getDefault().lookup(Preferences.class);
        prefs.setInt(KEY_SELECTED_TAB_INDEX, this.tabbedPane.getSelectedIndex());
    }

    private boolean checkIsSearchValid() {
        if (!this.checkSearchTypeIsValid()) {
            return false;
        }
        if (this.existsCustomSqlText()) {
            return true;
        }
        boolean valid = this.existsKeywords();
        int columnCount = this.searchColumnPanels.size();
        for (int index = 0; !valid && index < columnCount; ++index) {
            SearchMetaDataValuePanel searchColumnPanel = this.searchColumnPanels.get(index);
            String value = searchColumnPanel.getValue();
            valid = !value.isEmpty();
        }
        boolean bl = valid = valid && this.checkBrackets();
        if (!valid) {
            String message = Bundle.getString(AdvancedSearchPanel.class, "AdvancedSearchPanel.Error.InvalidQuery", new Object[0]);
            MessageDisplayer.error(this, message);
        }
        return valid;
    }

    private boolean checkSearchTypeIsValid() {
        boolean valid;
        boolean customSqlTextExists = this.existsCustomSqlText();
        boolean keywordsExisting = this.existsKeywords();
        boolean simpleSqlValueExists = this.existsSimpleSqlValue();
        boolean bl = valid = !customSqlTextExists || customSqlTextExists && !keywordsExisting && !simpleSqlValueExists;
        if (!valid) {
            String message = Bundle.getString(AdvancedSearchPanel.class, "AdvancedSearchPanel.Error.SearchTypeInvalid", new Object[0]);
            MessageDisplayer.error(this, message);
            return false;
        }
        return true;
    }

    private boolean checkBrackets() {
        int countOpenBrackets = 0;
        int countClosedBrackets = 0;
        for (SearchMetaDataValuePanel panel : this.searchColumnPanels) {
            countOpenBrackets += panel.getCountOpenBrackets();
            countClosedBrackets += panel.getCountClosedBrackets();
        }
        return countOpenBrackets == countClosedBrackets;
    }

    private void search() {
        if (this.checkIsSearchValid()) {
            ControllerFactory.INSTANCE.getController(AdvancedSearchController.class).actionPerformed(null);
        }
    }

    private void listenToSearchPanels() {
        for (SearchMetaDataValuePanel panel : this.searchColumnPanels) {
            panel.getTextFieldValue().addKeyListener(new KeyListener());
        }
    }

    public SavedSearch createSavedSearch() {
        SavedSearch savedSearch = new SavedSearch();
        savedSearch.setName(this.searchName);
        savedSearch.setKeywords(this.getKeywords());
        this.setSavedSearchPanels(savedSearch);
        savedSearch.setCustomSql(this.textAreaCustomSqlQuery.getText().trim());
        savedSearch.setType(this.existsCustomSqlText() ? SavedSearch.Type.CUSTOM_SQL : SavedSearch.Type.KEYWORDS_AND_PANELS);
        return savedSearch;
    }

    public void setSavedSearch(SavedSearch search) {
        if (search == null) {
            throw new NullPointerException("search == null");
        }
        if (!search.isValid()) {
            return;
        }
        this.clearInput(true);
        this.isSavedSearch = true;
        this.setSearchName(search.getName());
        if (search.hasPanels()) {
            this.setSavedSearchPanels(search.getPanels());
        }
        if (search.hasKeywords()) {
            this.setKeywordsToPanel(search);
        }
        this.setCustomSqlToPanel(search);
        JPanel selPanel = this.existsCustomSqlText() ? this.panelCustomSql : (this.existsSimpleSqlValue() ? this.panelSimpleSql : this.panelKeywords);
        this.setSelectedComponent(selPanel);
        this.customSqlChanged = false;
        this.columnRemoved = false;
    }

    private void setSavedSearchPanels(List<SavedSearchPanel> panels) {
        int panelCount = panels.size();
        this.removeAllColumns();
        this.ensureColumnCount(panelCount);
        int columnCount = this.searchColumnPanels.size();
        for (int i = 0; i < panelCount; ++i) {
            if (i >= columnCount) continue;
            this.searchColumnPanels.get(i).setSavedSearchPanel(panels.get(i));
        }
        this.addPanelPadding();
    }

    private void removeAllColumns() {
        this.searchColumnPanels.clear();
        this.panelColumns.removeAll();
        this.searchPanelOfRemoveButton.clear();
    }

    private void setKeywordsToPanel(SavedSearch search) {
        this.panelKeywordsInput.setTexts(search.getKeywords());
        if (!this.existsSimpleSqlValue()) {
            this.setSelectedComponent(this.panelKeywords);
        }
    }

    private void setCustomSqlToPanel(SavedSearch search) {
        if (this.existsSimpleSqlValue() || this.existsKeywords()) {
            return;
        }
        ParamStatement stmt = search.createParamStatement();
        this.textAreaCustomSqlQuery.setText(stmt.getSql());
        this.setSelectedComponent(this.panelCustomSql);
    }

    private void setSelectedComponent(Component c) {
        this.tabbedPane.setSelectedComponent(c);
        this.persist();
    }

    private boolean existsSimpleSqlValue() {
        for (SearchMetaDataValuePanel panel : this.searchColumnPanels) {
            if (panel.getValue().trim().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean existsCustomSqlText() {
        return !this.textAreaCustomSqlQuery.getText().trim().isEmpty();
    }

    private void ensureColumnCount(int count) {
        int currentCount = this.searchColumnPanels.size();
        if (currentCount >= count) {
            return;
        }
        for (int i = currentCount; i < count; ++i) {
            this.addColumn();
        }
    }

    private void addColumn() {
        GridBagConstraints gbc = this.getColumnGridBagConstraints();
        SearchMetaDataValuePanel scPanel = new SearchMetaDataValuePanel();
        this.panelColumns.remove(this.panelPadding);
        this.panelColumns.add((Component)scPanel, gbc);
        this.addPanelPadding();
        this.searchColumnPanels.add(scPanel);
        this.searchPanelOfRemoveButton.put(scPanel.buttonRemoveColumn, scPanel);
        scPanel.buttonRemoveColumn.addActionListener(new RemoveButtonListener());
        this.setFirstColumn();
        scPanel.getTextFieldValue().addKeyListener(new KeyListener());
        ComponentUtil.forceRepaint(this);
    }

    private GridBagConstraints getColumnGridBagConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        return gbc;
    }

    private void removeColumn(SearchMetaDataValuePanel scPanel) {
        this.panelColumns.remove(this.panelPadding);
        this.panelColumns.remove(scPanel);
        this.addPanelPadding();
        this.searchColumnPanels.remove(scPanel);
        this.searchPanelOfRemoveButton.remove(scPanel.buttonRemoveColumn);
        if (scPanel.canCreateSql()) {
            this.columnRemoved = true;
        }
        this.setFirstColumn();
        ComponentUtil.forceRepaint(this);
    }

    private void clearInput(boolean allPanels) {
        this.checkChanged();
        Component selComponent = this.tabbedPane.getSelectedComponent();
        if (allPanels || selComponent == this.panelSimpleSql) {
            for (SearchMetaDataValuePanel panel : this.searchColumnPanels) {
                panel.reset();
            }
        }
        if (allPanels || selComponent == this.panelKeywords) {
            this.panelKeywordsInput.setTexts(new ArrayList<String>());
        }
        if (allPanels || selComponent == this.panelCustomSql) {
            this.textAreaCustomSqlQuery.setText("");
        }
        this.setUndirty();
    }

    private void checkChanged() {
        String message;
        if ((this.columnRemoved || this.columnChanged() || this.customSqlChanged || this.panelKeywordsInput.isDirty()) && MessageDisplayer.confirmYesNo(this, message = Bundle.getString(AdvancedSearchPanel.class, "AdvancedSearchPanel.Confirm.SaveChanges", new Object[0]))) {
            this.save(this.createSavedSearch(), true);
        }
    }

    private boolean columnChanged() {
        for (SearchMetaDataValuePanel panel : this.searchColumnPanels) {
            if (!panel.isChanged()) continue;
            return true;
        }
        return false;
    }

    private void setFocusToInputInTab(Component selectedComponent) {
        if (selectedComponent == null) {
            return;
        }
        Component input = this.defaultInputOfComponent.get(selectedComponent);
        if (input != null) {
            input.requestFocusInWindow();
        }
    }

    private void save() {
        if (!this.checkIsSearchValid()) {
            return;
        }
        this.save(this.createSavedSearch(), this.isSavedSearch);
    }

    private void saveAs() {
        if (!this.checkIsSearchValid()) {
            return;
        }
        String suggestName = this.searchName == null ? "" : this.searchName;
        String name = SavedSearchesUtil.getNotExistingName(suggestName);
        if (name != null && !name.isEmpty()) {
            SavedSearch savedSearch = this.createSavedSearch();
            savedSearch.setName(name);
            this.save(savedSearch, false);
        }
    }

    private void save(SavedSearch savedSearch, boolean update) {
        boolean saved;
        boolean bl = saved = update ? SavedSearchesUtil.update(savedSearch) : SavedSearchesUtil.insert(savedSearch);
        if (saved) {
            this.setSearchName(savedSearch.getName());
            this.setUndirty();
            this.isSavedSearch = true;
        }
    }

    private void setSavedSearchPanels(SavedSearch search) {
        ArrayList<SavedSearchPanel> panels = new ArrayList<SavedSearchPanel>();
        int size = this.searchColumnPanels.size();
        int pIndex = 0;
        for (int index = 0; index < size; ++index) {
            SearchMetaDataValuePanel panel = this.searchColumnPanels.get(index);
            SavedSearchPanel savedSearchPanel = panel.getSavedSearchPanel();
            if (!savedSearchPanel.hasValue()) continue;
            savedSearchPanel.setPanelIndex(pIndex);
            ++pIndex;
            panels.add(savedSearchPanel);
        }
        search.setPanels(panels);
    }

    private void setSearchName(String name) {
        this.searchName = name;
        this.notifyNameChanged();
    }

    public void addNameListener(NameListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        this.ls.add(listener);
    }

    public void removeNameListener(NameListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        this.ls.remove(listener);
    }

    private void notifyNameChanged() {
        for (NameListener listener : this.ls.get()) {
            listener.nameChanged(this.searchName);
        }
    }

    private boolean existsKeywords() {
        return !this.getKeywords().isEmpty();
    }

    private List<String> getKeywords() {
        String textFieldText = this.panelKeywordsInput.getText();
        Collection<String> listText = this.panelKeywordsInput.getRepeatableText();
        ArrayList<String> keywords = new ArrayList<String>(listText);
        if (!textFieldText.isEmpty()) {
            keywords.add(textFieldText);
        }
        return keywords;
    }

    public JButton getButtonSearch() {
        return this.buttonSearch;
    }

    public String getSearchName() {
        return this.searchName;
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.panelKeywords = new JPanel();
        this.labelInfoKeywords = new JLabel();
        this.panelKeywordsInput = new EditRepeatableTextEntryPanel();
        this.panelKeywordsInput.setPrompt("");
        this.panelKeywordsInput.getTextArea().setTransferHandler(new DropTextComponentTransferHandler());
        this.panelKeywordsInput.getList().setTransferHandler(new DropListTransferHandler());
        this.panelSimpleSql = new JPanel();
        this.scrollPaneColumns = new JScrollPane();
        this.panelColumns = new JPanel();
        this.labelInfoDelete = new JLabel();
        this.buttonAddColumn = new JButton();
        this.panelCustomSql = new JPanel();
        this.labelCustomSqlInfo = new JLabel();
        this.scrollPaneCustomSqlQuery = new JScrollPane();
        this.textAreaCustomSqlQuery = new TabOrEnterLeavingTextArea();
        this.textAreaCustomSqlQuery.setTransferHandler(new DropTextComponentTransferHandler());
        this.textAreaCustomSqlQuery.getDocument().addDocumentListener(new CustomSqlChangeListener());
        this.panelButtons = new JPanel();
        this.buttonSaveSearch = new JButton();
        this.buttonSaveAs = new JButton();
        this.buttonResetColumns = new JButton();
        this.buttonSearch = new JButton();
        this.setName("Form");
        this.setLayout(new GridBagLayout());
        this.tabbedPane.setName("tabbedPane");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                AdvancedSearchPanel.this.tabbedPaneStateChanged(evt);
            }
        });
        this.tabbedPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                AdvancedSearchPanel.this.tabbedPaneFocusGained(evt);
            }
        });
        this.panelKeywords.setName("panelKeywords");
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/search/Bundle");
        this.labelInfoKeywords.setText(bundle.getString("AdvancedSearchPanel.labelInfoKeywords.text"));
        this.labelInfoKeywords.setName("labelInfoKeywords");
        this.panelKeywordsInput.setName("panelKeywordsInput");
        GroupLayout panelKeywordsLayout = new GroupLayout(this.panelKeywords);
        this.panelKeywords.setLayout(panelKeywordsLayout);
        panelKeywordsLayout.setHorizontalGroup(panelKeywordsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelKeywordsLayout.createSequentialGroup().addContainerGap().addGroup(panelKeywordsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelKeywordsInput, -1, 636, Short.MAX_VALUE).addComponent(this.labelInfoKeywords, -2, -1, -2)).addContainerGap()));
        panelKeywordsLayout.setVerticalGroup(panelKeywordsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelKeywordsLayout.createSequentialGroup().addContainerGap().addComponent(this.labelInfoKeywords, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelKeywordsInput, -1, 158, Short.MAX_VALUE).addContainerGap()));
        this.tabbedPane.addTab(bundle.getString("AdvancedSearchPanel.panelKeywords.TabConstraints.tabTitle"), this.panelKeywords);
        this.panelSimpleSql.setName("panelSimpleSql");
        this.scrollPaneColumns.setBorder(null);
        this.scrollPaneColumns.setName("scrollPaneColumns");
        this.panelColumns.setName("panelColumns");
        this.panelColumns.setLayout(new GridBagLayout());
        this.scrollPaneColumns.setViewportView(this.panelColumns);
        this.labelInfoDelete.setText(bundle.getString("AdvancedSearchPanel.labelInfoDelete.text"));
        this.labelInfoDelete.setName("labelInfoDelete");
        this.buttonAddColumn.setText(bundle.getString("AdvancedSearchPanel.buttonAddColumn.text"));
        this.buttonAddColumn.setName("buttonAddColumn");
        this.buttonAddColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedSearchPanel.this.buttonAddColumnActionPerformed(evt);
            }
        });
        GroupLayout panelSimpleSqlLayout = new GroupLayout(this.panelSimpleSql);
        this.panelSimpleSql.setLayout(panelSimpleSqlLayout);
        panelSimpleSqlLayout.setHorizontalGroup(panelSimpleSqlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelSimpleSqlLayout.createSequentialGroup().addContainerGap().addGroup(panelSimpleSqlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPaneColumns, GroupLayout.Alignment.TRAILING, -1, 632, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, panelSimpleSqlLayout.createSequentialGroup().addComponent(this.labelInfoDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 341, Short.MAX_VALUE).addComponent(this.buttonAddColumn))).addContainerGap()));
        panelSimpleSqlLayout.setVerticalGroup(panelSimpleSqlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelSimpleSqlLayout.createSequentialGroup().addContainerGap().addComponent(this.scrollPaneColumns, -1, 149, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelSimpleSqlLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonAddColumn).addComponent(this.labelInfoDelete)).addContainerGap()));
        this.tabbedPane.addTab(bundle.getString("AdvancedSearchPanel.panelSimpleSql.TabConstraints.tabTitle"), this.panelSimpleSql);
        this.panelCustomSql.setName("panelCustomSql");
        this.panelCustomSql.setLayout(new GridBagLayout());
        this.labelCustomSqlInfo.setDisplayedMnemonic('k');
        this.labelCustomSqlInfo.setText(bundle.getString("AdvancedSearchPanel.labelCustomSqlInfo.text"));
        this.labelCustomSqlInfo.setName("labelCustomSqlInfo");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelCustomSql.add((Component)this.labelCustomSqlInfo, gridBagConstraints);
        this.scrollPaneCustomSqlQuery.setName("scrollPaneCustomSqlQuery");
        this.textAreaCustomSqlQuery.setColumns(20);
        this.textAreaCustomSqlQuery.setLineWrap(true);
        this.textAreaCustomSqlQuery.setRows(2);
        this.textAreaCustomSqlQuery.setName("textAreaCustomSqlQuery");
        this.scrollPaneCustomSqlQuery.setViewportView(this.textAreaCustomSqlQuery);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelCustomSql.add((Component)this.scrollPaneCustomSqlQuery, gridBagConstraints);
        this.tabbedPane.addTab(bundle.getString("AdvancedSearchPanel.panelCustomSql.TabConstraints.tabTitle"), this.panelCustomSql);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.tabbedPane, gridBagConstraints);
        this.panelButtons.setName("panelButtons");
        this.panelButtons.setLayout(new GridLayout(1, 0, 3, 0));
        this.buttonSaveSearch.setText(bundle.getString("AdvancedSearchPanel.buttonSaveSearch.text"));
        this.buttonSaveSearch.setName("buttonSaveSearch");
        this.buttonSaveSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedSearchPanel.this.buttonSaveSearchActionPerformed(evt);
            }
        });
        this.panelButtons.add(this.buttonSaveSearch);
        this.buttonSaveAs.setText(bundle.getString("AdvancedSearchPanel.buttonSaveAs.text"));
        this.buttonSaveAs.setName("buttonSaveAs");
        this.buttonSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedSearchPanel.this.buttonSaveAsActionPerformed(evt);
            }
        });
        this.panelButtons.add(this.buttonSaveAs);
        this.buttonResetColumns.setText(bundle.getString("AdvancedSearchPanel.buttonResetColumns.text"));
        this.buttonResetColumns.setName("buttonResetColumns");
        this.buttonResetColumns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedSearchPanel.this.buttonResetColumnsActionPerformed(evt);
            }
        });
        this.panelButtons.add(this.buttonResetColumns);
        this.buttonSearch.setText(bundle.getString("AdvancedSearchPanel.buttonSearch.text"));
        this.buttonSearch.setName("buttonSearch");
        this.panelButtons.add(this.buttonSearch);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 5, 10, 0);
        this.add((Component)this.panelButtons, gridBagConstraints);
    }

    private void buttonSaveSearchActionPerformed(ActionEvent evt) {
        this.save();
    }

    private void buttonSaveAsActionPerformed(ActionEvent evt) {
        this.saveAs();
    }

    private void buttonResetColumnsActionPerformed(ActionEvent evt) {
        this.clearInput(false);
    }

    private void buttonAddColumnActionPerformed(ActionEvent evt) {
        this.addColumn();
    }

    private void tabbedPaneStateChanged(ChangeEvent evt) {
        this.setFocusToInputInTab(this.tabbedPane.getSelectedComponent());
    }

    private void tabbedPaneFocusGained(FocusEvent evt) {
        this.setFocusToInputInTab(this.tabbedPane.getSelectedComponent());
    }

    private class RemoveButtonListener
    implements ActionListener {
        private RemoveButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            assert (evt.getSource() instanceof JButton) : evt.getSource();
            SearchMetaDataValuePanel panel = (SearchMetaDataValuePanel)AdvancedSearchPanel.this.searchPanelOfRemoveButton.get((JButton)evt.getSource());
            if (panel != null) {
                AdvancedSearchPanel.this.removeColumn(panel);
            }
        }
    }

    private class KeyListener
    extends KeyAdapter {
        private KeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent evt) {
            if (evt.getKeyCode() == 10) {
                AdvancedSearchPanel.this.search();
            }
        }
    }

    private class CustomSqlChangeListener
    implements DocumentListener {
        private CustomSqlChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            AdvancedSearchPanel.this.customSqlChanged = true;
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            AdvancedSearchPanel.this.customSqlChanged = true;
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
            AdvancedSearchPanel.this.customSqlChanged = true;
        }
    }
}

