/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.program.module.search;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.SwingUtilities;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.lib.api.LookAndFeelChangedEvent;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.program.module.search.AdvancedSearchPanel;
import org.jphototagger.program.module.search.NameListener;
import org.jphototagger.program.resource.GUI;

public final class AdvancedSearchDialog
extends Dialog
implements NameListener {
    public static final AdvancedSearchDialog INSTANCE = new AdvancedSearchDialog(false);
    private static final long serialVersionUID = 1L;
    private AdvancedSearchPanel panel;

    private AdvancedSearchDialog(boolean modal) {
        super((Frame)GUI.getAppFrame(), modal);
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.panel.addNameListener(this);
        AnnotationProcessor.process(this);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.panel.restore();
            this.setSearchName(this.panel.getSearchName());
        }
        super.setVisible(visible);
    }

    private void beforeWindowClosing() {
        this.panel.persist();
        this.panel.willDispose();
        this.setVisible(false);
    }

    public AdvancedSearchPanel getPanel() {
        return this.panel;
    }

    @Override
    protected void showHelp() {
        this.showHelp(Bundle.getString(AdvancedSearchDialog.class, "AdvancedSearchDialog.HelpPage", new Object[0]));
    }

    @Override
    protected void escape() {
        this.beforeWindowClosing();
    }

    public AdvancedSearchPanel getAdvancedSearchPanel() {
        return this.panel;
    }

    @Override
    public void nameChanged(String name) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        this.setSearchName(name);
    }

    private void setSearchName(String name) {
        String delimiter = ": ";
        this.setTitle(Bundle.getString(AdvancedSearchDialog.class, "AdvancedSearchDialog.TitlePrefix", new Object[0]) + delimiter + name);
    }

    @EventSubscriber(eventClass=LookAndFeelChangedEvent.class)
    public void lookAndFeelChanged(LookAndFeelChangedEvent evt) {
        SwingUtilities.updateComponentTreeUI(this);
    }

    private void initComponents() {
        this.panel = new AdvancedSearchPanel();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/program/module/search/Bundle");
        this.setTitle(bundle.getString("AdvancedSearchDialog.title"));
        this.setName("Form");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AdvancedSearchDialog.this.formWindowClosing(evt);
            }
        });
        this.panel.setName("panel");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.panel, -1, 595, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.beforeWindowClosing();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AdvancedSearchDialog dialog = new AdvancedSearchDialog(true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

